/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.msg.data;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import com.common.gmacs.R;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.utils.GmacsEnvi;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class IMAudioMsg
extends IMMessage {
    public String extra;
    public long mDuration;
    public String mLocalUrl;
    public String mUrl;
    public SpannableStringBuilder style;

    public IMAudioMsg() {
        super("audio");
    }

    @Override
    public String getPlainText() {
        return "[\u8bed\u97f3]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SpannableStringBuilder getPlainTextSpannableStringBuilder(Context context) {
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            context = !this.parentMsg.mIsSelfSendMsg && this.parentMsg.getMsgPlayStatus() == 0 ? new ForegroundColorSpan(context.getResources().getColor(R.color.red)) : new ForegroundColorSpan(context.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)context, 0, 4, 34);
        }
        return this.style;
    }

    @Override
    public boolean isShowSenderName() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void parse(JSONObject jSONObject) {
        this.mUrl = jSONObject.optString("url");
        this.mDuration = jSONObject.optLong("duration");
        this.mLocalUrl = jSONObject.optString("fileInSDPath");
        this.extra = jSONObject.optString("extra");
        if (!TextUtils.isEmpty((CharSequence)this.mLocalUrl) && !new File(this.mLocalUrl).exists()) {
            this.mLocalUrl = null;
        }
        if (this.style == null) {
            this.style = new SpannableStringBuilder((CharSequence)this.getPlainText());
            jSONObject = !this.parentMsg.mIsSelfSendMsg && this.parentMsg.getMsgPlayStatus() == 0 ? new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.red)) : new ForegroundColorSpan(GmacsEnvi.appContext.getResources().getColor(R.color.gray_808080));
            this.style.setSpan((Object)jSONObject, 0, 4, 34);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void putInfoToJson(JSONObject jSONObject) {
        try {
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("duration", this.mDuration);
            jSONObject.put("fileInSDPath", (Object)this.mLocalUrl);
            jSONObject.put("extra", (Object)this.extra);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }
}

