/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.downloader;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import com.common.gmacs.R;
import com.common.gmacs.downloader.BasicNetwork;
import com.common.gmacs.downloader.Cache;
import com.common.gmacs.downloader.DiskBasedCache;
import com.common.gmacs.downloader.HttpStack;
import com.common.gmacs.downloader.HurlStack;
import com.common.gmacs.downloader.Network;
import com.common.gmacs.downloader.Request;
import com.common.gmacs.downloader.RequestManager;
import com.common.gmacs.downloader.RequestQueue;
import com.common.gmacs.downloader.audio.AudioRequest;
import com.common.gmacs.downloader.image.ImageLoader;
import com.common.gmacs.utils.FileUtil;
import com.common.gmacs.utils.GmacsEnvi;
import java.io.File;

public class RequestManager {
    public static final int ImgResize = GmacsEnvi.appContext.getResources().getDimensionPixelOffset(R.dimen.im_chat_msg_pic_msg_width);
    public static final int MinResize = GmacsEnvi.appContext.getResources().getDimensionPixelOffset(R.dimen.im_chat_msg_pic_min_size);
    private static volatile RequestManager ourInstance;
    private String cacheDir;
    private LruCache<String, Bitmap> imageCache;
    private ImageLoader.ImageCache imageCacheWrapper;
    private ImageLoader imageLoader;
    private ImageLoader noL1CacheImageLoader;
    private RequestQueue requestQueue;

    private RequestManager() {
    }

    static /* synthetic */ LruCache access$000(RequestManager requestManager) {
        return requestManager.imageCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RequestManager getInstance() {
        if (ourInstance == null) {
            synchronized (RequestManager.class) {
                if (ourInstance == null) {
                    RequestManager requestManager;
                    ourInstance = requestManager = new RequestManager();
                }
            }
        }
        return ourInstance;
    }

    private RequestQueue newRequestQueue(String string2) {
        File file = FileUtil.getCacheDir(string2);
        string2 = new BasicNetwork((HttpStack)new HurlStack());
        return new RequestQueue((Cache)new DiskBasedCache(file), (Network)string2);
    }

    public void fireAudioRequest(AudioRequest audioRequest) {
        if (this.requestQueue != null) {
            this.requestQueue.add((Request)audioRequest);
        }
    }

    public ImageLoader getImageLoader() {
        if (this.imageCache == null) {
            this.imageCache = new 1(this, ((ActivityManager)GmacsEnvi.appContext.getSystemService("activity")).getMemoryClass() * 0x100000 / 2);
            this.imageCacheWrapper = new 2(this);
        }
        if (this.imageLoader == null) {
            this.imageLoader = new ImageLoader(this.requestQueue, this.imageCacheWrapper);
        }
        return this.imageLoader;
    }

    public ImageLoader getNoL1CacheImageLoader() {
        if (this.noL1CacheImageLoader == null) {
            this.noL1CacheImageLoader = new ImageLoader(this.requestQueue, null);
        }
        return this.noL1CacheImageLoader;
    }

    public void init(String string2) {
        if (!string2.equals(this.cacheDir)) {
            this.cacheDir = string2;
            if (this.requestQueue != null) {
                this.requestQueue.stop();
                this.imageLoader = null;
                this.noL1CacheImageLoader = null;
            }
            this.requestQueue = this.newRequestQueue(this.cacheDir);
            this.requestQueue.start();
        }
    }
}

