/*
 * Decompiled with CFR 0.152.
 */
package com.common.gmacs.core;

import android.app.Application;
import com.common.gmacs.R;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import org.json.JSONException;
import org.json.JSONObject;

public class Gmacs {
    public static final int SERVER_INTEGRATE = 4;
    public static final int SERVER_ONLINE = 0;
    public static final int SERVER_PREREALEASE = 3;
    public static final int SERVER_QATEST = 2;
    public static final int SERVER_RDTEST = 1;
    private static final String TAG = Gmacs.class.getSimpleName();
    private static Gmacs instance = new Gmacs();
    private GmacsUserInfo gmacsUserInfo;
    private boolean isWMDAEnabled;
    private int serverEnvi;

    private Gmacs() {
    }

    public static Gmacs getInstance() {
        return instance;
    }

    public GmacsUserInfo getGmacsUserInfo() {
        return this.gmacsUserInfo;
    }

    public int getServerEnvi() {
        return this.serverEnvi;
    }

    public void initialize(Application application) {
        GmacsEnvi.initialize(application);
    }

    public boolean isWMDAEnabled() {
        return this.isWMDAEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loginAsync(String string2, String string3, int n2, String string4, String string5, int n3, ClientManager.LoginCb loginCb) {
        if (this.gmacsUserInfo == null) {
            GLog.e(TAG, "\u767b\u9646\u524d\u5fc5\u987b\u4f20\u5165\u900f\u4f20\u5b57\u6bb5\uff0cGmacsUserInfo");
            return;
        }
        ClientManager.getInstance().loginAsync(string2, string3, n2, string4, string5, n3, loginCb);
    }

    public void setGmacsUserInfo(GmacsUserInfo gmacsUserInfo) {
        this.gmacsUserInfo = gmacsUserInfo;
    }

    public void setLoggable(boolean bl2) {
        GLog.loggable = bl2;
    }

    public void setServerEnvi(int n2) {
        this.serverEnvi = n2;
        ClientManager.getInstance().setServerLevel(n2);
    }

    public boolean setWMDAEnabled(boolean bl2) {
        this.isWMDAEnabled = bl2;
        return bl2;
    }

    public static enum BusinessSource {
        BUSINESSSOURCE_UNKNOWN(0),
        BUSINESSSOURCE_QIANGKEHU(1),
        BUSINESSSOURCE_BANGTAZHAOFANG(2);

        private int value;

        private BusinessSource(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class ContentWrapper {
        private JSONObject data;
        private int errorCode;
        private String errorMessage;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ContentWrapper parseContentWrapper(String string2) {
            ContentWrapper contentWrapper = null;
            try {
                JSONObject jSONObject = new JSONObject(string2);
                string2 = jSONObject;
            }
            catch (JSONException jSONException) {
                string2 = null;
            }
            if (string2 != null) {
                contentWrapper = new ContentWrapper();
                contentWrapper.errorCode = string2.optInt("error_code");
                contentWrapper.errorMessage = string2.optString("error_msg");
                contentWrapper.data = string2.optJSONObject("data");
            }
            return contentWrapper;
        }

        public JSONObject getData() {
            return this.data;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum Error {
        ERROR_MESSAGE_CONTENT_OVERFLOW(30001, GmacsEnvi.appContext.getString(R.string.error_message_content_overflow)),
        ERROR_INVALID_LOCAL_PATH(30004, GmacsEnvi.appContext.getString(R.string.error_invalid_local_path)),
        ERROR_JSON_PARSE(32002, GmacsEnvi.appContext.getString(R.string.error_json_parse));

        private int errorCode;
        private String errorMessage;

        private Error(int n3, String string3) {
            this.errorCode = n3;
            this.errorMessage = string3;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum Gender {
        GENDER_UNKNOWN(0),
        GENDER_MALE(1),
        GENDER_FEMALE(2);

        private int value;

        private Gender(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TalkType {
        TALKETYPE_SYSTEM(1),
        TALKETYPE_NORMAL(2),
        TALKETYPE_OFFICIAL(3),
        TALKETYPE_USER_REQUEST(4),
        TALKETYPE_POSTINGS(15),
        TALKETYPE_GROUP(1005);

        private int value;

        private TalkType(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum UserSource {
        USERSOURCE_NEW(0),
        USERSOURCE_ANJUKE(1),
        USERSOURCE_58(2),
        USERSOURCE_GANJI(3),
        USERSOURCE_ANJUKEWEILIAO(4),
        USERSOURCE_WUMI(5),
        USERSOURCE_YINGCAI(6);

        private int value;

        private UserSource(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum UserType {
        USERTYPE_UNKNOWN(0),
        USERTYPE_NORMAL(1),
        USERTYPE_MIDDLEMAN(2),
        USERTYPE_SYSTEM(3),
        USERTYPE_OFFICIAL(4),
        USERTYPE_SERVICE_EXTERNAL(5),
        USERTYPE_SERVICE_INTERNAL(6),
        USERTYPE_SERVICE_INFORMATION(7);

        private int value;

        private UserType(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

