/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class TransformationUtils {
    public static final int PAINT_FLAGS = 6;
    private static final String TAG = "TransformationUtils";

    private TransformationUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap centerCrop(Bitmap bitmap, Bitmap bitmap2, int n2, int n3) {
        float f2;
        float f3;
        Bitmap bitmap3;
        float f4 = 0.0f;
        if (bitmap2 == null) {
            return null;
        }
        if (bitmap2.getWidth() == n2) {
            bitmap3 = bitmap2;
            if (bitmap2.getHeight() == n3) return bitmap3;
        }
        bitmap3 = new Matrix();
        if (bitmap2.getWidth() * n3 > bitmap2.getHeight() * n2) {
            f3 = (float)n3 / (float)bitmap2.getHeight();
            f2 = ((float)n2 - (float)bitmap2.getWidth() * f3) * 0.5f;
        } else {
            f3 = (float)n2 / (float)bitmap2.getWidth();
            float f5 = n3;
            f4 = bitmap2.getHeight();
            f2 = 0.0f;
            f4 = (f5 - f4 * f3) * 0.5f;
        }
        bitmap3.setScale(f3, f3);
        bitmap3.postTranslate((float)((int)(f2 + 0.5f)), (float)((int)(f4 + 0.5f)));
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)TransformationUtils.getSafeConfig(bitmap2));
        }
        TransformationUtils.setAlpha(bitmap2, bitmap);
        new Canvas(bitmap).drawBitmap(bitmap2, (Matrix)bitmap3, new Paint(6));
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap fitCenter(Bitmap bitmap, BitmapPool bitmapPool, int n2, int n3) {
        if (bitmap.getWidth() == n2 && bitmap.getHeight() == n3) {
            bitmapPool = bitmap;
            if (!Log.isLoggable((String)TAG, (int)2)) return bitmapPool;
            Log.v((String)TAG, (String)"requested target size matches input, returning input");
            return bitmap;
        }
        float f2 = Math.min((float)n2 / (float)bitmap.getWidth(), (float)n3 / (float)bitmap.getHeight());
        int n4 = (int)((float)bitmap.getWidth() * f2);
        int n5 = (int)((float)bitmap.getHeight() * f2);
        if (bitmap.getWidth() == n4 && bitmap.getHeight() == n5) {
            bitmapPool = bitmap;
            if (!Log.isLoggable((String)TAG, (int)2)) return bitmapPool;
            Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            return bitmap;
        }
        Bitmap.Config config = TransformationUtils.getSafeConfig(bitmap);
        Bitmap bitmap2 = bitmapPool.get(n4, n5, config);
        bitmapPool = bitmap2;
        if (bitmap2 == null) {
            bitmapPool = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)config);
        }
        TransformationUtils.setAlpha(bitmap, (Bitmap)bitmapPool);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("request: " + n2 + "x" + n3));
            Log.v((String)TAG, (String)("toFit:   " + bitmap.getWidth() + "x" + bitmap.getHeight()));
            Log.v((String)TAG, (String)("toReuse: " + bitmapPool.getWidth() + "x" + bitmapPool.getHeight()));
            Log.v((String)TAG, (String)("minPct:   " + f2));
        }
        bitmap2 = new Canvas((Bitmap)bitmapPool);
        config = new Matrix();
        config.setScale(f2, f2);
        bitmap2.drawBitmap(bitmap, (Matrix)config, new Paint(6));
        return bitmapPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getExifOrientationDegrees(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 5: 
            case 6: {
                return 90;
            }
            case 3: 
            case 4: {
                return 180;
            }
            case 7: 
            case 8: 
        }
        return 270;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @TargetApi(value=5)
    public static int getOrientation(String string2) {
        int n2 = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string2);
            return TransformationUtils.getExifOrientationDegrees(exifInterface.getAttributeInt("Orientation", 0));
        }
        catch (Exception exception) {
            int n3 = n2;
            if (!Log.isLoggable((String)TAG, (int)6)) return n3;
            Log.e((String)TAG, (String)("Unable to get orientation for image with path=" + string2), (Throwable)exception);
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap.Config getSafeConfig(Bitmap bitmap) {
        if (bitmap.getConfig() == null) return Bitmap.Config.ARGB_8888;
        return bitmap.getConfig();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void initializeMatrixForRotation(int n2, Matrix matrix) {
        switch (n2) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                return;
            }
            case 3: {
                matrix.setRotate(180.0f);
                return;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 6: {
                matrix.setRotate(90.0f);
                return;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                return;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                return;
            }
        }
    }

    @Deprecated
    public static Bitmap orientImage(String string2, Bitmap bitmap) {
        return TransformationUtils.rotateImage(bitmap, TransformationUtils.getOrientation(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap rotateImage(Bitmap bitmap, int n2) {
        Bitmap bitmap2 = bitmap;
        if (n2 == 0) return bitmap2;
        try {
            bitmap2 = new Matrix();
            bitmap2.setRotate((float)n2);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)bitmap2, (boolean)true);
        }
        catch (Exception exception) {
            bitmap2 = bitmap;
            if (!Log.isLoggable((String)TAG, (int)6)) return bitmap2;
            Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)exception);
            return bitmap;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap rotateImageExif(Bitmap object, BitmapPool bitmapPool, int n2) {
        Bitmap bitmap;
        Bitmap bitmap2;
        void var0_1;
        int n3;
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation(n3, matrix);
        if (matrix.isIdentity()) {
            return var0_1;
        }
        RectF rectF = new RectF(0.0f, 0.0f, (float)object.getWidth(), (float)object.getHeight());
        matrix.mapRect(rectF);
        n3 = Math.round(rectF.width());
        int n4 = Math.round(rectF.height());
        Bitmap.Config config = TransformationUtils.getSafeConfig(object);
        bitmap = bitmap2 = bitmap.get(n3, n4, config);
        if (bitmap2 == null) {
            bitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)config);
        }
        matrix.postTranslate(-rectF.left, -rectF.top);
        new Canvas(bitmap).drawBitmap(object, matrix, new Paint(6));
        Bitmap bitmap3 = bitmap;
        return var0_1;
    }

    @TargetApi(value=12)
    public static void setAlpha(Bitmap bitmap, Bitmap bitmap2) {
        if (Build.VERSION.SDK_INT >= 12 && bitmap2 != null) {
            bitmap2.setHasAlpha(bitmap.hasAlpha());
        }
    }
}

