/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.file_descriptor.FileDescriptorModelLoader;
import com.bumptech.glide.load.model.stream.MediaStoreStreamLoader;
import com.bumptech.glide.load.model.stream.StreamByteArrayLoader;
import com.bumptech.glide.load.model.stream.StreamModelLoader;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.LifecycleListener;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.RequestTracker;
import com.bumptech.glide.signature.ApplicationVersionSignature;
import com.bumptech.glide.signature.MediaStoreSignature;
import com.bumptech.glide.signature.StringSignature;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.UUID;

public class RequestManager
implements LifecycleListener {
    private final Context context;
    private final Glide glide;
    private final Lifecycle lifecycle;
    private DefaultOptions options;
    private final OptionsApplier optionsApplier;
    private final RequestTracker requestTracker;
    private final RequestManagerTreeNode treeNode;

    public RequestManager(Context context, Lifecycle lifecycle, RequestManagerTreeNode requestManagerTreeNode) {
        this(context, lifecycle, requestManagerTreeNode, new RequestTracker(), new ConnectivityMonitorFactory());
    }

    /*
     * Enabled aggressive block sorting
     */
    RequestManager(Context context, Lifecycle lifecycle, RequestManagerTreeNode requestManagerTreeNode, RequestTracker requestTracker, ConnectivityMonitorFactory connectivityMonitorFactory) {
        this.context = context.getApplicationContext();
        this.lifecycle = lifecycle;
        this.treeNode = requestManagerTreeNode;
        this.requestTracker = requestTracker;
        this.glide = Glide.get(context);
        this.optionsApplier = new /* Unavailable Anonymous Inner Class!! */;
        context = connectivityMonitorFactory.build(context, (ConnectivityMonitor.ConnectivityListener)new /* Unavailable Anonymous Inner Class!! */);
        if (Util.isOnBackgroundThread()) {
            new Handler(Looper.getMainLooper()).post((Runnable)new 1(this, lifecycle));
        } else {
            lifecycle.addListener((LifecycleListener)this);
        }
        lifecycle.addListener((LifecycleListener)context);
    }

    static /* synthetic */ Class access$000(Object object) {
        return RequestManager.getSafeClass(object);
    }

    static /* synthetic */ Context access$100(RequestManager requestManager) {
        return requestManager.context;
    }

    static /* synthetic */ Glide access$200(RequestManager requestManager) {
        return requestManager.glide;
    }

    static /* synthetic */ RequestTracker access$300(RequestManager requestManager) {
        return requestManager.requestTracker;
    }

    static /* synthetic */ Lifecycle access$400(RequestManager requestManager) {
        return requestManager.lifecycle;
    }

    static /* synthetic */ OptionsApplier access$500(RequestManager requestManager) {
        return requestManager.optionsApplier;
    }

    static /* synthetic */ DefaultOptions access$800(RequestManager requestManager) {
        return requestManager.options;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> Class<T> getSafeClass(T object) {
        void var0_2;
        if (object == null) return var0_2;
        Class<?> clazz = object.getClass();
        return var0_2;
    }

    private <T> DrawableTypeRequest<T> loadGeneric(Class<T> clazz) {
        ModelLoader<Class<T>, InputStream> modelLoader = Glide.buildStreamModelLoader(clazz, this.context);
        ModelLoader<Class<T>, ParcelFileDescriptor> modelLoader2 = Glide.buildFileDescriptorModelLoader(clazz, this.context);
        if (clazz != null && modelLoader == null && modelLoader2 == null) {
            throw new IllegalArgumentException("Unknown type " + clazz + ". You must provide a Model of a type for" + " which there is a registered ModelLoader, if you are using a custom model, you must first call" + " Glide#register with a ModelLoaderFactory for your custom model class");
        }
        return (DrawableTypeRequest)this.optionsApplier.apply(new DrawableTypeRequest<Class<T>>(clazz, modelLoader, modelLoader2, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    public <T> DrawableTypeRequest<T> from(Class<T> clazz) {
        return this.loadGeneric(clazz);
    }

    public DrawableTypeRequest<byte[]> fromBytes() {
        return (DrawableTypeRequest)((DrawableRequestBuilder)((DrawableRequestBuilder)this.loadGeneric(byte[].class).signature((Key)new StringSignature(UUID.randomUUID().toString()))).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true);
    }

    public DrawableTypeRequest<File> fromFile() {
        return this.loadGeneric(File.class);
    }

    public DrawableTypeRequest<Uri> fromMediaStore() {
        ModelLoader<Class<Uri>, InputStream> modelLoader = Glide.buildStreamModelLoader(Uri.class, this.context);
        MediaStoreStreamLoader mediaStoreStreamLoader = new MediaStoreStreamLoader(this.context, modelLoader);
        modelLoader = Glide.buildFileDescriptorModelLoader(Uri.class, this.context);
        return (DrawableTypeRequest)this.optionsApplier.apply(new DrawableTypeRequest<Class<Uri>>((Class<Class<Uri>>)Uri.class, (ModelLoader<Class<Uri>, InputStream>)mediaStoreStreamLoader, (ModelLoader<Class<Uri>, ParcelFileDescriptor>)modelLoader, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    public DrawableTypeRequest<Integer> fromResource() {
        return (DrawableTypeRequest)this.loadGeneric(Integer.class).signature(ApplicationVersionSignature.obtain((Context)this.context));
    }

    public DrawableTypeRequest<String> fromString() {
        return this.loadGeneric(String.class);
    }

    public DrawableTypeRequest<Uri> fromUri() {
        return this.loadGeneric(Uri.class);
    }

    @Deprecated
    public DrawableTypeRequest<URL> fromUrl() {
        return this.loadGeneric(URL.class);
    }

    public boolean isPaused() {
        Util.assertMainThread();
        return this.requestTracker.isPaused();
    }

    public DrawableTypeRequest<Uri> load(Uri uri) {
        return (DrawableTypeRequest)this.fromUri().load((Object)uri);
    }

    public DrawableTypeRequest<File> load(File file) {
        return (DrawableTypeRequest)this.fromFile().load((Object)file);
    }

    public DrawableTypeRequest<Integer> load(Integer n2) {
        return (DrawableTypeRequest)this.fromResource().load((Object)n2);
    }

    public <T> DrawableTypeRequest<T> load(T t2) {
        return (DrawableTypeRequest)this.loadGeneric(RequestManager.getSafeClass(t2)).load((Object)t2);
    }

    public DrawableTypeRequest<String> load(String string2) {
        return (DrawableTypeRequest)this.fromString().load((Object)string2);
    }

    @Deprecated
    public DrawableTypeRequest<URL> load(URL uRL) {
        return (DrawableTypeRequest)this.fromUrl().load((Object)uRL);
    }

    public DrawableTypeRequest<byte[]> load(byte[] byArray) {
        return (DrawableTypeRequest)this.fromBytes().load((Object)byArray);
    }

    @Deprecated
    public DrawableTypeRequest<byte[]> load(byte[] byArray, String string2) {
        return (DrawableTypeRequest)this.load(byArray).signature((Key)new StringSignature(string2));
    }

    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri) {
        return (DrawableTypeRequest)this.fromMediaStore().load((Object)uri);
    }

    @Deprecated
    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri, String string2, long l2, int n2) {
        string2 = new MediaStoreSignature(string2, l2, n2);
        return (DrawableTypeRequest)this.loadFromMediaStore(uri).signature((Key)string2);
    }

    @Override
    public void onDestroy() {
        this.requestTracker.clearRequests();
    }

    public void onLowMemory() {
        this.glide.clearMemory();
    }

    @Override
    public void onStart() {
        this.resumeRequests();
    }

    @Override
    public void onStop() {
        this.pauseRequests();
    }

    public void onTrimMemory(int n2) {
        this.glide.trimMemory(n2);
    }

    public void pauseRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseRequests();
    }

    public void pauseRequestsRecursive() {
        Util.assertMainThread();
        this.pauseRequests();
        Iterator iterator = this.treeNode.getDescendants().iterator();
        while (iterator.hasNext()) {
            ((RequestManager)iterator.next()).pauseRequests();
        }
    }

    public void resumeRequests() {
        Util.assertMainThread();
        this.requestTracker.resumeRequests();
    }

    public void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        Iterator iterator = this.treeNode.getDescendants().iterator();
        while (iterator.hasNext()) {
            ((RequestManager)iterator.next()).resumeRequests();
        }
    }

    public void setDefaultOptions(DefaultOptions defaultOptions) {
        this.options = defaultOptions;
    }

    public <A, T> GenericModelRequest<A, T> using(ModelLoader<A, T> modelLoader, Class<T> clazz) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ImageModelRequest<byte[]> using(StreamByteArrayLoader streamByteArrayLoader) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public <T> ImageModelRequest<T> using(StreamModelLoader<T> streamModelLoader) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public <T> VideoModelRequest<T> using(FileDescriptorModelLoader<T> fileDescriptorModelLoader) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

