/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.bumptech.glide.BitmapTypeRequest;
import com.bumptech.glide.DownloadOptions;
import com.bumptech.glide.DrawableRequestBuilder;
import com.bumptech.glide.GenericRequestBuilder;
import com.bumptech.glide.GenericTranscodeRequest;
import com.bumptech.glide.GifTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.model.ImageVideoModelLoader;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.load.resource.gifbitmap.GifBitmapWrapper;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.RequestTracker;
import com.bumptech.glide.provider.FixedLoadProvider;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.target.Target;
import java.io.File;
import java.io.InputStream;

public class DrawableTypeRequest<ModelType>
extends DrawableRequestBuilder<ModelType>
implements DownloadOptions {
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final RequestManager.OptionsApplier optionsApplier;
    private final ModelLoader<ModelType, InputStream> streamModelLoader;

    DrawableTypeRequest(Class<ModelType> clazz, ModelLoader<ModelType, InputStream> modelLoader, ModelLoader<ModelType, ParcelFileDescriptor> modelLoader2, Context context, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle, RequestManager.OptionsApplier optionsApplier) {
        super(context, clazz, DrawableTypeRequest.buildProvider(glide, modelLoader, modelLoader2, GifBitmapWrapper.class, GlideDrawable.class, null), glide, requestTracker, lifecycle);
        this.streamModelLoader = modelLoader;
        this.fileDescriptorModelLoader = modelLoader2;
        this.optionsApplier = optionsApplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <A, Z, R> FixedLoadProvider<A, ImageVideoWrapper, Z, R> buildProvider(Glide fixedLoadProvider, ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2, Class<Z> clazz, Class<R> clazz2, ResourceTranscoder<Z, R> resourceTranscoder) {
        if (modelLoader == null && modelLoader2 == null) {
            return null;
        }
        ResourceTranscoder<Z, R> resourceTranscoder2 = resourceTranscoder;
        if (resourceTranscoder == null) {
            resourceTranscoder2 = fixedLoadProvider.buildTranscoder(clazz, clazz2);
        }
        fixedLoadProvider = fixedLoadProvider.buildDataProvider(ImageVideoWrapper.class, clazz);
        return new FixedLoadProvider((ModelLoader)new ImageVideoModelLoader(modelLoader, modelLoader2), resourceTranscoder2, fixedLoadProvider);
    }

    private GenericTranscodeRequest<ModelType, InputStream, File> getDownloadOnlyRequest() {
        return (GenericTranscodeRequest)this.optionsApplier.apply((GenericRequestBuilder)new GenericTranscodeRequest(File.class, (GenericRequestBuilder)this, this.streamModelLoader, InputStream.class, File.class, this.optionsApplier));
    }

    public BitmapTypeRequest<ModelType> asBitmap() {
        return (BitmapTypeRequest)this.optionsApplier.apply(new BitmapTypeRequest<ModelType>(this, this.streamModelLoader, this.fileDescriptorModelLoader, this.optionsApplier));
    }

    public GifTypeRequest<ModelType> asGif() {
        return (GifTypeRequest)this.optionsApplier.apply((GenericRequestBuilder)new GifTypeRequest((GenericRequestBuilder)this, this.streamModelLoader, this.optionsApplier));
    }

    @Override
    public FutureTarget<File> downloadOnly(int n2, int n3) {
        return this.getDownloadOnlyRequest().downloadOnly(n2, n3);
    }

    @Override
    public <Y extends Target<File>> Y downloadOnly(Y y2) {
        return (Y)this.getDownloadOnlyRequest().downloadOnly(y2);
    }
}

