/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import com.bumptech.glide.BitmapRequestBuilder;
import com.bumptech.glide.GenericRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.model.ImageVideoModelLoader;
import com.bumptech.glide.load.model.ImageVideoWrapper;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.resource.transcode.BitmapBytesTranscoder;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.provider.FixedLoadProvider;
import java.io.InputStream;

public class BitmapTypeRequest<ModelType>
extends BitmapRequestBuilder<ModelType, Bitmap> {
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final Glide glide;
    private final RequestManager.OptionsApplier optionsApplier;
    private final ModelLoader<ModelType, InputStream> streamModelLoader;

    BitmapTypeRequest(GenericRequestBuilder<ModelType, ?, ?, ?> genericRequestBuilder, ModelLoader<ModelType, InputStream> modelLoader, ModelLoader<ModelType, ParcelFileDescriptor> modelLoader2, RequestManager.OptionsApplier optionsApplier) {
        super(BitmapTypeRequest.buildProvider(genericRequestBuilder.glide, modelLoader, modelLoader2, Bitmap.class, null), Bitmap.class, genericRequestBuilder);
        this.streamModelLoader = modelLoader;
        this.fileDescriptorModelLoader = modelLoader2;
        this.glide = genericRequestBuilder.glide;
        this.optionsApplier = optionsApplier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <A, R> FixedLoadProvider<A, ImageVideoWrapper, Bitmap, R> buildProvider(Glide fixedLoadProvider, ModelLoader<A, InputStream> modelLoader, ModelLoader<A, ParcelFileDescriptor> modelLoader2, Class<R> clazz, ResourceTranscoder<Bitmap, R> resourceTranscoder) {
        if (modelLoader == null && modelLoader2 == null) {
            return null;
        }
        ResourceTranscoder<Bitmap, R> resourceTranscoder2 = resourceTranscoder;
        if (resourceTranscoder == null) {
            resourceTranscoder2 = fixedLoadProvider.buildTranscoder(Bitmap.class, clazz);
        }
        fixedLoadProvider = fixedLoadProvider.buildDataProvider(ImageVideoWrapper.class, Bitmap.class);
        return new FixedLoadProvider((ModelLoader)new ImageVideoModelLoader(modelLoader, modelLoader2), resourceTranscoder2, fixedLoadProvider);
    }

    public BitmapRequestBuilder<ModelType, byte[]> toBytes() {
        return this.transcode((ResourceTranscoder)new BitmapBytesTranscoder(), (Class)byte[].class);
    }

    public BitmapRequestBuilder<ModelType, byte[]> toBytes(Bitmap.CompressFormat compressFormat, int n2) {
        return this.transcode((ResourceTranscoder)new BitmapBytesTranscoder(compressFormat, n2), (Class)byte[].class);
    }

    public <R> BitmapRequestBuilder<ModelType, R> transcode(ResourceTranscoder<Bitmap, R> resourceTranscoder, Class<R> clazz) {
        return (BitmapRequestBuilder)this.optionsApplier.apply(new BitmapRequestBuilder<ModelType, R>(BitmapTypeRequest.buildProvider(this.glide, this.streamModelLoader, this.fileDescriptorModelLoader, clazz, resourceTranscoder), clazz, this));
    }
}

