/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.Jni;
import com.baidu.location.LocationClientOption;
import com.baidu.location.a.b;
import com.baidu.location.a.h;
import com.baidu.location.c;
import com.baidu.location.f;
import java.util.ArrayList;
import java.util.Iterator;

public final class LocationClient
implements b.b {
    private static final int MIN_REQUEST_SPAN = 1000;
    private static final int MSG_REG_LISTENER = 5;
    private static final int MSG_REG_NOTIFY_LISTENER = 8;
    private static final int MSG_REMOVE_NOTIFY = 10;
    private static final int MSG_REQ_LOC = 4;
    private static final int MSG_REQ_NOTIFY_LOC = 11;
    private static final int MSG_REQ_OFFLINE_LOC = 12;
    private static final int MSG_REQ_POI = 7;
    private static final int MSG_RIGSTER_NOTIFY = 9;
    private static final int MSG_SET_OPT = 3;
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final int MSG_UNREG_LISTENER = 6;
    private static final String TAG = "baidu_location_Client";
    private boolean clientFirst = false;
    private Boolean firstConnected = true;
    private boolean inDoorState = false;
    private boolean isScheduled = false;
    private boolean isStop = true;
    private boolean isWaitingForLocation = false;
    private boolean isWaitingLocTag = false;
    private long lastReceiveGpsTime = 0L;
    private long lastReceiveLocationTime = 0L;
    private ServiceConnection mConnection;
    private Context mContext = null;
    private boolean mDebugByDev;
    private boolean mGpsStatus = false;
    private a mHandler;
    private boolean mIsStarted = false;
    private String mKey;
    private BDLocation mLastLocation = null;
    private long mLastRequestTime = 0L;
    private ArrayList<BDLocationListener> mLocationListeners = null;
    private final Object mLock;
    private final Messenger mMessenger;
    private LocationClientOption mOption = new LocationClientOption();
    private String mPackName = null;
    private b mScheduledRequest = null;
    private Messenger mServer = null;
    private com.baidu.location.a.b mloc = null;
    private boolean serverFirst = false;
    private String serviceName = null;

    public LocationClient(Context context) {
        this.mHandler = new a(null);
        this.mMessenger = new Messenger((Handler)this.mHandler);
        this.mLock = new Object();
        this.mConnection = new com.baidu.location.b(this);
        this.mContext = context;
        this.mOption = new LocationClientOption();
    }

    public LocationClient(Context context, LocationClientOption locationClientOption) {
        this.mHandler = new a(null);
        this.mMessenger = new Messenger((Handler)this.mHandler);
        this.mLock = new Object();
        this.mConnection = new com.baidu.location.b(this);
        this.mContext = context;
        this.mOption = locationClientOption;
    }

    static /* synthetic */ Context access$1000(LocationClient locationClient) {
        return locationClient.mContext;
    }

    static /* synthetic */ Messenger access$102(LocationClient locationClient, Messenger messenger) {
        locationClient.mServer = messenger;
        return messenger;
    }

    static /* synthetic */ boolean access$1302(LocationClient locationClient, boolean bl2) {
        locationClient.isScheduled = bl2;
        return bl2;
    }

    static /* synthetic */ b access$1602(LocationClient locationClient, b b2) {
        locationClient.mScheduledRequest = b2;
        return b2;
    }

    static /* synthetic */ boolean access$202(LocationClient locationClient, boolean bl2) {
        locationClient.mIsStarted = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$2602(LocationClient locationClient, boolean bl2) {
        locationClient.mGpsStatus = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$2702(LocationClient locationClient, boolean bl2) {
        locationClient.serverFirst = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$300(LocationClient locationClient) {
        return locationClient.isStop;
    }

    static /* synthetic */ Bundle access$600(LocationClient locationClient) {
        return locationClient.getOptionBundle();
    }

    static /* synthetic */ Boolean access$800(LocationClient locationClient) {
        return locationClient.firstConnected;
    }

    static /* synthetic */ Boolean access$802(LocationClient locationClient, Boolean bl2) {
        locationClient.firstConnected = bl2;
        return bl2;
    }

    static /* synthetic */ com.baidu.location.a.b access$900(LocationClient locationClient) {
        return locationClient.mloc;
    }

    static /* synthetic */ com.baidu.location.a.b access$902(LocationClient locationClient, com.baidu.location.a.b b2) {
        locationClient.mloc = b2;
        return b2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void callListeners(int n2) {
        block8: {
            block7: {
                if (this.mLastLocation.getCoorType() == null) {
                    this.mLastLocation.setCoorType(this.mOption.coorType);
                }
                if (!this.isWaitingForLocation && (!this.mOption.location_change_notify || this.mLastLocation.getLocType() != 61) && this.mLastLocation.getLocType() != 66 && this.mLastLocation.getLocType() != 67 && !this.inDoorState && this.mLastLocation.getLocType() != 161) break block7;
                if (this.mLocationListeners != null) {
                    Iterator<BDLocationListener> iterator = this.mLocationListeners.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().onReceiveLocation(this.mLastLocation);
                    }
                }
                if (this.mLastLocation.getLocType() != 66 && this.mLastLocation.getLocType() != 67) break block8;
            }
            return;
        }
        this.isWaitingForLocation = false;
        this.lastReceiveLocationTime = System.currentTimeMillis();
    }

    public static BDLocation getBDLocationInCoorType(BDLocation object, String string2) {
        BDLocation bDLocation = new BDLocation((BDLocation)object);
        object = Jni.coorEncrypt(((BDLocation)object).getLongitude(), ((BDLocation)object).getLatitude(), string2);
        bDLocation.setLatitude((double)object[1]);
        bDLocation.setLongitude((double)object[0]);
        return bDLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bundle getOptionBundle() {
        if (this.mOption == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("packName", this.mPackName);
        bundle.putString("prodName", this.mOption.prodName);
        bundle.putString("coorType", this.mOption.coorType);
        bundle.putString("addrType", this.mOption.addrType);
        bundle.putBoolean("openGPS", this.mOption.openGps);
        bundle.putBoolean("location_change_notify", this.mOption.location_change_notify);
        bundle.putBoolean("enableSimulateGps", this.mOption.enableSimulateGps);
        bundle.putInt("scanSpan", this.mOption.scanSpan);
        bundle.putInt("timeOut", this.mOption.timeOut);
        bundle.putInt("priority", this.mOption.priority);
        bundle.putBoolean("map", false);
        bundle.putBoolean("import", false);
        bundle.putBoolean("needDirect", this.mOption.mIsNeedDeviceDirect);
        bundle.putBoolean("isneedaptag", this.mOption.isNeedAptag);
        bundle.putBoolean("isneedpoiregion", this.mOption.isNeedPoiRegion);
        bundle.putBoolean("isneedregular", this.mOption.isNeedRegular);
        bundle.putBoolean("isneedaptagd", this.mOption.isNeedAptagd);
        bundle.putBoolean("isneedaltitude", this.mOption.isNeedAltitude);
        return bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onNewLocation(Message message, int n2) {
        if (!this.mIsStarted) {
            return;
        }
        try {
            message = message.getData();
            message.setClassLoader(BDLocation.class.getClassLoader());
            this.mLastLocation = (BDLocation)message.getParcelable("locStr");
            if (this.mLastLocation.getLocType() == 61) {
                this.lastReceiveGpsTime = System.currentTimeMillis();
            }
            this.callListeners(n2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void onNewNotifyLocation(Message message) {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRegisterListener(Message object) {
        if (object == null) return;
        if (object.obj == null) {
            return;
        }
        BDLocationListener bDLocationListener = (BDLocationListener)object.obj;
        if (this.mLocationListeners == null) {
            this.mLocationListeners = new ArrayList();
        }
        if (this.mLocationListeners.contains(bDLocationListener)) return;
        this.mLocationListeners.add(bDLocationListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onRegisterNotifyLocationListener(Message object) {
        if (object == null || object.obj == null) {
            return;
        }
        BDLocationListener bDLocationListener = (BDLocationListener)object.obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRequestLocation() {
        Object object;
        Object object2;
        if (this.mServer == null) {
            return;
        }
        if (!(System.currentTimeMillis() - this.lastReceiveGpsTime <= 3000L && this.mOption.location_change_notify && !this.isWaitingLocTag || this.inDoorState && System.currentTimeMillis() - this.lastReceiveLocationTime <= 20000L && !this.isWaitingLocTag)) {
            object2 = Message.obtain(null, (int)22);
            if (this.isWaitingLocTag) {
                object = new Bundle();
                this.isWaitingLocTag = false;
                object.putBoolean("isWaitingLocTag", this.isWaitingLocTag);
                object2.setData(object);
            }
            try {
                object2.replyTo = this.mMessenger;
                this.mServer.send(object2);
                this.mLastRequestTime = System.currentTimeMillis();
                this.isWaitingForLocation = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object2 = this.mLock;
        synchronized (object2) {
            if (this.mOption == null) return;
            if (this.mOption.scanSpan < 1000) return;
            if (this.isScheduled) return;
            if (this.mScheduledRequest == null) {
                object = new b(null);
                this.mScheduledRequest = object;
            }
            this.mHandler.postDelayed(this.mScheduledRequest, this.mOption.scanSpan);
            this.isScheduled = true;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onRequestNotifyLocation() {
        if (this.mServer == null) {
            return;
        }
        Message message = Message.obtain(null, (int)22);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onRequestOffLineLocation() {
        Message message = Message.obtain(null, (int)28);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSetOption(Message object) {
        this.isWaitingLocTag = false;
        if (object == null) return;
        if (object.obj == null) {
            return;
        }
        object = (LocationClientOption)object.obj;
        if (this.mOption.optionEquals((LocationClientOption)object)) return;
        if (this.mOption.scanSpan != object.scanSpan) {
            try {
                Object object2 = this.mLock;
                synchronized (object2) {
                    if (!this.isScheduled) break block12;
                }
            }
            catch (Exception exception) {}
            {
                block12: {
                    this.mHandler.removeCallbacks(this.mScheduledRequest);
                    this.isScheduled = false;
                }
                if (object.scanSpan >= 1000 && !this.isScheduled) {
                    if (this.mScheduledRequest == null) {
                        b b2;
                        this.mScheduledRequest = b2 = new b(null);
                    }
                    this.mHandler.postDelayed(this.mScheduledRequest, object.scanSpan);
                    this.isScheduled = true;
                }
            }
        }
        this.mOption = new LocationClientOption((LocationClientOption)object);
        if (this.mServer == null) return;
        try {
            object = Message.obtain(null, (int)15);
            object.replyTo = this.mMessenger;
            object.setData(this.getOptionBundle());
            this.mServer.send(object);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onStart() {
        if (this.mIsStarted) {
            return;
        }
        if (this.firstConnected.booleanValue()) {
            new c(this).start();
            this.firstConnected = false;
        }
        this.mPackName = this.mContext.getPackageName();
        this.serviceName = this.mPackName + "_bdls_v2.9";
        Intent intent = new Intent(this.mContext, f.class);
        try {
            intent.putExtra("debug_dev", this.mDebugByDev);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mOption == null) {
            this.mOption = new LocationClientOption();
        }
        intent.putExtra("cache_exception", this.mOption.isIgnoreCacheException);
        intent.putExtra("kill_process", this.mOption.isIgnoreKillProcess);
        try {
            this.mContext.bindService(intent, this.mConnection, 1);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mIsStarted = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onStop() {
        if (!this.mIsStarted) return;
        if (this.mServer == null) {
            return;
        }
        Object object = Message.obtain(null, (int)12);
        object.replyTo = this.mMessenger;
        try {
            this.mServer.send(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.mContext.unbindService(this.mConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = this.mLock;
        synchronized (object) {
            try {
                if (this.isScheduled) {
                    this.mHandler.removeCallbacks(this.mScheduledRequest);
                    this.isScheduled = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mServer = null;
        this.isWaitingLocTag = false;
        this.inDoorState = false;
        this.mIsStarted = false;
        this.clientFirst = false;
        this.serverFirst = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onUnRegisterListener(Message object) {
        if (object == null) return;
        if (object.obj == null) {
            return;
        }
        BDLocationListener bDLocationListener = (BDLocationListener)object.obj;
        if (this.mLocationListeners == null) return;
        if (!this.mLocationListeners.contains(bDLocationListener)) return;
        this.mLocationListeners.remove(bDLocationListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendFirstLoc(BDLocation bDLocation) {
        if (!this.isStop) {
            this.mLastLocation = bDLocation;
            if (!this.serverFirst && bDLocation.getLocType() == 161) {
                this.clientFirst = true;
            }
            if (this.mLocationListeners != null) {
                Iterator<BDLocationListener> iterator = this.mLocationListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onReceiveLocation(bDLocation);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAccessKey() {
        try {
            this.mKey = h.b(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)this.mKey)) return String.format("KEY=%s", this.mKey);
            IllegalStateException illegalStateException = new IllegalStateException("please setting key from Manifest.xml");
            throw illegalStateException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BDLocation getLastKnownLocation() {
        return this.mLastLocation;
    }

    public LocationClientOption getLocOption() {
        return this.mOption;
    }

    public String getVersion() {
        return "7.0.2";
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onReceiveLocation(BDLocation bDLocation) {
        if (this.serverFirst && !this.clientFirst) {
            return;
        }
        if (bDLocation == null) return;
        Message message = this.mHandler.obtainMessage(701);
        message.obj = bDLocation;
        message.sendToTarget();
    }

    public void registerLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    public void registerNotifyLocationListener(BDLocationListener bDLocationListener) {
        Message message = this.mHandler.obtainMessage(8);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int requestLocation() {
        int n2 = 0;
        if (this.mServer == null) return 1;
        if (this.mMessenger == null) {
            return 1;
        }
        if (this.mLocationListeners == null) return 2;
        if (this.mLocationListeners.size() < 1) {
            return 2;
        }
        if (System.currentTimeMillis() - this.mLastRequestTime < 1000L) {
            return 6;
        }
        this.isWaitingLocTag = true;
        Message message = this.mHandler.obtainMessage(4);
        message.arg1 = 0;
        message.sendToTarget();
        return n2;
    }

    public void requestNotifyLocation() {
        this.mHandler.obtainMessage(11).sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int requestOfflineLocation() {
        int n2;
        int n3 = n2 = 1;
        if (this.mServer == null) return n3;
        if (this.mMessenger == null) {
            return n2;
        }
        if (this.mLocationListeners == null) return 2;
        if (this.mLocationListeners.size() < 1) {
            return 2;
        }
        this.mHandler.obtainMessage(12).sendToTarget();
        return 0;
    }

    public void setLocOption(LocationClientOption locationClientOption) {
        LocationClientOption locationClientOption2 = locationClientOption;
        if (locationClientOption == null) {
            locationClientOption2 = new LocationClientOption();
        }
        locationClientOption = this.mHandler.obtainMessage(3);
        ((Message)locationClientOption).obj = locationClientOption2;
        locationClientOption.sendToTarget();
    }

    public void start() {
        this.isStop = false;
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    public void stop() {
        this.isStop = true;
        this.mHandler.obtainMessage(2).sendToTarget();
        this.mloc = null;
    }

    public void unRegisterLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(6);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateLocation(Location location) {
        if (this.mServer == null) return false;
        if (this.mMessenger == null) return false;
        if (location == null) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)57);
            message.obj = location;
            this.mServer.send(message);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    private class a
    extends Handler {
        private a() {
        }

        /* synthetic */ a(com.baidu.location.b b2) {
            this();
        }

        /*
         * Handled duff style switch with additional control
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message message) {
            int n2 = 0;
            block18: do {
                switch (n2 == 0 ? message.what : n2) {
                    default: {
                        super.handleMessage(message);
                        n2 = 7;
                        continue block18;
                    }
                    case 3: {
                        LocationClient.this.onSetOption(message);
                        n2 = 7;
                        continue block18;
                    }
                    case 8: {
                        LocationClient.this.onRegisterNotifyLocationListener(message);
                        n2 = 7;
                        continue block18;
                    }
                    case 5: {
                        LocationClient.this.onRegisterListener(message);
                        n2 = 7;
                        continue block18;
                    }
                    case 6: {
                        LocationClient.this.onUnRegisterListener(message);
                        n2 = 7;
                        continue block18;
                    }
                    case 1: {
                        LocationClient.this.onStart();
                        n2 = 7;
                        continue block18;
                    }
                    case 2: {
                        LocationClient.this.onStop();
                        n2 = 7;
                        continue block18;
                    }
                    case 11: {
                        LocationClient.this.onRequestNotifyLocation();
                        n2 = 7;
                        continue block18;
                    }
                    case 4: {
                        LocationClient.this.onRequestLocation();
                        n2 = 7;
                        continue block18;
                    }
                    case 12: {
                        LocationClient.this.onRequestOffLineLocation();
                        n2 = 7;
                        continue block18;
                    }
                    case 54: {
                        if (!((LocationClient)LocationClient.this).mOption.location_change_notify) return;
                        LocationClient.access$2602(LocationClient.this, true);
                        n2 = 7;
                        continue block18;
                    }
                    case 55: {
                        if (!((LocationClient)LocationClient.this).mOption.location_change_notify) return;
                        LocationClient.access$2602(LocationClient.this, false);
                        n2 = 7;
                        continue block18;
                    }
                    case 21: {
                        Object object = message.getData();
                        object.setClassLoader(BDLocation.class.getClassLoader());
                        object = (BDLocation)object.getParcelable("locStr");
                        if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst) {
                            if (((BDLocation)object).getLocType() == 66) return;
                        }
                        if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst) {
                            LocationClient.access$2702(LocationClient.this, true);
                            n2 = 7;
                            continue block18;
                        }
                        if (!LocationClient.this.serverFirst) {
                            LocationClient.access$2702(LocationClient.this, true);
                        }
                        LocationClient.this.onNewLocation(message, 21);
                        n2 = 7;
                        continue block18;
                    }
                    case 26: {
                        LocationClient.this.onNewLocation(message, 26);
                        n2 = 7;
                        continue block18;
                    }
                    case 27: {
                        LocationClient.this.onNewNotifyLocation(message);
                    }
                    case 7: {
                        return;
                    }
                    case 701: 
                }
                break;
            } while (true);
            LocationClient.this.sendFirstLoc((BDLocation)message.obj);
        }
    }

    private class b
    implements Runnable {
        private b() {
        }

        /* synthetic */ b(com.baidu.location.b b2) {
            this();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = LocationClient.this.mLock;
            synchronized (object) {
                LocationClient.access$1302(LocationClient.this, false);
                if (LocationClient.this.mServer == null) return;
                if (LocationClient.this.mMessenger == null) {
                    return;
                }
                if (LocationClient.this.mLocationListeners == null) return;
                if (LocationClient.this.mLocationListeners.size() < 1) {
                    return;
                }
                if (!LocationClient.this.isWaitingLocTag) {
                    LocationClient.this.mHandler.obtainMessage(4).sendToTarget();
                    return;
                }
                if (LocationClient.this.mScheduledRequest == null) {
                    LocationClient locationClient = LocationClient.this;
                    b b2 = new b();
                    LocationClient.access$1602(locationClient, b2);
                }
                LocationClient.this.mHandler.postDelayed(LocationClient.this.mScheduledRequest, ((LocationClient)LocationClient.this).mOption.scanSpan);
                return;
            }
        }
    }
}

