/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view.listview;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.android.gmacs.R;
import com.android.gmacs.view.listview.XXListViewHeader;

public class XXListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final int SCROLL_DURATION = 300;
    private int finalHeight = this.getResources().getDimensionPixelOffset(R.dimen.max_loading_progress_bar_height);
    private Scroller mHeaderScroller;
    public XXListViewHeader mHeaderView;
    private RelativeLayout mHeaderViewContent;
    private XXListViewListener mListViewListener;
    private AbsListView.OnScrollListener mScrollListener;

    public XXListView(Context context) {
        super(context);
        this.initWithContext(context);
    }

    public XXListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initWithContext(context);
    }

    public XXListView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        this.mHeaderScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mHeaderView = new XXListViewHeader(context);
        this.mHeaderViewContent = (RelativeLayout)this.mHeaderView.findViewById(R.id.xxlistview_header_content);
        this.addHeaderView((View)this.mHeaderView);
    }

    @TargetApi(value=11)
    public void computeScroll() {
        if (this.mHeaderScroller.computeScrollOffset()) {
            this.mHeaderView.setVisibleHeight(this.mHeaderScroller.getCurrY());
            if (this.mHeaderScroller.getCurrY() == this.finalHeight) {
                this.mListViewListener.onLoadMore();
            }
            this.postInvalidate();
        }
        super.computeScroll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                return super.onInterceptTouchEvent(motionEvent);
            }
            case 0: 
        }
        this.setTranscriptMode(0);
        return super.onInterceptTouchEvent(motionEvent);
    }

    public void onScroll(AbsListView absListView, int n2, int n3, int n4) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(absListView, n2, n3, n4);
        }
    }

    public void onScrollStateChanged(AbsListView absListView, int n2) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(absListView, n2);
        }
    }

    public void setAdapter(ListAdapter listAdapter) {
        super.setAdapter(listAdapter);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
        this.mScrollListener = onScrollListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPullRefreshEnable(boolean bl2) {
        if (!bl2) {
            this.mHeaderViewContent.setVisibility(4);
            return;
        }
        this.mHeaderViewContent.setVisibility(0);
    }

    public void setXXListViewListener(XXListViewListener xXListViewListener) {
        this.mListViewListener = xXListViewListener;
    }

    public void startLoadMore() {
        this.mHeaderViewContent.setVisibility(0);
        int n2 = this.mHeaderView.getVisibleHeight();
        this.mHeaderScroller.startScroll(0, n2, 0, this.finalHeight - n2, 300);
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopLoadMore() {
        int n2 = this.mHeaderView.getVisibleHeight();
        if (n2 == 0) {
            this.mHeaderViewContent.setVisibility(8);
            return;
        }
        this.mHeaderScroller.startScroll(0, n2, 0, -n2, 300);
        this.invalidate();
    }

    public static interface XXListViewListener {
        public void onLoadMore();
    }
}

