/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.view;

import android.content.Context;
import android.content.res.Resources;
import android.text.Editable;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsChatActivity;
import com.android.gmacs.logic.CommandLogic;
import com.android.gmacs.observer.OnInputSoftListener;
import com.android.gmacs.sound.SoundPlayer;
import com.android.gmacs.sound.SoundRecord;
import com.android.gmacs.view.SendMoreLayout;
import com.android.gmacs.view.SendMsgLayout;
import com.android.gmacs.view.emoji.FaceConversionUtil;
import com.android.gmacs.view.emoji.FaceLinearLayout;
import com.common.gmacs.utils.GLog;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.PermissionUtil;
import com.common.gmacs.utils.ToastUtil;

public class SendMsgLayout
extends LinearLayout
implements TextWatcher,
View.OnClickListener,
View.OnTouchListener,
OnInputSoftListener {
    private GmacsChatActivity gmacsChatActivity;
    public boolean inputSoftIsShow = false;
    private FaceLinearLayout mEmojiLayout;
    public ImageView mPublicAccountMenuBtn;
    private ImageView mQuickButton;
    protected QuickMsgAdapter mQuickMsgAdapter;
    private View mQuickMsgLayout;
    private ListView mQuickMsgListView;
    private SoundRecord mRecord;
    private Button mRecordVoice;
    private ImageView mSendEmojiButton;
    private ImageView mSendMoreButton;
    public SendMoreLayout mSendMoreLayout;
    private ImageView mSendVoice;
    private boolean needShowEmojiLayoutInOnHide;
    private boolean needShowSendMoreLayoutInOnHide;
    private EditText sendMessageEditText;
    private Button sendTextButton;

    public SendMsgLayout(Context context) {
        super(context);
    }

    public SendMsgLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public SendMsgLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    static /* synthetic */ Button access$000(SendMsgLayout sendMsgLayout) {
        return sendMsgLayout.mRecordVoice;
    }

    static /* synthetic */ GmacsChatActivity access$100(SendMsgLayout sendMsgLayout) {
        return sendMsgLayout.gmacsChatActivity;
    }

    static /* synthetic */ SoundRecord access$200(SendMsgLayout sendMsgLayout) {
        return sendMsgLayout.mRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendTextMsg() {
        String string2 = this.sendMessageEditText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            ToastUtil.showToast(this.getResources().getText(R.string.message_cannot_be_empty));
            return;
        }
        if (this.isBlankOrCRLF(string2)) {
            ToastUtil.showToast(this.getResources().getText(R.string.message_cannot_be_space_or_enter));
            return;
        }
        this.gmacsChatActivity.sendTextMsg(string2, null);
        this.sendMessageEditText.setText((CharSequence)"");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterTextChanged(Editable editable) {
        if (!TextUtils.isEmpty((CharSequence)editable) && this.sendTextButton.getVisibility() == 8) {
            this.sendTextButton.setVisibility(0);
            this.mSendMoreButton.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)editable)) return;
        if (this.sendTextButton.getVisibility() != 0) return;
        this.sendTextButton.setVisibility(8);
        this.mSendMoreButton.setVisibility(0);
    }

    public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
    }

    public void collapseMoreAndInputMethod() {
        if (this.mSendMoreLayout.isShown()) {
            this.mSendMoreLayout.setVisibility(8);
        }
        if (this.mEmojiLayout.faceViewShown()) {
            this.mEmojiLayout.hidden();
        }
        this.mQuickMsgLayout.setVisibility(8);
        this.hiddenInputSoft();
    }

    public String getMsgEditText() {
        return this.sendMessageEditText.getText().toString();
    }

    public View getRecordVoice() {
        return this.mRecordVoice;
    }

    public void hiddenInputSoft() {
        ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.sendMessageEditText.getApplicationWindowToken(), 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initQuickMsgView(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray.length > 3) {
                ViewGroup.LayoutParams layoutParams = this.mQuickMsgLayout.getLayoutParams();
                if (layoutParams == null) {
                    layoutParams = new LinearLayout.LayoutParams(-1, this.getResources().getDimensionPixelSize(R.dimen.msg_quick_view_max_height));
                } else {
                    layoutParams.height = this.getResources().getDimensionPixelSize(R.dimen.msg_quick_view_max_height);
                }
                this.mQuickMsgLayout.setLayoutParams(layoutParams);
            }
            this.mQuickButton.setOnClickListener((View.OnClickListener)this);
            this.mQuickButton.setVisibility(0);
            this.mQuickMsgAdapter = new /* Unavailable Anonymous Inner Class!! */;
            this.mQuickMsgListView.setAdapter((ListAdapter)this.mQuickMsgAdapter);
            this.mQuickMsgAdapter.quickMsgContents = stringArray;
        } else {
            this.mQuickButton.setVisibility(8);
        }
        this.mQuickMsgLayout.setVisibility(8);
    }

    public boolean isBlankOrCRLF(String string2) {
        return TextUtils.isEmpty((CharSequence)string2.trim());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onBackPress() {
        if (this.mSendMoreLayout != null && this.mSendMoreLayout.isShown()) {
            this.mSendMoreLayout.setVisibility(8);
            return true;
        }
        if (this.mQuickMsgLayout != null && this.mQuickMsgLayout.isShown()) {
            this.mQuickMsgLayout.setVisibility(8);
            return true;
        }
        if (this.mEmojiLayout == null) return false;
        if (!this.mEmojiLayout.faceViewShown()) return false;
        this.mEmojiLayout.hidden();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onClick(View view) {
        if (view == this.sendMessageEditText) {
            this.mSendMoreLayout.setVisibility(8);
            this.mEmojiLayout.hidden();
            return;
        }
        if (view == this.mSendEmojiButton) {
            this.switchSendEmoji();
            return;
        }
        if (view == this.mSendMoreButton) {
            this.switchSendMore();
            return;
        }
        if (view == this.mSendVoice) {
            this.switchSendVoice();
            return;
        }
        if (view == this.mQuickButton) {
            this.switchSendQuickMsg();
            return;
        }
        if (view == this.sendTextButton) {
            this.sendTextMsg();
            return;
        }
        if (view != this.mPublicAccountMenuBtn) return;
        if (this.gmacsChatActivity.publicAccountMenu.isShown()) {
            this.gmacsChatActivity.publicAccountMenu.setVisibility(8);
            this.setVisibility(0);
            return;
        }
        if (this.inputSoftIsShow) {
            this.hiddenInputSoft();
        }
        this.gmacsChatActivity.publicAccountMenu.setVisibility(0);
        this.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.gmacsChatActivity = (GmacsChatActivity)this.getContext();
        this.sendMessageEditText = (EditText)this.findViewById(R.id.send_msg_edittext);
        this.sendMessageEditText.clearFocus();
        this.sendTextButton = (Button)this.findViewById(R.id.send_text);
        this.mSendVoice = (ImageView)this.findViewById(R.id.send_voice_button);
        this.mSendMoreButton = (ImageView)this.findViewById(R.id.send_more_button);
        this.mSendEmojiButton = (ImageView)this.findViewById(R.id.send_emoji_button);
        this.mRecordVoice = (Button)this.findViewById(R.id.record_voice);
        this.mSendMoreLayout = (SendMoreLayout)this.findViewById(R.id.send_more_layout);
        this.mEmojiLayout = (FaceLinearLayout)this.findViewById(R.id.face_container);
        this.mQuickButton = (ImageView)this.findViewById(R.id.send_quick_button);
        this.mQuickMsgListView = (ListView)this.findViewById(R.id.quick_msg);
        this.mQuickMsgLayout = this.findViewById(R.id.send_quick_msg_layout);
        this.mPublicAccountMenuBtn = (ImageView)this.findViewById(R.id.iv_public_account_keyboard_down);
        this.mEmojiLayout.setMessageEditView(this.sendMessageEditText);
        this.mEmojiLayout.setGmacsChatActivity(this.gmacsChatActivity);
        this.sendMessageEditText.addTextChangedListener((TextWatcher)this);
        this.sendMessageEditText.setOnClickListener((View.OnClickListener)this);
        this.mSendEmojiButton.setOnClickListener((View.OnClickListener)this);
        this.mSendMoreButton.setOnClickListener((View.OnClickListener)this);
        this.mSendVoice.setOnClickListener((View.OnClickListener)this);
        this.sendTextButton.setOnClickListener((View.OnClickListener)this);
        this.mRecordVoice.setOnTouchListener((View.OnTouchListener)this);
        this.mPublicAccountMenuBtn.setOnClickListener((View.OnClickListener)this);
        this.switchSendText(false);
        if (this.gmacsChatActivity.sendAudioEnable()) {
            this.mSendVoice.setVisibility(0);
        } else {
            this.mSendVoice.setVisibility(8);
        }
        if (this.gmacsChatActivity.sendEmojiEnable()) {
            this.mSendEmojiButton.setVisibility(0);
        } else {
            this.mSendEmojiButton.setVisibility(8);
        }
        if (this.gmacsChatActivity.sendMoreEnable()) {
            this.mSendMoreButton.setVisibility(0);
            return;
        }
        this.mSendMoreButton.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onHide() {
        this.inputSoftIsShow = false;
        this.gmacsChatActivity.popMsgUpOfSendMsgLayout();
        if (this.needShowSendMoreLayoutInOnHide) {
            this.mSendMoreLayout.setVisibility(0);
            this.needShowSendMoreLayoutInOnHide = false;
            return;
        }
        if (this.needShowEmojiLayoutInOnHide) {
            this.mEmojiLayout.show();
            this.needShowEmojiLayoutInOnHide = false;
            return;
        }
        this.gmacsChatActivity.hideSendMsgLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.gmacsChatActivity.stopScroll();
                this.gmacsChatActivity.popMsgUpOfSendMsgLayout();
            }
        }
        if (this.gmacsChatActivity.sendMsgLayoutTouchable) return false;
        return true;
    }

    @Override
    public void onShow() {
        this.inputSoftIsShow = true;
        this.switchSendText(false);
        this.gmacsChatActivity.popMsgUpOfSendMsgLayout();
    }

    public void onTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
        FaceConversionUtil.getInstace().replaceAllEmojis((Context)GmacsEnvi.appContext, (Spannable)this.sendMessageEditText.getText());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean onTouch(View object, MotionEvent motionEvent) {
        Resources resources;
        switch (resources.getAction()) {
            case 0: {
                void var1_3;
                GLog.d("audio_msg", "down");
                this.mRecordVoice.setText((CharSequence)this.getContext().getString(R.string.record_stop));
                this.mRecordVoice.setSelected(true);
                if (SoundPlayer.getInstance().isSoundPlaying()) {
                    SoundPlayer.getInstance().stopPlayAndAnimation();
                }
                if (!CommandLogic.getInstance().isChatting()) {
                    GmacsChatActivity gmacsChatActivity = this.gmacsChatActivity;
                    resources = new 1(this);
                    PermissionUtil.requestPermissions(gmacsChatActivity, new String[]{"android.permission.RECORD_AUDIO"}, 4, (PermissionUtil.PermissionCallBack)resources);
                    return true;
                }
                resources = this.getResources();
                int n2 = R.string.calling;
                if (CommandLogic.getInstance().getChattingType() == 1) {
                    String string2 = "\u89c6\u9891";
                } else {
                    String string3 = "\u97f3\u9891";
                }
                ToastUtil.showToast(resources.getString(n2, new Object[]{var1_3}));
                return true;
            }
            case 2: {
                GLog.d("audio_msg", "move");
                return true;
            }
            case 1: 
            case 3: {
                GLog.d("audio_msg", "up");
                this.mRecordVoice.setText((CharSequence)this.getContext().getString(R.string.record_start));
                this.mRecordVoice.setSelected(false);
                if (this.mRecord.isUserCancelRecord()) return true;
                this.mRecord.stopRecord();
                return true;
            }
        }
        return true;
    }

    public void registerOnMoreItemClick(SendMoreLayout.OnMoreItemClickListener onMoreItemClickListener) {
        this.mSendMoreLayout.registerOnMoreItemClick(onMoreItemClickListener);
    }

    public void setGmacsChatActivity(GmacsChatActivity gmacsChatActivity) {
        this.gmacsChatActivity = gmacsChatActivity;
    }

    public void setMsgEditText(String string2) {
        this.sendMessageEditText.setText((CharSequence)string2);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.sendMessageEditText.setSelection(string2.length());
        }
    }

    public void setRecord(SoundRecord soundRecord) {
        this.mRecord = soundRecord;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSendAudioEnable(boolean bl2) {
        if (bl2) {
            this.mSendVoice.setVisibility(0);
            return;
        }
        this.mSendVoice.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSendEmojiEnable(boolean bl2) {
        if (bl2) {
            this.mSendEmojiButton.setVisibility(0);
            return;
        }
        this.mSendEmojiButton.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSendMoreEnable(boolean bl2) {
        if (bl2) {
            this.mSendMoreButton.setVisibility(0);
            return;
        }
        this.mSendMoreButton.setVisibility(8);
    }

    public void setSendMoreItemResources(int[] nArray, String[] stringArray, boolean bl2) {
        this.mSendMoreLayout.setBtnImgResIds(nArray);
        this.mSendMoreLayout.setBtnTexts(stringArray);
        this.mSendMoreLayout.showItemsSingleLinePreferred(bl2);
        this.mSendMoreLayout.notifyData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setVisibility(int n2) {
        super.setVisibility(n2);
        if (n2 == 0) {
            this.gmacsChatActivity.setShouldShowInputSoftAuto(this.gmacsChatActivity.getShouldShowInputSoftAutoConfig());
            return;
        }
        this.gmacsChatActivity.setShouldShowInputSoftAuto(false);
    }

    public void showInputSoft() {
        ((InputMethodManager)this.getContext().getSystemService("input_method")).toggleSoftInput(0, 1);
    }

    public void stopRecord() {
        if (this.mRecord != null && this.mRecord.isRecording()) {
            if (this.mRecordVoice != null) {
                this.mRecordVoice.setText((CharSequence)this.getContext().getString(R.string.record_start));
                this.mRecordVoice.setSelected(false);
            }
            this.mRecord.stopRecord();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchSendEmoji() {
        this.mSendVoice.setImageResource(R.drawable.gmacs_ic_voice);
        this.mRecordVoice.setVisibility(8);
        this.sendMessageEditText.setVisibility(0);
        this.mSendMoreLayout.setVisibility(8);
        this.mQuickMsgLayout.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)this.sendMessageEditText.getText().toString())) {
            this.sendTextButton.setVisibility(0);
            this.mSendMoreButton.setVisibility(8);
        }
        this.hiddenInputSoft();
        if (!this.mEmojiLayout.faceViewShown() && this.inputSoftIsShow) {
            this.needShowEmojiLayoutInOnHide = true;
            return;
        }
        if (!this.mEmojiLayout.faceViewShown()) {
            this.mEmojiLayout.show();
            return;
        }
        this.mEmojiLayout.hidden();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchSendMore() {
        this.sendMessageEditText.setVisibility(0);
        this.mSendVoice.setImageResource(R.drawable.gmacs_ic_voice);
        this.mRecordVoice.setVisibility(8);
        this.mQuickMsgLayout.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)this.sendMessageEditText.getText().toString())) {
            this.sendTextButton.setVisibility(0);
            this.mSendMoreButton.setVisibility(8);
        }
        this.mEmojiLayout.hidden();
        this.hiddenInputSoft();
        if (!this.mSendMoreLayout.isShown() && this.inputSoftIsShow) {
            this.needShowSendMoreLayoutInOnHide = true;
            return;
        }
        if (!this.mSendMoreLayout.isShown()) {
            this.mSendMoreLayout.setVisibility(0);
            return;
        }
        this.mSendMoreLayout.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchSendQuickMsg() {
        this.mRecordVoice.setVisibility(8);
        this.sendMessageEditText.setVisibility(0);
        this.mSendMoreLayout.setVisibility(8);
        this.mEmojiLayout.hidden();
        if (!TextUtils.isEmpty((CharSequence)this.sendMessageEditText.getText().toString())) {
            this.sendTextButton.setVisibility(0);
            this.mSendMoreButton.setVisibility(8);
        }
        this.hiddenInputSoft();
        if (this.mQuickMsgLayout.getVisibility() == 0) {
            this.mQuickMsgLayout.setVisibility(8);
            return;
        }
        this.mQuickMsgLayout.setVisibility(0);
    }

    public void switchSendText() {
        this.switchSendText(true);
    }

    public void switchSendText(boolean bl2) {
        this.mSendVoice.setImageResource(R.drawable.gmacs_ic_voice);
        this.mRecordVoice.setVisibility(8);
        this.sendMessageEditText.setVisibility(0);
        this.mSendMoreLayout.setVisibility(8);
        this.mQuickMsgLayout.setVisibility(8);
        if (!TextUtils.isEmpty((CharSequence)this.sendMessageEditText.getText().toString())) {
            this.sendTextButton.setVisibility(0);
            this.mSendMoreButton.setVisibility(8);
        }
        this.mEmojiLayout.hidden();
        this.sendMessageEditText.requestFocus();
        if (bl2) {
            this.showInputSoft();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void switchSendVoice() {
        if (this.mRecordVoice.isShown()) {
            this.switchSendText();
            return;
        }
        this.mSendVoice.setImageResource(R.drawable.gmacs_ic_keyboard);
        this.mRecordVoice.setVisibility(0);
        this.mSendVoice.setVisibility(0);
        this.sendMessageEditText.setVisibility(8);
        this.sendTextButton.setVisibility(8);
        this.mSendMoreLayout.setVisibility(8);
        this.mQuickMsgLayout.setVisibility(8);
        this.mEmojiLayout.hidden();
        this.hiddenInputSoft();
    }
}

