/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.logic;

import com.android.gmacs.event.FriendUnreadCountEvent;
import com.android.gmacs.event.RecentTalksEvent;
import com.android.gmacs.event.UnreadTotalEvent;
import com.android.gmacs.logic.BaseLogic;
import com.android.gmacs.logic.MessageLogic;
import com.android.gmacs.logic.TalkLogic;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.core.MessageManager;
import com.common.gmacs.core.RecentTalkManager;
import com.common.gmacs.utils.GLog;
import com.ganji.android.comp.utils.n;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.c;

public class TalkLogic
extends BaseLogic
implements RecentTalkManager.TalkChangeListener {
    private static volatile TalkLogic ourInstance;
    private final List<Integer> msgTypeList = new ArrayList<Integer>();

    private TalkLogic() {
        this.msgTypeList.add(Gmacs.TalkType.TALKETYPE_SYSTEM.getValue());
        this.msgTypeList.add(Gmacs.TalkType.TALKETYPE_NORMAL.getValue());
        this.msgTypeList.add(Gmacs.TalkType.TALKETYPE_OFFICIAL.getValue());
        this.msgTypeList.add(Gmacs.TalkType.TALKETYPE_POSTINGS.getValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TalkLogic getInstance() {
        if (ourInstance == null) {
            synchronized (TalkLogic.class) {
                if (ourInstance == null) {
                    TalkLogic talkLogic;
                    ourInstance = talkLogic = new TalkLogic();
                }
            }
        }
        return ourInstance;
    }

    public void deleteTalk(String string2, int n2) {
        RecentTalkManager.getInstance().deleteTalkByIdAsync(string2, n2, new 2(this));
    }

    @Override
    public void destroy() {
        c.a().c(new RecentTalksEvent(null));
        c.a().c(new UnreadTotalEvent(0));
        c.a().c(new FriendUnreadCountEvent(0));
    }

    public void getRecentTalks() {
        GLog.d(this.TAG, "getRecentTalks");
        this.getRecentTalks(this.msgTypeList);
    }

    public void getRecentTalks(List<Integer> list) {
        RecentTalkManager.getInstance().getTalkByMsgTypeAsync(list, new 1(this));
    }

    @Override
    public void init() {
        RecentTalkManager.getInstance().registerTalkListChangeListener(this);
        MessageManager.getInstance().addSendIMMsgListener(RecentTalkManager.getInstance());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onTalkListChanged() {
        try {
            this.getRecentTalks();
            MessageLogic.getInstance().getUnreadFriendCount();
            n.a("FILE_IM_WEILIAO", "KEY_IM_INIT", true);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            GLog.e(this.TAG, unsatisfiedLinkError.getMessage());
            n.a("FILE_IM_WEILIAO", "KEY_IM_INIT", false);
            return;
        }
    }

    public void syncRecentTalks() {
        GLog.d(this.TAG, "syncRecentTalks");
        this.syncRecentTalks(this.msgTypeList);
    }

    public void syncRecentTalks(List<Integer> list) {
        RecentTalkManager.getInstance().syncTalkListByMsgTypeAsync(list);
    }

    public void updateTalkRead(String string2, int n2) {
        RecentTalkManager.getInstance().updateTalkRead(string2, n2);
    }
}

