/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.logic;

import android.text.TextUtils;
import com.android.gmacs.core.UserInfoCacheManager;
import com.android.gmacs.logic.BaseLogic;
import com.android.gmacs.logic.MessageLogic;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.core.MessageManager;
import com.common.gmacs.core.RecentTalkManager;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.parse.message.Message;
import java.util.ArrayList;
import org.greenrobot.eventbus.c;

public class MessageLogic
extends BaseLogic
implements MessageManager.RecvMsgListener {
    private static volatile MessageLogic ourInstance;
    private NotifyHelper notifyHelper;

    private MessageLogic() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessageLogic getInstance() {
        if (ourInstance == null) {
            synchronized (MessageLogic.class) {
                if (ourInstance == null) {
                    MessageLogic messageLogic;
                    ourInstance = messageLogic = new MessageLogic();
                }
            }
        }
        return ourInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteMsgByLocalIds(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return;
        }
        MessageManager.getInstance().deleteMsgByLocalIdAsync(lArray, (MessageManager.ActionCb)new 2(this));
    }

    @Override
    public void destroy() {
    }

    public void getHistoryMessages(String string2, int n2, long l2, int n3) {
        MessageManager.getInstance().getHistoryAsync(string2, n2, l2, n3, new 1(this));
    }

    public void getUnreadFriendCount() {
        MessageManager.getInstance().getUnreadCountByTalkIdAsync("SYSTEM_FRIEND", 1999, new 3(this));
    }

    @Override
    public void init() {
        MessageManager.getInstance().regRecvMsgListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void msgRecved(Message message) {
        boolean bl2 = false;
        c.a().c(message);
        if (message.mMsgDetail.getReadStatus() == 0) {
            Message.MessageUserInfo messageUserInfo = message.getTalkOtherUserInfo();
            GmacsUserInfo gmacsUserInfo = messageUserInfo.gmacsUserInfo;
            if (gmacsUserInfo != null && TextUtils.equals((CharSequence)messageUserInfo.mUserId, (CharSequence)gmacsUserInfo.userId) && messageUserInfo.mUserSource == gmacsUserInfo.userSource) {
                UserInfoCacheManager.getInstance().updateUserInfoToCache(gmacsUserInfo);
            }
        }
        if (message.mMsgDetail.getmMsgContent().isNotice() && this.notifyHelper != null) {
            boolean bl3 = !RecentTalkManager.getInstance().isBelongTalking(message) || !RecentTalkManager.getInstance().isTalking();
            if (message.mMsgDetail == null || 1 == message.mMsgDetail.getReadStatus()) {
                bl2 = true;
            }
            long l2 = ClientManager.getInstance().getLoginTimeStamp();
            if (bl3 && !bl2 && message.mMsgDetail.mMsgUpdateTime >= l2) {
                this.notifyHelper.showNotify(message);
            }
        }
    }

    public void setNotifyHelper(NotifyHelper notifyHelper) {
        this.notifyHelper = notifyHelper;
    }

    public void updatePlayStatusByLocalId(long l2, int n2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l2);
        MessageManager.getInstance().updatePlayStatusBatchByLocalIdAsync(arrayList, n2, null);
    }
}

