/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.logic;

import com.android.gmacs.logic.BaseLogic;
import com.android.gmacs.logic.ContactLogic;
import com.common.gmacs.core.CommandManager;
import com.common.gmacs.parse.command.CallCommand;
import com.common.gmacs.parse.command.Command;

public class CommandLogic
extends BaseLogic
implements CommandManager.OnReceivedCommandListener {
    private static volatile CommandLogic ourInstance;
    private WRTCProxy mWRTCProxy;

    private CommandLogic() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandLogic getInstance() {
        if (ourInstance == null) {
            synchronized (ContactLogic.class) {
                if (ourInstance == null) {
                    CommandLogic commandLogic;
                    ourInstance = commandLogic = new CommandLogic();
                }
            }
        }
        return ourInstance;
    }

    @Override
    public void destroy() {
    }

    public void finishCall() {
        if (this.isChatting() && this.mWRTCProxy != null) {
            this.mWRTCProxy.finishCall();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getChattingType() {
        if (this.mWRTCProxy != null) return this.mWRTCProxy.getChattingType();
        return -1;
    }

    @Override
    public void init() {
        CommandManager.getInstance().registerOnReceivedCommandListener((CommandManager.OnReceivedCommandListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChatting() {
        if (this.getChattingType() < 0) return false;
        return true;
    }

    @Override
    public void onReceivedCommand(Command command) {
        if (command instanceof CallCommand && this.mWRTCProxy != null) {
            this.mWRTCProxy.onReceivedCall((CallCommand)command);
        }
    }

    public void setWRTCProxy(WRTCProxy wRTCProxy) {
        this.mWRTCProxy = wRTCProxy;
    }

    public void startCall(CallCommand callCommand) {
        if (this.mWRTCProxy != null) {
            this.mWRTCProxy.startCall(callCommand);
        }
    }

    public static interface WRTCProxy {
        public void finishCall();

        public int getChattingType();

        public void onReceivedCall(CallCommand var1);

        public void startCall(CallCommand var1);
    }
}

