/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.album;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.common.gmacs.utils.GLog;
import com.ganji.android.core.e.d;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GmacsImageDao {
    private static GmacsImageDao sInstance = null;
    private final String TAG = GmacsImageDao.class.getSimpleName();
    private final String _DCIM;
    private List<String> deleteList;
    private List<ImgDir> mImgDirsCover;
    private String mLocalExternalPath = Environment.getExternalStorageDirectory().getAbsoluteFile().getAbsolutePath();

    private GmacsImageDao() {
        this.mImgDirsCover = new ArrayList<ImgDir>();
        this.deleteList = new ArrayList<String>();
        this._DCIM = "/" + Environment.DIRECTORY_DCIM + "/";
    }

    public static void destroy() {
        if (sInstance != null) {
            if (GmacsImageDao.sInstance.mImgDirsCover != null) {
                GmacsImageDao.sInstance.mImgDirsCover.clear();
            }
            if (GmacsImageDao.sInstance.deleteList != null) {
                GmacsImageDao.sInstance.deleteList.clear();
            }
            sInstance = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void genImageByLocalData(Cursor object) {
        String string2 = object.getString(object.getColumnIndex("_data"));
        if (TextUtils.isEmpty((CharSequence)string2) || !new File(string2).exists()) {
            this.deleteList.add(object.getString(object.getColumnIndex("_id")));
            return;
        }
        if (object.getInt(object.getColumnIndex("_size")) < 4096) return;
        object = string2.substring(0, string2.lastIndexOf("/"));
        String string3 = ((String)object).substring(((String)object).lastIndexOf("/") + 1, ((String)object).length());
        if (this.getImgDirByPath((String)object) != null && !string2.toLowerCase().contains("/cache/")) {
            this.getImgDirByPath((String)object).dataList.add(string2);
            return;
        }
        if (string2.toString().toLowerCase().contains("/cache/")) return;
        object = new ImgDir(string3, (String)object, string2);
        ((ImgDir)object).dataList.add(string2);
        this.mImgDirsCover.add((ImgDir)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImgDir getImgDirByPath(String object) {
        int n2 = 0;
        while (n2 < this.mImgDirsCover.size()) {
            ImgDir imgDir = this.mImgDirsCover.get(n2);
            if (object != null && ((String)object).equals(imgDir.dirPath)) {
                return imgDir;
            }
            ++n2;
        }
        return null;
    }

    public static GmacsImageDao instance(Context context) {
        if (sInstance == null) {
            sInstance = new GmacsImageDao();
        }
        return sInstance;
    }

    private void mySort() {
        Collections.sort(this.mImgDirsCover);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scanLocalImageLib(String charSequence) {
        block13: {
            Uri uri;
            ContentResolver contentResolver;
            block14: {
                Object object;
                block12: {
                    this.deleteList.clear();
                    d.a.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_STARTED", Uri.parse((String)("file://" + this.mLocalExternalPath))));
                    contentResolver = d.a.getContentResolver();
                    uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("(").append("_data").append(" LIKE '").append((String)charSequence).append("%jpg' OR ").append("_data").append(" LIKE '").append((String)charSequence).append("%jpeg' OR ").append("_data").append(" LIKE '").append((String)charSequence).append("%png' OR ").append("_data").append(" LIKE '").append((String)charSequence).append("%JPG' OR ").append("_data").append(" LIKE '").append((String)charSequence).append("%JPEG' OR ").append("_data").append(" LIKE '").append((String)charSequence).append("%PNG') AND ").append("_data").append(" IS NOT NULL ");
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("date_modified").append(" DESC ").append(" , ").append("date_added").append(" DESC ");
                    try {
                        charSequence = contentResolver.query(uri, null, ((StringBuilder)object).toString(), null, ((StringBuilder)charSequence).toString());
                    }
                    catch (Exception exception) {
                        GLog.e(this.TAG, exception.getMessage(), exception);
                        charSequence = null;
                    }
                    if (charSequence != null) {
                        boolean bl2;
                        if (!charSequence.moveToFirst()) break block12;
                        do {
                            this.genImageByLocalData((Cursor)charSequence);
                        } while (bl2 = charSequence.moveToNext());
                    }
                }
                if (this.deleteList.size() <= 0) break block13;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("_id").append(" in(");
                object = this.deleteList.iterator();
                while (object.hasNext()) {
                    ((StringBuilder)charSequence).append((String)object.next()).append(",");
                }
                break block14;
                finally {
                    if (charSequence != null) {
                        charSequence.close();
                    }
                }
            }
            if (((StringBuilder)charSequence).toString().endsWith(",")) {
                ((StringBuilder)charSequence).deleteCharAt(((StringBuilder)charSequence).length() - 1);
            }
            ((StringBuilder)charSequence).append(") OR ").append("_data").append(" IS NULL ");
            try {
                contentResolver.delete(uri, ((StringBuilder)charSequence).toString(), null);
            }
            catch (SQLException sQLException) {
                GLog.e(this.TAG, sQLException.getMessage(), sQLException);
            }
        }
        this.mySort();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ImgDir getDefaultDir() {
        ImgDir imgDir;
        ImgDir imgDir2;
        int n2;
        int n3 = 0;
        ImgDir imgDir3 = null;
        for (n2 = 0; n2 < this.mImgDirsCover.size(); ++n2) {
            block11: {
                block9: {
                    block10: {
                        if (!this.mImgDirsCover.get((int)n2).dirPath.contains(this._DCIM) || this.mImgDirsCover.get((int)n2).dataList.size() <= 0) break block9;
                        imgDir2 = this.mImgDirsCover.get(n2);
                        if (imgDir3 != null) break block10;
                        imgDir = imgDir2;
                        break block11;
                    }
                    imgDir = imgDir2;
                    if (imgDir3.dataList.size() < imgDir2.dataList.size()) break block11;
                }
                imgDir = imgDir3;
            }
            imgDir3 = imgDir;
        }
        imgDir = imgDir3;
        if (imgDir3 == null) {
            n2 = n3;
            while (true) {
                imgDir = imgDir3;
                if (n2 >= this.mImgDirsCover.size()) break;
                imgDir2 = this.mImgDirsCover.get(n2);
                if (imgDir3 == null) {
                    imgDir = imgDir2;
                } else {
                    imgDir = imgDir3;
                    if (imgDir3.dataList.size() < imgDir2.dataList.size()) {
                        imgDir = imgDir2;
                    }
                }
                ++n2;
                imgDir3 = imgDir;
            }
        }
        return imgDir;
    }

    public ImgDir getImgListByDir(String string2) {
        if (this.mImgDirsCover.size() == 0 || this.getImgDirByPath(string2) == null) {
            this.scanLocalImageLib("");
        }
        return this.getImgDirByPath(string2);
    }

    public List<ImgDir> loadAllImgDirs() {
        if (this.mImgDirsCover.size() == 0) {
            this.scanLocalImageLib("");
        }
        return this.mImgDirsCover;
    }

    public static class ImgDir
    implements Comparable<ImgDir> {
        public String coverPath;
        public final List<String> dataList = new ArrayList<String>();
        public String dirName;
        public String dirPath;
        public long updateTime;

        public ImgDir(String string2, String string3, String string4) {
            this.dirName = string2;
            this.dirPath = string3;
            this.coverPath = string4;
            this.updateTime = System.currentTimeMillis();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(ImgDir imgDir) {
            int n2;
            int n3 = n2 = 0;
            if (imgDir == null) return n3;
            if (imgDir.updateTime > this.updateTime) {
                return -1;
            }
            n3 = n2;
            if (imgDir.updateTime >= this.updateTime) return n3;
            return 1;
        }

        public String toString() {
            return "ImgDir [dirName=" + this.dirName + ", dirPath=" + this.dirPath + ", coverPath=" + this.coverPath + ", dataList=" + this.dataList + "]";
        }
    }
}

