/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.adapter;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.gmacs.R;
import com.android.gmacs.activity.GmacsChatActivity;
import com.android.gmacs.adapter.GmacsChatAdapter;
import com.android.gmacs.logic.MessageLogic;
import com.android.gmacs.msg.view.IMMessageView;
import com.android.gmacs.msg.view.IMViewFactory;
import com.common.gmacs.core.Gmacs;
import com.common.gmacs.msg.IMMessage;
import com.common.gmacs.msg.data.IMTextMsg;
import com.common.gmacs.parse.contact.GmacsUser;
import com.common.gmacs.parse.message.GmacsUserInfo;
import com.common.gmacs.parse.message.Message;
import com.common.gmacs.parse.talk.Talk;
import com.common.gmacs.parse.talk.TalkType;
import com.common.gmacs.utils.GmacsUiUtil;
import com.common.gmacs.utils.NetworkUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class GmacsChatAdapter
extends BaseAdapter
implements View.OnClickListener {
    public static int BASE_NUM = 0;
    private static final int FIVE_MINUTE = 300000;
    public static int ITEM_TYPE_EMPTY = 0;
    public static int ITEM_TYPE_GROUP_JOIN = 0;
    public static int ITEM_TYPE_LEFT_AUDIO = 0;
    public static int ITEM_TYPE_LEFT_CALL = 0;
    public static int ITEM_TYPE_LEFT_GIF = 0;
    public static int ITEM_TYPE_LEFT_MAP = 0;
    public static int ITEM_TYPE_LEFT_PIC = 0;
    public static int ITEM_TYPE_LEFT_TEXT = 0;
    public static int ITEM_TYPE_RIGHT_AUDIO = 0;
    public static int ITEM_TYPE_RIGHT_CALL = 0;
    public static int ITEM_TYPE_RIGHT_GIF = 0;
    public static int ITEM_TYPE_RIGHT_MAP = 0;
    public static int ITEM_TYPE_RIGHT_PIC = 0;
    public static int ITEM_TYPE_RIGHT_TEXT = 0;
    public static int ITEM_TYPE_TIP = 0;
    private static final int ONE_MINUTE = 60000;
    private long lastTime;
    protected View.OnClickListener leftAvatarListener;
    protected GmacsChatActivity mActivity;
    protected ArrayList<Message> mAllMessage = new ArrayList();
    private IMViewFactory mIMViewFactory = new IMViewFactory();
    protected LayoutInflater mInflater;
    private SimpleDateFormat mSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
    protected Talk mTalk;
    protected View.OnClickListener rightAvatarListener;
    private ArrayList<Long> timesMap = new ArrayList();

    static {
        int n2 = BASE_NUM = 0;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_EMPTY = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_GROUP_JOIN = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_TIP = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_TEXT = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_AUDIO = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_PIC = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_GIF = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_CALL = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_RIGHT_MAP = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_TEXT = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_AUDIO = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_PIC = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_GIF = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_CALL = n2;
        n2 = BASE_NUM;
        BASE_NUM = n2 + 1;
        ITEM_TYPE_LEFT_MAP = n2;
    }

    public GmacsChatAdapter(Context context, Talk talk) {
        this.mActivity = (GmacsChatActivity)context;
        this.mTalk = talk;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    @NonNull
    private View createEmptyMsgView() {
        TextView textView = new TextView((Context)this.mActivity);
        textView.setVisibility(8);
        return textView;
    }

    private int findSimilarMessageTime(Message message) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            block4: {
                block3: {
                    n4 = n3;
                    if (n2 >= this.mAllMessage.size()) break block3;
                    Message message2 = this.mAllMessage.get(n2);
                    n4 = n3++;
                    if (Math.abs(message2.mMsgDetail.mMsgUpdateTime - message.mMsgDetail.mMsgUpdateTime) > 60000L) break block4;
                    n4 = n3;
                    if (!message2.equals(message)) break block4;
                    n4 = n3;
                }
                return n4;
            }
            ++n2;
            n3 = n4;
        }
    }

    private void replaceAloneSendProgressBar(MsgViewHolder msgViewHolder, View view) {
        if ((view = (ProgressBar)view.findViewById(R.id.send_progress)) != null && msgViewHolder.sending != null) {
            msgViewHolder.sending.setVisibility(8);
            msgViewHolder.sending = view;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setMsgSendState(IMMessage iMMessage, MsgViewHolder msgViewHolder) {
        if (iMMessage == null) {
            return;
        }
        if (msgViewHolder.sendFailed == null) return;
        if (msgViewHolder.sending == null) return;
        switch (iMMessage.parentMsg.getSendStatus()) {
            default: {
                return;
            }
            case 0: 
            case 3: 
            case 4: {
                msgViewHolder.sendFailed.setVisibility(8);
                msgViewHolder.sending.setVisibility(8);
                return;
            }
            case 2: {
                msgViewHolder.sendFailed.setVisibility(0);
                msgViewHolder.sending.setVisibility(8);
                return;
            }
            case 1: 
        }
        if (NetworkUtil.isNetworkAvailable()) {
            msgViewHolder.sendFailed.setVisibility(8);
            msgViewHolder.sending.setVisibility(0);
            return;
        }
        msgViewHolder.sendFailed.setVisibility(0);
        msgViewHolder.sending.setVisibility(8);
    }

    private int similarMessageTimeAmount(Message message) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.timesMap.size(); ++i2) {
            int n3 = n2;
            if (Math.abs(this.timesMap.get(i2) - message.mMsgDetail.mMsgUpdateTime) <= 60000L) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    public void addMsgToEndPosition(Message message) {
        if (message != null) {
            this.mAllMessage.add(message);
            this.notifyDataSetChanged();
        }
    }

    public void addMsgsToStartPosition(Message message) {
        if (message != null) {
            this.mAllMessage.add(0, message);
            this.notifyDataSetChanged();
        }
    }

    public void addMsgsToStartPosition(List<Message> object) {
        if (object != null && object.size() > 0) {
            Iterator<Message> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.mAllMessage.add(0, (Message)object);
            }
            this.notifyDataSetChanged();
        }
    }

    protected void bindViewCommon(int n2, Message message, MsgViewHolder msgViewHolder) {
        this.setMsgViewTime(n2, message, msgViewHolder);
        if (msgViewHolder.sendFailed != null) {
            msgViewHolder.sendFailed.setTag((Object)message);
            msgViewHolder.sendFailed.setOnClickListener((View.OnClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void bindViewContent(int n2, IMMessage iMMessage, MsgViewHolder msgViewHolder) {
        IMMessageView iMMessageView;
        if (msgViewHolder.contentItem != null && (iMMessageView = (IMMessageView)msgViewHolder.contentItem.getTag()) != null) {
            iMMessageView.init(n2, this, this.mActivity, iMMessage);
            iMMessageView.setDataForView();
        }
        this.setMsgSendState(iMMessage, msgViewHolder);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void bindViewUserInfo(Message message, MsgViewHolder msgViewHolder, ContainerType containerType) {
        switch (1.$SwitchMap$com$android$gmacs$adapter$GmacsChatAdapter$ContainerType[containerType.ordinal()]) {
            case 1: {
                this.initLeftUser(msgViewHolder, message);
            }
            default: {
                return;
            }
            case 2: 
        }
        this.initRightUser(msgViewHolder);
    }

    public void clearData() {
        this.mAllMessage.clear();
        this.notifyDataSetChanged();
    }

    protected View createContainerView(ContainerType containerType, MsgViewHolder msgViewHolder) {
        containerType = this.inflateContainerView(containerType);
        msgViewHolder.time = (TextView)containerType.findViewById(R.id.time);
        msgViewHolder.contentItem = (ViewGroup)containerType.findViewById(R.id.content_item);
        msgViewHolder.leftHead = (ImageView)containerType.findViewById(R.id.left_head);
        msgViewHolder.rightHead = (ImageView)containerType.findViewById(R.id.right_head);
        msgViewHolder.leftName = (TextView)containerType.findViewById(R.id.left_name);
        msgViewHolder.sending = (ProgressBar)containerType.findViewById(R.id.send_progress);
        msgViewHolder.sendFailed = (ImageView)containerType.findViewById(R.id.right_failed_sendf);
        containerType.setTag((Object)msgViewHolder);
        return containerType;
    }

    protected int defaultLeftAvatarRes() {
        return R.drawable.gmacs_ic_default_avatar;
    }

    protected int defaultRightAvatarRes() {
        return R.drawable.gmacs_ic_default_avatar;
    }

    public void deleteMsg(int n2) {
        Message message = this.mAllMessage.remove(n2);
        message.isDeleted = true;
        this.notifyDataSetChanged();
        MessageLogic.getInstance().deleteMsgByLocalIds(new long[]{message.mId});
    }

    public void deleteMsgs(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Message message = this.mAllMessage.remove(nArray[i2]);
            message.isDeleted = true;
            lArray[i2] = message.mId;
        }
        this.notifyDataSetChanged();
        MessageLogic.getInstance().deleteMsgByLocalIds(lArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ContainerType getContainerType(int n2) {
        if (n2 < ITEM_TYPE_RIGHT_TEXT) {
            return ContainerType.MIDDLE;
        }
        if (n2 < ITEM_TYPE_LEFT_TEXT) {
            return ContainerType.RIGHT;
        }
        if (n2 > ITEM_TYPE_LEFT_MAP) return ContainerType.MIDDLE;
        return ContainerType.LEFT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCount() {
        if (this.mAllMessage == null) return 0;
        return this.mAllMessage.size();
    }

    public Message getItem(int n2) {
        Message message;
        Message message2 = message = null;
        if (n2 >= 0) {
            message2 = message;
            if (n2 <= this.mAllMessage.size() - 1) {
                message2 = this.mAllMessage.get(n2);
            }
        }
        return message2;
    }

    public long getItemId(int n2) {
        return n2;
    }

    public int getItemViewType(int n2) {
        Message message = this.mAllMessage.get(n2);
        boolean bl2 = message.mMsgDetail.mIsSelfSendMsg;
        return this.getItemViewType(this.getMessageContent(message), bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int getItemViewType(IMMessage object, boolean bl2) {
        object = ((IMMessage)object).mType;
        int n2 = -1;
        switch (((String)object).hashCode()) {
            case 1282201322: {
                if (!((String)object).equals("group_join")) break;
                n2 = 0;
                break;
            }
            case 114843: {
                if (!((String)object).equals("tip")) break;
                n2 = 1;
                break;
            }
            case 3556653: {
                if (!((String)object).equals("text")) break;
                n2 = 2;
                break;
            }
            case 93166550: {
                if (!((String)object).equals("audio")) break;
                n2 = 3;
                break;
            }
            case 100313435: {
                if (!((String)object).equals("image")) break;
                n2 = 4;
                break;
            }
            case 1901043637: {
                if (!((String)object).equals("location")) break;
                n2 = 5;
                break;
            }
            case 102340: {
                if (!((String)object).equals("gif")) break;
                n2 = 6;
                break;
            }
            case 3045982: {
                if (!((String)object).equals("call")) break;
                n2 = 7;
                break;
            }
        }
        switch (n2) {
            default: {
                return ITEM_TYPE_EMPTY;
            }
            case 0: {
                return ITEM_TYPE_GROUP_JOIN;
            }
            case 1: {
                return ITEM_TYPE_TIP;
            }
            case 2: {
                if (!bl2) return ITEM_TYPE_LEFT_TEXT;
                return ITEM_TYPE_RIGHT_TEXT;
            }
            case 3: {
                if (!bl2) return ITEM_TYPE_LEFT_AUDIO;
                return ITEM_TYPE_RIGHT_AUDIO;
            }
            case 4: {
                if (!bl2) return ITEM_TYPE_LEFT_PIC;
                return ITEM_TYPE_RIGHT_PIC;
            }
            case 5: {
                if (!bl2) return ITEM_TYPE_LEFT_MAP;
                return ITEM_TYPE_RIGHT_MAP;
            }
            case 6: {
                if (!bl2) return ITEM_TYPE_LEFT_GIF;
                return ITEM_TYPE_RIGHT_GIF;
            }
            case 7: 
        }
        if (!bl2) return ITEM_TYPE_LEFT_CALL;
        return ITEM_TYPE_RIGHT_CALL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMMessage getMessageContent(Message object) {
        if (((Message)object).mMsgDetail != null) return ((Message)object).mMsgDetail.getmMsgContent();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View getView(int n2, View view, ViewGroup object) {
        MsgViewHolder msgViewHolder;
        Message message = this.mAllMessage.get(n2);
        IMMessage iMMessage = this.getMessageContent(message);
        int n3 = this.getItemViewType(iMMessage, message.mMsgDetail.mIsSelfSendMsg);
        ContainerType containerType = this.getContainerType(n3);
        if (n3 == ITEM_TYPE_EMPTY) {
            object = view;
            if (view != null) return object;
            return this.createEmptyMsgView();
        }
        if (view == null) {
            msgViewHolder = new /* Unavailable Anonymous Inner Class!! */;
            view = this.createContainerView(containerType, msgViewHolder);
            object = this.mIMViewFactory.createItemView(iMMessage);
            this.replaceAloneSendProgressBar(msgViewHolder, ((IMMessageView)object).createIMView(iMMessage, msgViewHolder.contentItem, this.mInflater, n2, this, this.mActivity));
            msgViewHolder.contentItem.setTag(object);
        } else {
            msgViewHolder = view.getTag();
        }
        object = view;
        if (msgViewHolder == null) return object;
        this.bindViewContent(n2, iMMessage, msgViewHolder);
        this.bindViewCommon(n2, message, msgViewHolder);
        this.bindViewUserInfo(message, msgViewHolder, containerType);
        return view;
    }

    public int getViewTypeCount() {
        return BASE_NUM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected View inflateContainerView(ContainerType containerType) {
        switch (1.$SwitchMap$com$android$gmacs$adapter$GmacsChatAdapter$ContainerType[containerType.ordinal()]) {
            default: {
                return this.mInflater.inflate(R.layout.gmacs_adapter_chat_notice_item, null);
            }
            case 1: {
                return this.mInflater.inflate(R.layout.gmacs_adapter_chat_left_item, null);
            }
            case 2: 
        }
        return this.mInflater.inflate(R.layout.gmacs_adapter_chat_right_item, null);
    }

    public void initLeftUser(MsgViewHolder msgViewHolder, Message message) {
    }

    public void initRightUser(MsgViewHolder msgViewHolder) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String messageTimeFormat(long l2) {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(6);
        int n5 = calendar.get(4);
        calendar.setTimeInMillis(l2);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        int n6 = calendar.get(1);
        int n7 = calendar.get(2);
        int n8 = calendar.get(6);
        int n9 = calendar.get(4);
        if (n2 == n6) {
            CharSequence charSequence;
            n2 = n4 - n8;
            if (n2 == 0) {
                this.mSimpleDateFormat.applyPattern("HH:mm");
                return this.mSimpleDateFormat.format(calendar.getTime());
            }
            if (n2 == 1) {
                this.mSimpleDateFormat.applyPattern("HH:mm");
                charSequence = this.mSimpleDateFormat.format(calendar.getTime());
                return "\u6628\u5929" + (String)charSequence;
            }
            if ((n5 - 1 == n9 - 1 || n3 - n7 == 1) && n2 < 7) {
                n9 = calendar.get(7) - 1;
                this.mSimpleDateFormat.applyPattern("HH:mm");
                charSequence = new StringBuilder();
                if (n9 >= 0) {
                    return ((StringBuilder)charSequence).append((new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"})[n9]).append(this.mSimpleDateFormat.format(calendar.getTime())).toString();
                }
                n9 = 0;
                return ((StringBuilder)charSequence).append((new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"})[n9]).append(this.mSimpleDateFormat.format(calendar.getTime())).toString();
            }
            this.mSimpleDateFormat.applyPattern("MM-dd HH:mm");
            return this.mSimpleDateFormat.format(calendar.getTime());
        }
        this.mSimpleDateFormat.applyPattern("yyyy-MM-dd HH:mm");
        return this.mSimpleDateFormat.format(calendar.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String messageTimeFormat(Message message, Message object) {
        String string2 = "";
        if (message.mMsgDetail.getSendStatus() == 2) {
            return "";
        }
        if (object != null) {
            if (((Message)object).mMsgDetail.getSendStatus() == 2) {
                return "";
            }
            long l2 = ((Message)object).mMsgDetail.mMsgUpdateTime;
            long l3 = message.mMsgDetail.mMsgUpdateTime;
            object = string2;
            if (Math.abs(l3 - l2) <= 300000L) return object;
            if (Math.abs(l3 - this.lastTime) <= 60000L) {
                this.lastTime -= 60000L;
                return this.messageTimeFormat(this.lastTime);
            }
            this.lastTime = message.mMsgDetail.mMsgUpdateTime;
            return this.messageTimeFormat(this.lastTime);
        }
        if (Math.abs(message.mMsgDetail.mMsgUpdateTime - this.lastTime) <= 60000L) {
            this.lastTime -= 60000L;
            return this.messageTimeFormat(this.lastTime);
        }
        this.lastTime = message.mMsgDetail.mMsgUpdateTime;
        return this.messageTimeFormat(this.lastTime);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onClick(View object) {
        if (object.getId() == R.id.right_head) {
            try {
                Intent intent = new Intent((Context)this.mActivity, Class.forName(GmacsUiUtil.getContactDetailInfoActivityClassName()));
                GmacsUserInfo gmacsUserInfo = Gmacs.getInstance().getGmacsUserInfo();
                if (gmacsUserInfo == null) return;
                intent.putExtra("userid", gmacsUserInfo.userId);
                intent.putExtra("name", gmacsUserInfo.userName);
                intent.putExtra("avatar", gmacsUserInfo.avatar);
                intent.putExtra("usersource", gmacsUserInfo.userSource);
                intent.putExtra("deviceId", GmacsUser.getInstance().getDeviceId());
                intent.putExtra("talkType", Gmacs.TalkType.TALKETYPE_NORMAL.getValue());
                this.mActivity.startActivity(intent);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }
        if (object.getId() != R.id.left_head) return;
        Object object2 = object.getTag();
        if (object2 == null) return;
        if (!(object2 instanceof Message.MessageUserInfo)) return;
        Message.MessageUserInfo messageUserInfo = (Message.MessageUserInfo)object2;
        try {
            Intent intent = new Intent((Context)this.mActivity, Class.forName(GmacsUiUtil.getContactDetailInfoActivityClassName()));
            intent.putExtra("userid", messageUserInfo.mUserId);
            if (messageUserInfo.gmacsUserInfo != null) {
                intent.putExtra("name", messageUserInfo.gmacsUserInfo.userName);
                intent.putExtra("avatar", messageUserInfo.gmacsUserInfo.avatar);
            }
            intent.putExtra("usersource", messageUserInfo.mUserSource);
            intent.putExtra("deviceId", messageUserInfo.mDeviceId);
            intent.putExtra("talkType", Gmacs.TalkType.TALKETYPE_NORMAL.getValue());
            this.mActivity.startActivity(intent);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return;
        }
    }

    public void onLeftAvatarClickListener(View.OnClickListener onClickListener) {
        this.leftAvatarListener = onClickListener;
    }

    public void onRightAvatarClickListener(View.OnClickListener onClickListener) {
        this.rightAvatarListener = onClickListener;
    }

    public void removeMsgFromList(int n2) {
        this.mAllMessage.remove((int)n2).isDeleted = true;
        this.notifyDataSetChanged();
    }

    public void removeNvshenMesg() {
        IMMessage iMMessage;
        if (this.mAllMessage != null && this.mAllMessage.size() > 0 && (iMMessage = this.mAllMessage.get((int)0).mMsgDetail.getmMsgContent()) instanceof IMTextMsg && "nvshen".equals(((IMTextMsg)iMMessage).extra)) {
            this.mAllMessage.remove(0);
            this.notifyDataSetChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void sendFailedIMMsg(MsgViewHolder msgViewHolder) {
        if (this.mActivity == null) {
            return;
        }
        if (msgViewHolder.sending != null) {
            msgViewHolder.sending.setVisibility(0);
        }
        if (msgViewHolder.sendFailed == null) return;
        Message message = (Message)msgViewHolder.sendFailed.getTag();
        msgViewHolder.sendFailed.setVisibility(8);
        this.mActivity.reSendMsg(message);
    }

    public void setIMViewFactory(IMViewFactory iMViewFactory) {
        this.mIMViewFactory = iMViewFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setMsgViewTime(int n2, Message object, MsgViewHolder msgViewHolder) {
        if (!TalkType.isSystemTalk(this.mTalk)) {
            Message message = null;
            if (n2 - 1 >= 0) {
                message = this.mAllMessage.get(n2 - 1);
            }
            if (TextUtils.isEmpty((CharSequence)(object = this.messageTimeFormat((Message)object, message)))) {
                msgViewHolder.time.setVisibility(8);
                return;
            }
            msgViewHolder.time.setText((CharSequence)object);
            msgViewHolder.time.setVisibility(0);
            return;
        }
        msgViewHolder.time.setVisibility(8);
    }

    public void setTalk(Talk talk) {
        this.mTalk = talk;
    }
}

