/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.activity;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.android.gmacs.R;
import com.android.gmacs.activity.BaseActivity;
import com.android.gmacs.activity.GmacsImageActivity;
import com.android.gmacs.album.AlbumViewPager;
import com.android.gmacs.msg.view.IMImageMsgView;
import com.android.gmacs.view.GmacsDialog;
import com.android.gmacs.view.photoview.PhotoView;
import com.android.gmacs.view.photoview.PhotoViewAttacher;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.downloader.RequestManager;
import com.common.gmacs.downloader.VolleyError;
import com.common.gmacs.downloader.image.ImageLoader;
import com.common.gmacs.utils.BitmapUtil;
import com.common.gmacs.utils.FileUtil;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.ImageUtil;
import com.common.gmacs.utils.PermissionUtil;
import com.common.gmacs.utils.StringUtil;
import com.common.gmacs.utils.ToastUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class GmacsImageActivity
extends BaseActivity {
    private final int animationDuration;
    private int bitmapVisibleHeight;
    private int bitmapVisibleWidth;
    private boolean firstShown = true;
    private int mCurrentIndex;
    private int mEnterIndex;
    private ArrayList<IMImageMsgView.ImageInfoWrapper> mImageInfoList;
    private AlbumViewPager mImageViewPager;
    private RelativeLayout mLayout;
    private View.OnLongClickListener mPhotoOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View object) {
            object = new GmacsDialog.Builder((Context)GmacsImageActivity.this, 1);
            ((GmacsDialog.Builder)object).initDialog(new AdapterView.OnItemClickListener((GmacsDialog.Builder)object){
                final /* synthetic */ GmacsDialog.Builder val$dialog;
                {
                    this.val$dialog = builder;
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public void onItemClick(AdapterView<?> object, View object2, int n2, long l2) {
                    void var3_6;
                    if (var3_6 == false) {
                        String string2 = ((IMImageMsgView.ImageInfoWrapper)((GmacsImageActivity)GmacsImageActivity.this).mImageInfoList.get((int)((GmacsImageActivity)GmacsImageActivity.this).mCurrentIndex)).mUrl;
                        if (new File(BitmapUtil.SAVE_IMAGE_FILE_DIR, StringUtil.MD5(string2) + ".jpg").exists()) {
                            ToastUtil.showToast(GmacsImageActivity.this.getResources().getString(R.string.picture_already_saved, new Object[]{ClientManager.sAppName}));
                        } else {
                            GmacsImageActivity gmacsImageActivity = GmacsImageActivity.this;
                            1 var1_3 = new 1(this);
                            PermissionUtil.requestPermissions(gmacsImageActivity, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 2, (PermissionUtil.PermissionCallBack)var1_3);
                        }
                        this.val$dialog.dismiss();
                    }
                }
            }).setListTexts(new String[]{GmacsImageActivity.this.getString(R.string.save_picture)}).create().show();
            return true;
        }
    };
    private PhotoViewAttacher.OnPhotoTapListener mPhotoOnTapListener;
    private PhotoViewAttacher.OnViewTapListener mViewOnTapListener = new PhotoViewAttacher.OnViewTapListener(){

        @Override
        public void onViewTap(View view, float f2, float f3) {
            GmacsImageActivity.this.animateExit();
        }
    };

    public GmacsImageActivity() {
        this.animationDuration = 200;
        this.mPhotoOnTapListener = new PhotoViewAttacher.OnPhotoTapListener(){

            @Override
            public void onPhotoTap(View view, float f2, float f3) {
                GmacsImageActivity.this.animateExit();
            }
        };
    }

    static /* synthetic */ int access$002(GmacsImageActivity gmacsImageActivity, int n2) {
        gmacsImageActivity.mCurrentIndex = n2;
        return n2;
    }

    static /* synthetic */ RelativeLayout access$1100(GmacsImageActivity gmacsImageActivity) {
        return gmacsImageActivity.mLayout;
    }

    static /* synthetic */ void access$1300(GmacsImageActivity gmacsImageActivity) {
        gmacsImageActivity.saveImageToLocal();
    }

    static /* synthetic */ boolean access$1500(GmacsImageActivity gmacsImageActivity, Bitmap bitmap, String string2) {
        return gmacsImageActivity.saveImageToSdCard(bitmap, string2);
    }

    static /* synthetic */ int access$200(GmacsImageActivity gmacsImageActivity) {
        return gmacsImageActivity.mEnterIndex;
    }

    static /* synthetic */ void access$300(GmacsImageActivity gmacsImageActivity, Bitmap bitmap, PhotoView photoView) {
        gmacsImageActivity.animateEnter(bitmap, photoView);
    }

    static /* synthetic */ boolean access$400(GmacsImageActivity gmacsImageActivity) {
        return gmacsImageActivity.firstShown;
    }

    static /* synthetic */ int access$802(GmacsImageActivity gmacsImageActivity, int n2) {
        gmacsImageActivity.bitmapVisibleWidth = n2;
        return n2;
    }

    static /* synthetic */ int access$902(GmacsImageActivity gmacsImageActivity, int n2) {
        gmacsImageActivity.bitmapVisibleHeight = n2;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void animateEnter(final Bitmap bitmap, final PhotoView photoView) {
        if (!this.firstShown) {
            photoView.setImageBitmap(bitmap);
            return;
        }
        this.firstShown = false;
        photoView.post(new Runnable(this.getIntent()){
            final /* synthetic */ Intent val$intent;
            {
                this.val$intent = intent;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @TargetApi(value=11)
            public void run() {
                GmacsImageActivity.access$802(GmacsImageActivity.this, photoView.getWidth());
                if (bitmap.getHeight() * photoView.getWidth() >= bitmap.getWidth() * photoView.getHeight()) {
                    GmacsImageActivity.access$902(GmacsImageActivity.this, photoView.getHeight());
                } else {
                    GmacsImageActivity.access$902(GmacsImageActivity.this, Math.round((float)bitmap.getHeight() * 1.0f / (float)bitmap.getWidth() * (float)photoView.getWidth()));
                }
                int n2 = this.val$intent.getIntExtra("width", 0);
                int n3 = this.val$intent.getIntExtra("height", 0);
                int n4 = this.val$intent.getIntExtra("x", 0);
                int n5 = this.val$intent.getIntExtra("y", 0);
                GmacsImageActivity.this.mImageViewPager.setLayerType(2, null);
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)GmacsImageActivity.this.mImageViewPager), (String)"scaleX", (float[])new float[]{(float)n2 * 1.0f / (float)GmacsImageActivity.this.bitmapVisibleWidth, 1.0f});
                ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)GmacsImageActivity.this.mImageViewPager), (String)"scaleY", (float[])new float[]{(float)n3 * 1.0f / (float)GmacsImageActivity.this.bitmapVisibleHeight, 1.0f});
                ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)((Object)GmacsImageActivity.this.mImageViewPager), (String)"translationX", (float[])new float[]{-((GmacsEnvi.screenWidth - n2) / 2 - n4), 0.0f});
                ObjectAnimator objectAnimator4 = Build.VERSION.SDK_INT >= 21 ? ObjectAnimator.ofFloat((Object)((Object)GmacsImageActivity.this.mImageViewPager), (String)"translationY", (float[])new float[]{-((GmacsEnvi.screenHeight - n3) / 2 - n5), 0.0f}) : ObjectAnimator.ofFloat((Object)((Object)GmacsImageActivity.this.mImageViewPager), (String)"translationY", (float[])new float[]{(n3 - GmacsEnvi.screenHeight - GmacsEnvi.statusBarHeight) / 2 + n5, 0.0f});
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.play((Animator)objectAnimator).with((Animator)objectAnimator2).with((Animator)objectAnimator3).with((Animator)objectAnimator4);
                animatorSet.setDuration(200L).addListener((Animator.AnimatorListener)new 1(this));
                animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                animatorSet.start();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=11)
    private void animateExit() {
        if (this.mCurrentIndex != this.mEnterIndex) {
            this.finish();
            this.overridePendingTransition(0, R.anim.gmacs_anim_photo_exit);
            return;
        }
        this.mLayout.setBackgroundColor(0);
        Intent intent = this.getIntent();
        int n2 = intent.getIntExtra("width", 0);
        int n3 = intent.getIntExtra("height", 0);
        int n4 = intent.getIntExtra("x", 0);
        int n5 = intent.getIntExtra("y", 0);
        this.mImageViewPager.setLayerType(2, null);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this.mImageViewPager), (String)"scaleX", (float[])new float[]{(float)n2 * 1.0f / (float)this.bitmapVisibleWidth});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this.mImageViewPager), (String)"scaleY", (float[])new float[]{(float)n3 * 1.0f / (float)this.bitmapVisibleHeight});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)((Object)this.mImageViewPager), (String)"translationX", (float[])new float[]{-((GmacsEnvi.screenWidth - n2) / 2 - n4)});
        intent = Build.VERSION.SDK_INT >= 21 ? ObjectAnimator.ofFloat((Object)((Object)this.mImageViewPager), (String)"translationY", (float[])new float[]{-((GmacsEnvi.screenHeight - n3) / 2 - n5)}) : ObjectAnimator.ofFloat((Object)((Object)this.mImageViewPager), (String)"translationY", (float[])new float[]{n5 + (n3 - GmacsEnvi.screenHeight - GmacsEnvi.statusBarHeight) / 2});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)objectAnimator).with((Animator)objectAnimator2).with((Animator)objectAnimator3).with((Animator)intent);
        animatorSet.setDuration(200L).addListener(new Animator.AnimatorListener(){

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                GmacsImageActivity.this.mImageViewPager.setLayerType(0, null);
                GmacsImageActivity.this.finish();
            }

            public void onAnimationRepeat(Animator animator) {
            }

            public void onAnimationStart(Animator animator) {
            }
        });
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.start();
    }

    private boolean getIntentData() {
        Intent intent = this.getIntent();
        this.mImageInfoList = intent.getParcelableArrayListExtra("com.android.gmacs.msg.view.IMAGE_INFO");
        this.mEnterIndex = this.mCurrentIndex = intent.getIntExtra("com.android.gmacs.msg.view.IMAGE_INDEX", 0);
        return true;
    }

    private void initImageView() {
        this.mImageViewPager = (AlbumViewPager)this.findViewById(R.id.vp_content_image);
        this.mImageViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int n2) {
            }

            @Override
            public void onPageScrolled(int n2, float f2, int n3) {
            }

            @Override
            public void onPageSelected(int n2) {
                GmacsImageActivity.access$002(GmacsImageActivity.this, n2);
                if (GmacsImageActivity.this.mTitleBar.getVisibility() == 0) {
                    GmacsImageActivity.this.mTitleBar.setVisibility(8);
                }
            }
        });
        this.mImageViewPager.setAdapter(new ImageViewPagerAdapter(this.mImageInfoList));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveImageToLocal() {
        final String string2 = this.mImageInfoList.get((int)this.mCurrentIndex).mUrl;
        if (!string2.startsWith("/")) {
            RequestManager.getInstance().getNoL1CacheImageLoader().get(string2, new ImageLoader.ImageListener(){

                @Override
                public void onErrorResponse(VolleyError volleyError) {
                }

                @Override
                public void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl2) {
                    if (imageContainer.getBitmap() != null) {
                        ClientManager.post((Runnable)new 1(this, imageContainer));
                    }
                }
            }, GmacsEnvi.getGLMaxTextureSize(), GmacsEnvi.getGLMaxTextureSize(), ImageView.ScaleType.CENTER_INSIDE, 0, 0);
            return;
        }
        ToastUtil.showToast(this.getResources().getString(R.string.picture_already_saved, new Object[]{ClientManager.sAppName}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveImageToSdCard(Bitmap bitmap, String object) {
        boolean bl2 = false;
        if (bitmap == null) {
            return bl2;
        }
        Object object2 = StringUtil.MD5((String)object);
        boolean bl3 = bl2;
        try {
            if (!FileUtil.sdcardAvailable()) return bl3;
            Object object3 = new File(BitmapUtil.SAVE_IMAGE_FILE_DIR);
            if (!((File)object3).exists()) {
                ((File)object3).mkdirs();
            }
            StringBuilder stringBuilder = new StringBuilder();
            object = new File((File)object3, stringBuilder.append((String)object2).append(".jpg").toString());
            object3 = new FileOutputStream((File)object);
            object2 = new BufferedOutputStream((OutputStream)object3);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
            ((BufferedOutputStream)object2).flush();
            ((FilterOutputStream)object2).close();
            bitmap = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            bitmap.setData(Uri.fromFile((File)object));
            GmacsEnvi.appContext.sendBroadcast((Intent)bitmap);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return bl2;
        }
    }

    public void finish() {
        super.finish();
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
        }
    }

    @Override
    protected void initData() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissionOnNeed("android.permission.READ_EXTERNAL_STORAGE", 1);
        }
    }

    @Override
    protected void initView() {
        this.mLayout = (RelativeLayout)this.findViewById(R.id.activity_image_layout);
    }

    @Override
    public void onBackPressed() {
        this.animateExit();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.gmacs_activity_image);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(5380);
        }
        this.requestWindowNoTitle(true);
        if (!this.getIntentData()) {
            this.finish();
            return;
        }
        this.initImageView();
        if (this.mCurrentIndex == 0) return;
        this.mImageViewPager.setCurrentItem(this.mCurrentIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        if (n2 != 2) return;
        if (nArray[0] == 0) {
            this.saveImageToLocal();
            return;
        }
        ToastUtil.showToast("\u672a\u5f00\u653e\u5916\u7f6e\u5b58\u50a8\u6743\u9650\uff0c\u56fe\u7247\u4fdd\u5b58\u5931\u8d25");
    }

    private class ImageViewPagerAdapter
    extends PagerAdapter {
        private List<IMImageMsgView.ImageInfoWrapper> dataList = new ArrayList<IMImageMsgView.ImageInfoWrapper>();

        ImageViewPagerAdapter(List<IMImageMsgView.ImageInfoWrapper> list) {
            this.dataList = list;
        }

        private void unbindDrawables(View view) {
            if (view.getBackground() != null) {
                view.getBackground().setCallback(null);
            }
            if (view instanceof ViewGroup) {
                for (int i2 = 0; i2 < ((ViewGroup)view).getChildCount(); ++i2) {
                    this.unbindDrawables(((ViewGroup)view).getChildAt(i2));
                }
                ((ViewGroup)view).removeAllViews();
            }
        }

        @Override
        public void destroyItem(ViewGroup viewGroup, int n2, Object object) {
            ViewHolder viewHolder = (ViewHolder)((View)object).getTag();
            if (viewHolder.photoView != null) {
                ((ImageLoader.ImageContainer)viewHolder.photoView.getTag()).cancelRequest();
                viewHolder.photoView.setImageBitmap(null);
            }
            viewGroup.removeView((View)object);
            this.unbindDrawables((View)object);
        }

        @Override
        public int getCount() {
            return this.dataList.size();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object instantiateItem(ViewGroup viewGroup, int n2) {
            void var6_9;
            String string2;
            void var6_7;
            View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.gmacs_adapter_image_pager_item, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.photoView = (PhotoView)view.findViewById(R.id.imagePhotoView);
            view.setTag((Object)viewHolder);
            IMImageMsgView.ImageInfoWrapper imageInfoWrapper = this.dataList.get(n2);
            try {
                int[] nArray = ImageUtil.getScaleSize(imageInfoWrapper.mWidth, imageInfoWrapper.mHeight, IMImageMsgView.ImgResize, IMImageMsgView.ImgResize, IMImageMsgView.MinResize, IMImageMsgView.MinResize);
            }
            catch (Exception exception) {
                int[] nArray = new int[]{IMImageMsgView.ImgResize, IMImageMsgView.ImgResize, IMImageMsgView.ImgResize, IMImageMsgView.ImgResize};
            }
            void var7_14 = var6_7[0];
            void var8_15 = var6_7[1];
            void var9_16 = var6_7[2];
            void var10_17 = var6_7[3];
            if (imageInfoWrapper.mUrl.startsWith("/")) {
                string2 = imageInfoWrapper.mUrl;
                String string3 = imageInfoWrapper.mUrl;
            } else {
                string2 = imageInfoWrapper.mUrl;
                String string4 = ImageUtil.makeUpUrl(imageInfoWrapper.mUrl, (int)var10_17, (int)var9_16);
            }
            ImageLoader.ImageContainer imageContainer = RequestManager.getInstance().getNoL1CacheImageLoader().get(string2, (ImageLoader.ImageListener)new 1(this, (String)var6_9, n2, viewHolder, (int)var7_14, (int)var8_15), GmacsEnvi.getGLMaxTextureSize(), GmacsEnvi.getGLMaxTextureSize(), ImageView.ScaleType.CENTER_INSIDE, 0, 0);
            viewGroup.addView(view, -1, -1);
            viewHolder.photoView.setTag(imageContainer);
            viewHolder.photoView.setOnLongClickListener(GmacsImageActivity.this.mPhotoOnLongClickListener);
            viewHolder.photoView.setOnPhotoTapListener(GmacsImageActivity.this.mPhotoOnTapListener);
            viewHolder.photoView.setOnViewTapListener(GmacsImageActivity.this.mViewOnTapListener);
            return view;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isViewFromObject(View view, Object object) {
            if (view != object) return false;
            return true;
        }
    }

    private static final class ViewHolder {
        PhotoView photoView;

        private ViewHolder() {
        }
    }
}

