/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmacs.activity;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.android.gmacs.R;
import com.android.gmacs.dragback.ParallaxBackActivityHelper;
import com.android.gmacs.view.TitleBar;
import com.common.gmacs.core.ClientManager;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;
import com.ganji.android.comp.utils.l;

public abstract class BaseActivity
extends AppCompatActivity {
    protected String TAG = this.getClass().getSimpleName();
    protected FrameLayout mContentContainer;
    private ParallaxBackActivityHelper mHelper;
    private boolean mIsNoTitle;
    protected View mStatusBar;
    protected TitleBar mTitleBar;

    @Override
    @NonNull
    public View findViewById(int n2) {
        View view;
        View view2 = view = super.findViewById(n2);
        if (view == null) {
            view2 = view;
            if (this.mHelper != null) {
                view2 = this.mHelper.findViewById(n2);
            }
        }
        return view2;
    }

    protected void hideTitleBar() {
        if (this.mTitleBar != null) {
            this.mTitleBar.setVisibility(8);
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setVisibility(8);
        }
    }

    protected abstract void initData();

    protected abstract void initView();

    @Override
    public void onBackPressed() {
        if (!this.getSupportFragmentManager().popBackStackImmediate()) {
            this.scrollToFinishActivity();
        }
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mHelper = new ParallaxBackActivityHelper(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mHelper.onActivityDestroy();
    }

    @Override
    protected void onPostCreate(Bundle bundle) {
        super.onPostCreate(bundle);
        this.mHelper.onPostCreate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n2, stringArray, nArray);
        if (nArray.length == 0) {
            return;
        }
        if (nArray[0] != 0) return;
        this.updateData();
    }

    @Override
    protected void onResume() {
        super.onResume();
        ClientManager.setNetworkStatus(GmacsUtils.getNetworkStatus((Context)GmacsEnvi.appContext));
        if (l.a()) {
            l.a(this);
        }
        l.b(this.getWindow());
    }

    @TargetApi(value=21)
    protected void requestNotFitSystemWindow() {
        if (this.mContentContainer != null) {
            this.mContentContainer.setFitsSystemWindows(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void requestPermissionOnNeed(String string2, int n2) {
        try {
            ContextCompat.class.getMethod("checkSelfPermission", Context.class, String.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void requestWindowNoTitle(boolean bl2) {
        int n2;
        TitleBar titleBar;
        int n3 = 8;
        this.mIsNoTitle = bl2;
        if (this.mTitleBar != null) {
            titleBar = this.mTitleBar;
            n2 = bl2 ? 8 : 0;
            titleBar.setVisibility(n2);
        }
        if (this.mStatusBar != null) {
            titleBar = this.mStatusBar;
            n2 = bl2 ? n3 : 0;
            titleBar.setVisibility(n2);
        }
        if (bl2) {
            titleBar = (RelativeLayout.LayoutParams)this.mContentContainer.getLayoutParams();
            ((RelativeLayout.LayoutParams)titleBar).topMargin = 0;
            this.mContentContainer.setLayoutParams((ViewGroup.LayoutParams)titleBar);
            if (Build.VERSION.SDK_INT < 21) return;
            this.mContentContainer.setFitsSystemWindows(false);
            return;
        }
        titleBar = (RelativeLayout.LayoutParams)this.mContentContainer.getLayoutParams();
        ((RelativeLayout.LayoutParams)titleBar).topMargin = this.getResources().getDimensionPixelOffset(R.dimen.titlebar_height);
        this.mContentContainer.setLayoutParams((ViewGroup.LayoutParams)titleBar);
        if (Build.VERSION.SDK_INT < 21) return;
        this.mContentContainer.setFitsSystemWindows(true);
    }

    protected void resetContentContainerMargin() {
        if (this.mContentContainer != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mContentContainer.getLayoutParams();
            layoutParams.topMargin = 0;
            this.mContentContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void scrollToFinishActivity() {
        this.mHelper.scrollToFinishActivity();
    }

    public void setBackEnable(boolean bl2) {
        this.mHelper.setBackEnable(bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setContentView(int n2) {
        super.setContentView(R.layout.gmacs_window_base);
        this.mContentContainer = (FrameLayout)this.findViewById(R.id.content_container);
        this.getLayoutInflater().inflate(n2, (ViewGroup)this.mContentContainer);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
            this.mStatusBar = this.findViewById(R.id.status_bar_delegate);
            this.mStatusBar.setVisibility(8);
            if (GmacsEnvi.statusBarHeight != 0) {
                this.mStatusBar.getLayoutParams().height = GmacsEnvi.statusBarHeight;
            }
        }
        TitleBar titleBar = this.mTitleBar = (TitleBar)this.findViewById(R.id.layout_widget_title_bar);
        n2 = this.mIsNoTitle ? 8 : 0;
        titleBar.setVisibility(n2);
        this.setTitle(this.getTitle());
        this.mTitleBar.setBackListener(new View.OnClickListener(){

            public void onClick(View view) {
                BaseActivity.this.onBackPressed();
                ((InputMethodManager)BaseActivity.this.getSystemService("input_method")).hideSoftInputFromWindow(view.getApplicationWindowToken(), 0);
            }
        });
        this.initView();
        this.initData();
    }

    public void setTitle(CharSequence charSequence) {
        super.setTitle(charSequence);
        if (this.mTitleBar != null) {
            this.mTitleBar.setTitle(charSequence);
        }
    }

    protected void showTitleBar() {
        if (this.mTitleBar != null) {
            this.mTitleBar.setVisibility(0);
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.setVisibility(0);
        }
    }

    protected void updateData() {
    }
}

