/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatDrawableManager;
import java.lang.ref.WeakReference;

public class VectorEnabledTintResources
extends Resources {
    public static final int MAX_SDK_WHERE_REQUIRED = 20;
    private final WeakReference<Context> mContextRef;

    public VectorEnabledTintResources(@NonNull Context context, @NonNull Resources resources) {
        super(resources.getAssets(), resources.getDisplayMetrics(), resources.getConfiguration());
        this.mContextRef = new WeakReference<Context>(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldBeUsed() {
        if (!AppCompatDelegate.isCompatVectorFromResourcesEnabled()) return false;
        if (Build.VERSION.SDK_INT > 20) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getDrawable(int n2) throws Resources.NotFoundException {
        Context context = (Context)this.mContextRef.get();
        if (context == null) return super.getDrawable(n2);
        return AppCompatDrawableManager.get().onDrawableLoadedFromResources(context, this, n2);
    }

    final Drawable superGetDrawable(int n2) {
        return super.getDrawable(n2);
    }
}

