/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.support.v7.widget.ChildHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

class ChildHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "ChildrenHelper";
    final Bucket mBucket;
    final Callback mCallback;
    final List<View> mHiddenViews;

    ChildHelper(Callback callback) {
        this.mCallback = callback;
        this.mBucket = new /* Unavailable Anonymous Inner Class!! */;
        this.mHiddenViews = new ArrayList<View>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getOffset(int n2) {
        if (n2 < 0) {
            return -1;
        }
        int n3 = this.mCallback.getChildCount();
        int n4 = n2;
        while (n4 < n3) {
            int n5 = n2 - (n4 - this.mBucket.countOnesBefore(n4));
            if (n5 == 0) {
                while (true) {
                    n2 = ++n4;
                    if (!this.mBucket.get(n4)) return n2;
                }
            }
            n4 += n5;
        }
        return -1;
    }

    private void hideViewInternal(View view) {
        this.mHiddenViews.add(view);
        this.mCallback.onEnteredHiddenState(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unhideViewInternal(View view) {
        if (!this.mHiddenViews.remove(view)) return false;
        this.mCallback.onLeftHiddenState(view);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addView(View view, int n2, boolean bl2) {
        n2 = n2 < 0 ? this.mCallback.getChildCount() : this.getOffset(n2);
        this.mBucket.insert(n2, bl2);
        if (bl2) {
            this.hideViewInternal(view);
        }
        this.mCallback.addView(view, n2);
    }

    void addView(View view, boolean bl2) {
        this.addView(view, -1, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    void attachViewToParent(View view, int n2, ViewGroup.LayoutParams layoutParams, boolean bl2) {
        n2 = n2 < 0 ? this.mCallback.getChildCount() : this.getOffset(n2);
        this.mBucket.insert(n2, bl2);
        if (bl2) {
            this.hideViewInternal(view);
        }
        this.mCallback.attachViewToParent(view, n2, layoutParams);
    }

    void detachViewFromParent(int n2) {
        n2 = this.getOffset(n2);
        this.mBucket.remove(n2);
        this.mCallback.detachViewFromParent(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View findHiddenNonRemovedView(int n2, int n3) {
        int n4 = this.mHiddenViews.size();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.mHiddenViews.get(n5);
            RecyclerView.ViewHolder viewHolder = this.mCallback.getChildViewHolder(view);
            if (viewHolder.getLayoutPosition() == n2 && !viewHolder.isInvalid() && !viewHolder.isRemoved()) {
                View view2 = view;
                if (n3 == -1) return view2;
                if (viewHolder.getItemViewType() == n3) {
                    return view;
                }
            }
            ++n5;
        }
        return null;
    }

    View getChildAt(int n2) {
        n2 = this.getOffset(n2);
        return this.mCallback.getChildAt(n2);
    }

    int getChildCount() {
        return this.mCallback.getChildCount() - this.mHiddenViews.size();
    }

    View getUnfilteredChildAt(int n2) {
        return this.mCallback.getChildAt(n2);
    }

    int getUnfilteredChildCount() {
        return this.mCallback.getChildCount();
    }

    void hide(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
        this.mBucket.set(n2);
        this.hideViewInternal(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int indexOfChild(View view) {
        int n2 = -1;
        int n3 = this.mCallback.indexOfChild(view);
        if (n3 == -1) {
            return n2;
        }
        if (this.mBucket.get(n3)) return n2;
        return n3 - this.mBucket.countOnesBefore(n3);
    }

    boolean isHidden(View view) {
        return this.mHiddenViews.contains(view);
    }

    void removeAllViewsUnfiltered() {
        this.mBucket.reset();
        for (int i2 = this.mHiddenViews.size() - 1; i2 >= 0; --i2) {
            this.mCallback.onLeftHiddenState(this.mHiddenViews.get(i2));
            this.mHiddenViews.remove(i2);
        }
        this.mCallback.removeAllViews();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeView(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 < 0) {
            return;
        }
        if (this.mBucket.remove(n2)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeViewAt(int n2) {
        View view = this.mCallback.getChildAt(n2 = this.getOffset(n2));
        if (view == null) {
            return;
        }
        if (this.mBucket.remove(n2)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean removeViewIfHidden(View view) {
        boolean bl2 = true;
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 == -1) {
            if (!this.unhideViewInternal(view)) return bl2;
            return bl2;
        }
        if (!this.mBucket.get(n2)) return false;
        this.mBucket.remove(n2);
        if (!this.unhideViewInternal(view)) {
            // empty if block
        }
        this.mCallback.removeViewAt(n2);
        return bl2;
    }

    public String toString() {
        return this.mBucket.toString() + ", hidden list:" + this.mHiddenViews.size();
    }

    void unhide(View view) {
        int n2 = this.mCallback.indexOfChild(view);
        if (n2 < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
        if (!this.mBucket.get(n2)) {
            throw new RuntimeException("trying to unhide a view that was not hidden" + view);
        }
        this.mBucket.clear(n2);
        this.unhideViewInternal(view);
    }

    static interface Callback {
        public void addView(View var1, int var2);

        public void attachViewToParent(View var1, int var2, ViewGroup.LayoutParams var3);

        public void detachViewFromParent(int var1);

        public View getChildAt(int var1);

        public int getChildCount();

        public RecyclerView.ViewHolder getChildViewHolder(View var1);

        public int indexOfChild(View var1);

        public void onEnteredHiddenState(View var1);

        public void onLeftHiddenState(View var1);

        public void removeAllViews();

        public void removeViewAt(int var1);
    }
}

