/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

class TwilightCalculator {
    private static final float ALTIDUTE_CORRECTION_CIVIL_TWILIGHT = -0.10471976f;
    private static final float C1 = 0.0334196f;
    private static final float C2 = 3.49066E-4f;
    private static final float C3 = 5.236E-6f;
    public static final int DAY = 0;
    private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    private static final float J0 = 9.0E-4f;
    public static final int NIGHT = 1;
    private static final float OBLIQUITY = 0.4092797f;
    private static final long UTC_2000 = 946728000000L;
    private static TwilightCalculator sInstance;
    public int state;
    public long sunrise;
    public long sunset;

    TwilightCalculator() {
    }

    static TwilightCalculator getInstance() {
        if (sInstance == null) {
            sInstance = new TwilightCalculator();
        }
        return sInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calculateTwilight(long l2, double d2, double d3) {
        float f2 = (float)(l2 - 946728000000L) / 8.64E7f;
        float f3 = 6.24006f + 0.01720197f * f2;
        double d4 = (double)f3 + (double)0.0334196f * Math.sin(f3) + 3.4906598739326E-4 * Math.sin(2.0f * f3) + (double)5.236E-6f * Math.sin(3.0f * f3) + 1.796593063 + Math.PI;
        d3 = -d3 / 360.0;
        double d5 = (float)Math.round((double)(f2 - 9.0E-4f) - d3) + 9.0E-4f;
        d3 = Math.sin(f3) * 0.0053 + (d3 + d5) + -0.0069 * Math.sin(2.0 * d4);
        d4 = Math.asin(Math.sin(d4) * Math.sin(0.4092797040939331));
        double d6 = 0.01745329238474369 * d2;
        d5 = Math.sin(-0.10471975803375244);
        double d7 = Math.sin(d6);
        d2 = Math.sin(d4);
        d6 = Math.cos(d6);
        if ((d2 = (d5 - d7 * d2) / (Math.cos(d4) * d6)) >= 1.0) {
            this.state = 1;
            this.sunset = -1L;
            this.sunrise = -1L;
            return;
        }
        if (d2 <= -1.0) {
            this.state = 0;
            this.sunset = -1L;
            this.sunrise = -1L;
            return;
        }
        f3 = (float)(Math.acos(d2) / (Math.PI * 2));
        this.sunset = Math.round(((double)f3 + d3) * 8.64E7) + 946728000000L;
        this.sunrise = Math.round((d3 - (double)f3) * 8.64E7) + 946728000000L;
        if (this.sunrise < l2 && this.sunset > l2) {
            this.state = 0;
            return;
        }
        this.state = 1;
    }
}

