/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatAutoCompleteTextView;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.AppCompatImageButton;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatMultiAutoCompleteTextView;
import android.support.v7.widget.AppCompatRadioButton;
import android.support.v7.widget.AppCompatRatingBar;
import android.support.v7.widget.AppCompatSeekBar;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.TintContextWrapper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

class AppCompatViewInflater {
    private static final String LOG_TAG = "AppCompatViewInflater";
    private static final String[] sClassPrefixList;
    private static final Map<String, Constructor<? extends View>> sConstructorMap;
    private static final Class<?>[] sConstructorSignature;
    private static final int[] sOnClickAttrs;
    private final Object[] mConstructorArgs = new Object[2];

    static {
        sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
        sOnClickAttrs = new int[]{16843375};
        sClassPrefixList = new String[]{"android.widget.", "android.view.", "android.webkit."};
        sConstructorMap = new ArrayMap<String, Constructor<? extends View>>();
    }

    AppCompatViewInflater() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkOnClickListener(View view, AttributeSet object) {
        Context context = view.getContext();
        if (!(context instanceof ContextWrapper) || Build.VERSION.SDK_INT >= 15 && !ViewCompat.hasOnClickListeners(view)) {
            return;
        }
        String string2 = (context = context.obtainStyledAttributes(object, sOnClickAttrs)).getString(0);
        if (string2 != null) {
            view.setOnClickListener((View.OnClickListener)new DeclaredOnClickListener(view, string2));
        }
        context.recycle();
    }

    /*
     * Unable to fully structure code
     */
    private View createView(Context var1_1, String var2_3, String var3_4) throws ClassNotFoundException, InflateException {
        block5: {
            var4_5 = AppCompatViewInflater.sConstructorMap.get(var2_3);
            var5_6 = var4_5;
            if (var4_5 != null) ** GOTO lbl14
            var5_6 = var1_1.getClassLoader();
            if (var3_4 == null) break block5;
            try {
                var1_1 = new StringBuilder();
                var1_1 = var1_1.append(var3_4).append(var2_3).toString();
lbl10:
                // 2 sources

                while (true) {
                    var5_6 = var5_6.loadClass((String)var1_1).asSubclass(View.class).getConstructor(AppCompatViewInflater.sConstructorSignature);
                    AppCompatViewInflater.sConstructorMap.put(var2_3, var5_6);
lbl14:
                    // 2 sources

                    var5_6.setAccessible(true);
                    var1_1 = (View)var5_6.newInstance(this.mConstructorArgs);
lbl16:
                    // 2 sources

                    return var1_1;
                }
            }
            catch (Exception var1_2) {
                var1_1 = null;
                ** continue;
            }
        }
        var1_1 = var2_3;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View createViewFromTag(Context object, String string2, AttributeSet attributeSet) {
        void var1_3;
        String string3;
        block8: {
            void var3_10;
            View view;
            string3 = view;
            if (view.equals("view")) {
                string3 = var3_10.getAttributeValue(null, "class");
            }
            this.mConstructorArgs[0] = object;
            this.mConstructorArgs[1] = var3_10;
            if (-1 != string3.indexOf(46)) break block8;
            int n2 = 0;
            while (true) {
                block9: {
                    if (n2 >= sClassPrefixList.length) break;
                    view = this.createView((Context)object, string3, sClassPrefixList[n2]);
                    if (view == null) break block9;
                    this.mConstructorArgs[0] = null;
                    this.mConstructorArgs[1] = null;
                    View view2 = view;
                    return var1_3;
                }
                ++n2;
            }
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
            return var1_3;
        }
        try {
            View view = this.createView((Context)object, string3, null);
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
            return var1_3;
        }
        catch (Exception exception) {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
            return var1_3;
        }
        catch (Throwable throwable) {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Context themifyContext(Context context, AttributeSet attributeSet, boolean bl2, boolean bl3) {
        attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.View, 0, 0);
        int n2 = bl2 ? attributeSet.getResourceId(R.styleable.View_android_theme, 0) : 0;
        int n3 = n2;
        if (bl3) {
            n3 = n2;
            if (n2 == 0) {
                n3 = n2 = attributeSet.getResourceId(R.styleable.View_theme, 0);
                if (n2 != 0) {
                    Log.i((String)LOG_TAG, (String)"app:theme is now deprecated. Please move to using android:theme instead.");
                    n3 = n2;
                }
            }
        }
        attributeSet.recycle();
        attributeSet = context;
        if (n3 == 0) return attributeSet;
        if (!(context instanceof ContextThemeWrapper)) return new ContextThemeWrapper(context, n3);
        attributeSet = context;
        if (((ContextThemeWrapper)context).getThemeResId() == n3) return attributeSet;
        return new ContextThemeWrapper(context, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final View createView(View view, String string2, @NonNull Context context, @NonNull AttributeSet attributeSet, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Context context2;
        block37: {
            block36: {
                context2 = bl2 && view != null ? view.getContext() : context;
                if (bl3) break block36;
                view = context2;
                if (!bl4) break block37;
            }
            view = AppCompatViewInflater.themifyContext(context2, attributeSet, bl3, bl4);
        }
        context2 = view;
        if (bl5) {
            context2 = TintContextWrapper.wrap((Context)view);
        }
        view = null;
        int n2 = -1;
        switch (string2.hashCode()) {
            case -938935918: {
                if (!string2.equals("TextView")) break;
                n2 = 0;
                break;
            }
            case 1125864064: {
                if (!string2.equals("ImageView")) break;
                n2 = 1;
                break;
            }
            case 2001146706: {
                if (!string2.equals("Button")) break;
                n2 = 2;
                break;
            }
            case 1666676343: {
                if (!string2.equals("EditText")) break;
                n2 = 3;
                break;
            }
            case -339785223: {
                if (!string2.equals("Spinner")) break;
                n2 = 4;
                break;
            }
            case -937446323: {
                if (!string2.equals("ImageButton")) break;
                n2 = 5;
                break;
            }
            case 1601505219: {
                if (!string2.equals("CheckBox")) break;
                n2 = 6;
                break;
            }
            case 776382189: {
                if (!string2.equals("RadioButton")) break;
                n2 = 7;
                break;
            }
            case -1455429095: {
                if (!string2.equals("CheckedTextView")) break;
                n2 = 8;
                break;
            }
            case 1413872058: {
                if (!string2.equals("AutoCompleteTextView")) break;
                n2 = 9;
                break;
            }
            case -1346021293: {
                if (!string2.equals("MultiAutoCompleteTextView")) break;
                n2 = 10;
                break;
            }
            case -1946472170: {
                if (!string2.equals("RatingBar")) break;
                n2 = 11;
                break;
            }
            case -658531749: {
                if (!string2.equals("SeekBar")) break;
                n2 = 12;
                break;
            }
        }
        switch (n2) {
            case 0: {
                view = new AppCompatTextView(context2, attributeSet);
                break;
            }
            case 1: {
                view = new AppCompatImageView(context2, attributeSet);
                break;
            }
            case 2: {
                view = new AppCompatButton(context2, attributeSet);
                break;
            }
            case 3: {
                view = new AppCompatEditText(context2, attributeSet);
                break;
            }
            case 4: {
                view = new AppCompatSpinner(context2, attributeSet);
                break;
            }
            case 5: {
                view = new AppCompatImageButton(context2, attributeSet);
                break;
            }
            case 6: {
                view = new AppCompatCheckBox(context2, attributeSet);
                break;
            }
            case 7: {
                view = new AppCompatRadioButton(context2, attributeSet);
                break;
            }
            case 8: {
                view = new AppCompatCheckedTextView(context2, attributeSet);
                break;
            }
            case 9: {
                view = new AppCompatAutoCompleteTextView(context2, attributeSet);
                break;
            }
            case 10: {
                view = new AppCompatMultiAutoCompleteTextView(context2, attributeSet);
                break;
            }
            case 11: {
                view = new AppCompatRatingBar(context2, attributeSet);
                break;
            }
            case 12: {
                view = new AppCompatSeekBar(context2, attributeSet);
                break;
            }
        }
        if (view == null && context != context2) {
            view = this.createViewFromTag(context2, string2, attributeSet);
        }
        if (view != null) {
            this.checkOnClickListener(view, attributeSet);
        }
        return view;
    }

    private static class DeclaredOnClickListener
    implements View.OnClickListener {
        private final View mHostView;
        private final String mMethodName;
        private Context mResolvedContext;
        private Method mResolvedMethod;

        public DeclaredOnClickListener(@NonNull View view, @NonNull String string2) {
            this.mHostView = view;
            this.mMethodName = string2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        private void resolveMethod(@Nullable Context object, @NonNull String object2) {
            void var1_6;
            void var1_2;
            while (var1_2 != null) {
                block7: {
                    Method method;
                    if (var1_2.isRestricted() || (method = var1_2.getClass().getMethod(this.mMethodName, View.class)) == null) break block7;
                    try {
                        this.mResolvedMethod = method;
                        this.mResolvedContext = var1_2;
                        return;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (var1_2 instanceof ContextWrapper) {
                    Context context = ((ContextWrapper)var1_2).getBaseContext();
                    continue;
                }
                Object var1_4 = null;
            }
            int n2 = this.mHostView.getId();
            if (n2 == -1) {
                String string2 = "";
                throw new IllegalStateException("Could not find method " + this.mMethodName + "(View) in a parent or ancestor Context for android:onClick " + "attribute defined on view " + this.mHostView.getClass() + (String)var1_6);
            }
            String string3 = " with id '" + this.mHostView.getContext().getResources().getResourceEntryName(n2) + "'";
            throw new IllegalStateException("Could not find method " + this.mMethodName + "(View) in a parent or ancestor Context for android:onClick " + "attribute defined on view " + this.mHostView.getClass() + (String)var1_6);
        }

        public void onClick(@NonNull View view) {
            if (this.mResolvedMethod == null) {
                this.resolveMethod(this.mHostView.getContext(), this.mMethodName);
            }
            try {
                this.mResolvedMethod.invoke((Object)this.mResolvedContext, view);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Could not execute non-public method for android:onClick", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException("Could not execute method for android:onClick", invocationTargetException);
            }
        }
    }
}

