/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.util.Log;
import android.widget.TextView;
import java.lang.reflect.Field;

class TextViewCompatDonut {
    private static final int LINES = 1;
    private static final String LOG_TAG = "TextViewCompatDonut";
    private static Field sMaxModeField;
    private static boolean sMaxModeFieldFetched;
    private static Field sMaximumField;
    private static boolean sMaximumFieldFetched;
    private static Field sMinModeField;
    private static boolean sMinModeFieldFetched;
    private static Field sMinimumField;
    private static boolean sMinimumFieldFetched;

    TextViewCompatDonut() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getMaxLines(TextView textView) {
        if (!sMaxModeFieldFetched) {
            sMaxModeField = TextViewCompatDonut.retrieveField("mMaxMode");
            sMaxModeFieldFetched = true;
        }
        if (sMaxModeField == null) return -1;
        if (TextViewCompatDonut.retrieveIntFromField(sMaxModeField, textView) != 1) return -1;
        if (!sMaximumFieldFetched) {
            sMaximumField = TextViewCompatDonut.retrieveField("mMaximum");
            sMaximumFieldFetched = true;
        }
        if (sMaximumField == null) return -1;
        return TextViewCompatDonut.retrieveIntFromField(sMaximumField, textView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getMinLines(TextView textView) {
        if (!sMinModeFieldFetched) {
            sMinModeField = TextViewCompatDonut.retrieveField("mMinMode");
            sMinModeFieldFetched = true;
        }
        if (sMinModeField == null) return -1;
        if (TextViewCompatDonut.retrieveIntFromField(sMinModeField, textView) != 1) return -1;
        if (!sMinimumFieldFetched) {
            sMinimumField = TextViewCompatDonut.retrieveField("mMinimum");
            sMinimumFieldFetched = true;
        }
        if (sMinimumField == null) return -1;
        return TextViewCompatDonut.retrieveIntFromField(sMinimumField, textView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field retrieveField(String string2) {
        Field field;
        Field field2 = null;
        try {
            field2 = field = TextView.class.getDeclaredField(string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.e((String)LOG_TAG, (String)("Could not retrieve " + string2 + " field."));
            return field2;
        }
        field.setAccessible(true);
        return field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int retrieveIntFromField(Field field, TextView textView) {
        try {
            return field.getInt(textView);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.d((String)LOG_TAG, (String)("Could not retrieve value of " + field.getName() + " field."));
            return -1;
        }
    }

    static void setTextAppearance(TextView textView, int n2) {
        textView.setTextAppearance(textView.getContext(), n2);
    }
}

