/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.DrawerLayoutCompatApi21;
import android.support.v4.widget.DrawerLayoutImpl;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import java.util.ArrayList;
import java.util.List;

public class DrawerLayout
extends ViewGroup
implements DrawerLayoutImpl {
    private static final boolean ALLOW_EDGE_LOCK = false;
    private static final boolean CAN_HIDE_DESCENDANTS;
    private static final boolean CHILDREN_DISALLOW_INTERCEPT = true;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int DRAWER_ELEVATION = 10;
    static final DrawerLayoutCompatImpl IMPL;
    private static final int[] LAYOUT_ATTRS;
    public static final int LOCK_MODE_LOCKED_CLOSED = 1;
    public static final int LOCK_MODE_LOCKED_OPEN = 2;
    public static final int LOCK_MODE_UNDEFINED = 3;
    public static final int LOCK_MODE_UNLOCKED = 0;
    private static final int MIN_DRAWER_MARGIN = 64;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int PEEK_DELAY = 160;
    private static final boolean SET_DRAWER_SHADOW_FROM_ELEVATION;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_SETTLING = 2;
    private static final String TAG = "DrawerLayout";
    private static final float TOUCH_SLOP_SENSITIVITY = 1.0f;
    private final ChildAccessibilityDelegate mChildAccessibilityDelegate = new ChildAccessibilityDelegate();
    private boolean mChildrenCanceledTouch;
    private boolean mDisallowInterceptRequested;
    private boolean mDrawStatusBarBackground;
    private float mDrawerElevation;
    private int mDrawerState;
    private boolean mFirstLayout = true;
    private boolean mInLayout;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private Object mLastInsets;
    private final ViewDragCallback mLeftCallback;
    private final ViewDragHelper mLeftDragger;
    @Deprecated
    @Nullable
    private DrawerListener mListener;
    private List<DrawerListener> mListeners;
    private int mLockModeEnd = 3;
    private int mLockModeLeft = 3;
    private int mLockModeRight = 3;
    private int mLockModeStart = 3;
    private int mMinDrawerMargin;
    private final ArrayList<View> mNonDrawerViews;
    private final ViewDragCallback mRightCallback;
    private final ViewDragHelper mRightDragger;
    private int mScrimColor = -1728053248;
    private float mScrimOpacity;
    private Paint mScrimPaint = new Paint();
    private Drawable mShadowEnd = null;
    private Drawable mShadowLeft = null;
    private Drawable mShadowLeftResolved;
    private Drawable mShadowRight = null;
    private Drawable mShadowRightResolved;
    private Drawable mShadowStart = null;
    private Drawable mStatusBarBackground;
    private CharSequence mTitleLeft;
    private CharSequence mTitleRight;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2 = true;
        LAYOUT_ATTRS = new int[]{16842931};
        boolean bl3 = Build.VERSION.SDK_INT >= 19;
        CAN_HIDE_DESCENDANTS = bl3;
        bl3 = Build.VERSION.SDK_INT >= 21 ? bl2 : false;
        SET_DRAWER_SHADOW_FROM_ELEVATION = bl3;
        if (Build.VERSION.SDK_INT >= 21) {
            IMPL = new DrawerLayoutCompatImplApi21();
            return;
        }
        IMPL = new DrawerLayoutCompatImplBase();
    }

    public DrawerLayout(Context context) {
        this(context, null);
    }

    public DrawerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DrawerLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setDescendantFocusability(262144);
        float f2 = this.getResources().getDisplayMetrics().density;
        this.mMinDrawerMargin = (int)(64.0f * f2 + 0.5f);
        float f3 = 400.0f * f2;
        this.mLeftCallback = new ViewDragCallback(3);
        this.mRightCallback = new ViewDragCallback(5);
        this.mLeftDragger = ViewDragHelper.create(this, 1.0f, this.mLeftCallback);
        this.mLeftDragger.setEdgeTrackingEnabled(1);
        this.mLeftDragger.setMinVelocity(f3);
        this.mLeftCallback.setDragger(this.mLeftDragger);
        this.mRightDragger = ViewDragHelper.create(this, 1.0f, this.mRightCallback);
        this.mRightDragger.setEdgeTrackingEnabled(2);
        this.mRightDragger.setMinVelocity(f3);
        this.mRightCallback.setDragger(this.mRightDragger);
        this.setFocusableInTouchMode(true);
        ViewCompat.setImportantForAccessibility((View)this, 1);
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegate());
        ViewGroupCompat.setMotionEventSplittingEnabled(this, false);
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            IMPL.configureApplyInsets((View)this);
            this.mStatusBarBackground = IMPL.getDefaultStatusBarBackground(context);
        }
        this.mDrawerElevation = f2 * 10.0f;
        this.mNonDrawerViews = new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findVisibleDrawer() {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if (this.isDrawerView(view) && this.isDrawerVisible(view)) {
                return view;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String gravityToString(int n2) {
        if ((n2 & 3) == 3) {
            return "LEFT";
        }
        if ((n2 & 5) != 5) return Integer.toHexString(n2);
        return "RIGHT";
    }

    private static boolean hasOpaqueBackground(View view) {
        boolean bl2 = false;
        view = view.getBackground();
        boolean bl3 = bl2;
        if (view != null) {
            bl3 = bl2;
            if (view.getOpacity() == -1) {
                bl3 = true;
            }
        }
        return bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasPeekingDrawer() {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            if (((LayoutParams)this.getChildAt(n3).getLayoutParams()).isPeeking) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasVisibleDrawer() {
        if (this.findVisibleDrawer() == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean includeChildForAccessibility(View view) {
        if (ViewCompat.getImportantForAccessibility(view) == 4) return false;
        if (ViewCompat.getImportantForAccessibility(view) == 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mirror(Drawable drawable2, int n2) {
        if (drawable2 == null) return false;
        if (!DrawableCompat.isAutoMirrored(drawable2)) {
            return false;
        }
        DrawableCompat.setLayoutDirection(drawable2, n2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable resolveLeftShadow() {
        int n2 = ViewCompat.getLayoutDirection((View)this);
        if (n2 == 0) {
            if (this.mShadowStart == null) return this.mShadowLeft;
            this.mirror(this.mShadowStart, n2);
            return this.mShadowStart;
        }
        if (this.mShadowEnd == null) return this.mShadowLeft;
        this.mirror(this.mShadowEnd, n2);
        return this.mShadowEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable resolveRightShadow() {
        int n2 = ViewCompat.getLayoutDirection((View)this);
        if (n2 == 0) {
            if (this.mShadowEnd == null) return this.mShadowRight;
            this.mirror(this.mShadowEnd, n2);
            return this.mShadowEnd;
        }
        if (this.mShadowStart == null) return this.mShadowRight;
        this.mirror(this.mShadowStart, n2);
        return this.mShadowStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveShadowDrawables() {
        if (SET_DRAWER_SHADOW_FROM_ELEVATION) {
            return;
        }
        this.mShadowLeftResolved = this.resolveLeftShadow();
        this.mShadowRightResolved = this.resolveRightShadow();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateChildrenImportantForAccessibility(View view, boolean bl2) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view2 = this.getChildAt(n3);
            if (!bl2 && !this.isDrawerView(view2) || bl2 && view2 == view) {
                ViewCompat.setImportantForAccessibility(view2, 1);
            } else {
                ViewCompat.setImportantForAccessibility(view2, 4);
            }
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDrawerListener(@NonNull DrawerListener drawerListener) {
        if (drawerListener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<DrawerListener>();
        }
        this.mListeners.add(drawerListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        View view;
        int n4;
        int n5 = 0;
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        int n6 = this.getChildCount();
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            view = this.getChildAt(n4);
            if (this.isDrawerView(view)) {
                if (!this.isDrawerOpen(view)) continue;
                n7 = 1;
                view.addFocusables(arrayList, n2, n3);
                continue;
            }
            this.mNonDrawerViews.add(view);
        }
        if (n7 == 0) {
            n7 = this.mNonDrawerViews.size();
            for (n4 = n5; n4 < n7; ++n4) {
                view = this.mNonDrawerViews.get(n4);
                if (view.getVisibility() != 0) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        this.mNonDrawerViews.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n2, layoutParams);
        if (this.findOpenDrawer() != null || this.isDrawerView(view)) {
            ViewCompat.setImportantForAccessibility(view, 4);
        } else {
            ViewCompat.setImportantForAccessibility(view, 1);
        }
        if (!CAN_HIDE_DESCENDANTS) {
            ViewCompat.setAccessibilityDelegate(view, this.mChildAccessibilityDelegate);
        }
    }

    void cancelChildViewTouch() {
        if (!this.mChildrenCanceledTouch) {
            long l2 = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)3, (float)0.0f, (float)0.0f, (int)0);
            int n2 = this.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getChildAt(i2).dispatchTouchEvent(motionEvent);
            }
            motionEvent.recycle();
            this.mChildrenCanceledTouch = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkDrawerViewAbsoluteGravity(View view, int n2) {
        if ((this.getDrawerViewAbsoluteGravity(view) & n2) != n2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) return false;
        if (!super.checkLayoutParams(layoutParams)) return false;
        return true;
    }

    public void closeDrawer(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view == null) {
            throw new IllegalArgumentException("No drawer view found with gravity " + DrawerLayout.gravityToString(n2));
        }
        this.closeDrawer(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void closeDrawer(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
        }
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (this.mFirstLayout) {
            LayoutParams.access$002(layoutParams, 0.0f);
            LayoutParams.access$102(layoutParams, 0);
        } else {
            LayoutParams.access$176(layoutParams, 4);
            if (this.checkDrawerViewAbsoluteGravity(view, 3)) {
                this.mLeftDragger.smoothSlideViewTo(view, -view.getWidth(), view.getTop());
            } else {
                this.mRightDragger.smoothSlideViewTo(view, this.getWidth(), view.getTop());
            }
        }
        this.invalidate();
    }

    public void closeDrawers() {
        this.closeDrawers(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    void closeDrawers(boolean bl2) {
        int n2 = this.getChildCount();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = this.getChildAt(i2);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n4 = n3;
            if (this.isDrawerView(view)) {
                if (bl2 && !layoutParams.isPeeking) {
                    n4 = n3;
                } else {
                    n4 = view.getWidth();
                    n3 = this.checkDrawerViewAbsoluteGravity(view, 3) ? (n3 |= this.mLeftDragger.smoothSlideViewTo(view, -n4, view.getTop())) : (n3 |= this.mRightDragger.smoothSlideViewTo(view, this.getWidth(), view.getTop()));
                    LayoutParams.access$202(layoutParams, false);
                    n4 = n3;
                }
            }
            n3 = n4;
        }
        this.mLeftCallback.removeCallbacks();
        this.mRightCallback.removeCallbacks();
        if (n3 != 0) {
            this.invalidate();
        }
    }

    public void computeScroll() {
        int n2 = this.getChildCount();
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 = Math.max(f2, ((LayoutParams)this.getChildAt(i2).getLayoutParams()).onScreen);
        }
        this.mScrimOpacity = f2;
        if (this.mLeftDragger.continueSettling(true) | this.mRightDragger.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    void dispatchOnDrawerClosed(View view) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if ((layoutParams.openState & 1) == 1) {
            LayoutParams.access$102(layoutParams, 0);
            if (this.mListeners != null) {
                for (int i2 = this.mListeners.size() - 1; i2 >= 0; --i2) {
                    this.mListeners.get(i2).onDrawerClosed(view);
                }
            }
            this.updateChildrenImportantForAccessibility(view, false);
            if (this.hasWindowFocus() && (view = this.getRootView()) != null) {
                view.sendAccessibilityEvent(32);
            }
        }
    }

    void dispatchOnDrawerOpened(View view) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if ((layoutParams.openState & 1) == 0) {
            LayoutParams.access$102(layoutParams, 1);
            if (this.mListeners != null) {
                for (int i2 = this.mListeners.size() - 1; i2 >= 0; --i2) {
                    this.mListeners.get(i2).onDrawerOpened(view);
                }
            }
            this.updateChildrenImportantForAccessibility(view, true);
            if (this.hasWindowFocus()) {
                this.sendAccessibilityEvent(32);
            }
            view.requestFocus();
        }
    }

    void dispatchOnDrawerSlide(View view, float f2) {
        if (this.mListeners != null) {
            for (int i2 = this.mListeners.size() - 1; i2 >= 0; --i2) {
                this.mListeners.get(i2).onDrawerSlide(view, f2);
            }
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected boolean drawChild(Canvas canvas, View view, long l2) {
        int n2 = this.getHeight();
        boolean bl2 = this.isContentView(view);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getWidth();
        int n6 = canvas.save();
        int n7 = n5;
        boolean bl3 = true;
        while (true) {
            int n8;
            block10: {
                block13: {
                    block12: {
                        block6: {
                            block7: {
                                block8: {
                                    int n9;
                                    View view2;
                                    block11: {
                                        block9: {
                                            int n10;
                                            block5: {
                                                if (!bl3 || (bl3 = false)) break block5;
                                                if (!bl2) break block6;
                                                n10 = this.getChildCount();
                                                n8 = 0;
                                                n3 = n4;
                                            }
                                            if (n8 >= n10) break block7;
                                            view2 = this.getChildAt(n8);
                                            if (view2 == view || view2.getVisibility() != 0 || !DrawerLayout.hasOpaqueBackground(view2) || !this.isDrawerView(view2)) break block8;
                                            if (view2.getHeight() >= n2) break block9;
                                            n4 = n3;
                                            n7 = n5;
                                            break block10;
                                        }
                                        if (!this.checkDrawerViewAbsoluteGravity(view2, 3)) break block11;
                                        n7 = view2.getRight();
                                        if (n7 <= n3) break block12;
                                        break block13;
                                    }
                                    n7 = n9 = view2.getLeft();
                                    n4 = n3;
                                    if (n9 < n5) break block10;
                                }
                                n7 = n5;
                                n4 = n3;
                                break block10;
                            }
                            canvas.clipRect(n3, 0, n5, this.getHeight());
                            n7 = n5;
                        }
                        boolean bl4 = super.drawChild(canvas, view, l2);
                        canvas.restoreToCount(n6);
                        if (this.mScrimOpacity > 0.0f && bl2) {
                            n8 = (int)((float)((this.mScrimColor & 0xFF000000) >>> 24) * this.mScrimOpacity);
                            n5 = this.mScrimColor;
                            this.mScrimPaint.setColor(n8 << 24 | n5 & 0xFFFFFF);
                            canvas.drawRect((float)n3, 0.0f, (float)n7, (float)this.getHeight(), this.mScrimPaint);
                            return bl4;
                        }
                        if (this.mShadowLeftResolved != null && this.checkDrawerViewAbsoluteGravity(view, 3)) {
                            n5 = this.mShadowLeftResolved.getIntrinsicWidth();
                            n7 = view.getRight();
                            n3 = this.mLeftDragger.getEdgeSize();
                            float f2 = Math.max(0.0f, Math.min((float)n7 / (float)n3, 1.0f));
                            this.mShadowLeftResolved.setBounds(n7, view.getTop(), n5 + n7, view.getBottom());
                            this.mShadowLeftResolved.setAlpha((int)(255.0f * f2));
                            this.mShadowLeftResolved.draw(canvas);
                            return bl4;
                        }
                        if (this.mShadowRightResolved == null) return bl4;
                        if (!this.checkDrawerViewAbsoluteGravity(view, 5)) return bl4;
                        n8 = this.mShadowRightResolved.getIntrinsicWidth();
                        n5 = view.getLeft();
                        n3 = this.getWidth();
                        n7 = this.mRightDragger.getEdgeSize();
                        float f3 = Math.max(0.0f, Math.min((float)(n3 - n5) / (float)n7, 1.0f));
                        this.mShadowRightResolved.setBounds(n5 - n8, view.getTop(), n5, view.getBottom());
                        this.mShadowRightResolved.setAlpha((int)(255.0f * f3));
                        this.mShadowRightResolved.draw(canvas);
                        return bl4;
                    }
                    n7 = n3;
                }
                n4 = n7;
                n7 = n5;
            }
            ++n8;
            n5 = n7;
            n3 = n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View findDrawerWithGravity(int n2) {
        int n3 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this));
        int n4 = this.getChildCount();
        n2 = 0;
        while (n2 < n4) {
            View view = this.getChildAt(n2);
            if ((this.getDrawerViewAbsoluteGravity(view) & 7) == (n3 & 7)) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    View findOpenDrawer() {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if ((((LayoutParams)view.getLayoutParams()).openState & 1) == 1) {
                return view;
            }
            ++n3;
        }
        return null;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams object) {
        void var1_3;
        if (object instanceof LayoutParams) {
            LayoutParams layoutParams = new LayoutParams((LayoutParams)((Object)object));
            return var1_3;
        }
        if (object instanceof ViewGroup.MarginLayoutParams) {
            LayoutParams layoutParams = new LayoutParams((ViewGroup.MarginLayoutParams)object);
            return var1_3;
        }
        LayoutParams layoutParams = new LayoutParams((ViewGroup.LayoutParams)object);
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getDrawerElevation() {
        if (!SET_DRAWER_SHADOW_FROM_ELEVATION) return 0.0f;
        return this.mDrawerElevation;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getDrawerLockMode(int n2) {
        int n3 = ViewCompat.getLayoutDirection((View)this);
        switch (n2) {
            case 3: {
                if (this.mLockModeLeft != 3) {
                    return this.mLockModeLeft;
                }
                n2 = n3 == 0 ? this.mLockModeStart : this.mLockModeEnd;
                if (n2 == 3) return 0;
                return n2;
            }
            case 5: {
                if (this.mLockModeRight != 3) {
                    return this.mLockModeRight;
                }
                n2 = n3 == 0 ? this.mLockModeEnd : this.mLockModeStart;
                if (n2 == 3) return 0;
                return n2;
            }
            case 0x800003: {
                if (this.mLockModeStart != 3) {
                    return this.mLockModeStart;
                }
                n2 = n3 == 0 ? this.mLockModeLeft : this.mLockModeRight;
                if (n2 == 3) return 0;
                return n2;
            }
            default: {
                return 0;
            }
            case 0x800005: 
        }
        if (this.mLockModeEnd != 3) {
            return this.mLockModeEnd;
        }
        n2 = n3 == 0 ? this.mLockModeRight : this.mLockModeLeft;
        if (n2 == 3) return 0;
        return n2;
    }

    public int getDrawerLockMode(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer");
        }
        return this.getDrawerLockMode(((LayoutParams)view.getLayoutParams()).gravity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public CharSequence getDrawerTitle(int n2) {
        if ((n2 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this))) == 3) {
            return this.mTitleLeft;
        }
        if (n2 != 5) return null;
        return this.mTitleRight;
    }

    int getDrawerViewAbsoluteGravity(View view) {
        return GravityCompat.getAbsoluteGravity(((LayoutParams)view.getLayoutParams()).gravity, ViewCompat.getLayoutDirection((View)this));
    }

    float getDrawerViewOffset(View view) {
        return ((LayoutParams)view.getLayoutParams()).onScreen;
    }

    public Drawable getStatusBarBackgroundDrawable() {
        return this.mStatusBarBackground;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isContentView(View view) {
        if (((LayoutParams)view.getLayoutParams()).gravity != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDrawerOpen(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view == null) return false;
        return this.isDrawerOpen(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDrawerOpen(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer");
        }
        if ((((LayoutParams)view.getLayoutParams()).openState & 1) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isDrawerView(View view) {
        int n2 = GravityCompat.getAbsoluteGravity(((LayoutParams)view.getLayoutParams()).gravity, ViewCompat.getLayoutDirection(view));
        if ((n2 & 3) != 0) {
            return true;
        }
        if ((n2 & 5) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDrawerVisible(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view == null) return false;
        return this.isDrawerVisible(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDrawerVisible(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a drawer");
        }
        if (!(((LayoutParams)view.getLayoutParams()).onScreen > 0.0f)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveDrawerToOffset(View view, float f2) {
        float f3 = this.getDrawerViewOffset(view);
        int n2 = view.getWidth();
        int n3 = (int)(f3 * (float)n2);
        n2 = (int)((float)n2 * f2) - n3;
        if (!this.checkDrawerViewAbsoluteGravity(view, 3)) {
            n2 = -n2;
        }
        view.offsetLeftAndRight(n2);
        this.setDrawerViewOffset(view, f2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    public void onDraw(Canvas canvas) {
        int n2;
        super.onDraw(canvas);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null && (n2 = IMPL.getTopInset(this.mLastInsets)) > 0) {
            this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), n2);
            this.mStatusBarBackground.draw(canvas);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean bl2;
        boolean bl3;
        int n2;
        boolean bl4;
        block5: {
            bl4 = false;
            n2 = MotionEventCompat.getActionMasked(motionEvent);
            bl3 = this.mLeftDragger.shouldInterceptTouchEvent(motionEvent);
            bl2 = this.mRightDragger.shouldInterceptTouchEvent(motionEvent);
            switch (n2) {
                case 0: {
                    float f2 = motionEvent.getX();
                    float f3 = motionEvent.getY();
                    this.mInitialMotionX = f2;
                    this.mInitialMotionY = f3;
                    n2 = this.mScrimOpacity > 0.0f && (motionEvent = this.mLeftDragger.findTopChildUnder((int)f2, (int)f3)) != null && this.isContentView((View)motionEvent) ? 1 : 0;
                }
                case 2: {
                    if (!this.mLeftDragger.checkTouchSlop(3)) break;
                    this.mLeftCallback.removeCallbacks();
                    this.mRightCallback.removeCallbacks();
                    n2 = 0;
                    break block5;
                }
                case 1: 
                case 3: {
                    this.closeDrawers(true);
                    this.mDisallowInterceptRequested = false;
                    this.mChildrenCanceledTouch = false;
                }
            }
            n2 = 0;
            break block5;
            this.mDisallowInterceptRequested = false;
            this.mChildrenCanceledTouch = false;
        }
        if (bl3 | bl2) return true;
        if (n2 != 0) return true;
        if (this.hasPeekingDrawer()) return true;
        if (!this.mChildrenCanceledTouch) return bl4;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (n2 != 4) return super.onKeyDown(n2, keyEvent);
        if (!this.hasVisibleDrawer()) return super.onKeyDown(n2, keyEvent);
        KeyEventCompat.startTracking(keyEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        if (n2 != 4) return super.onKeyUp(n2, keyEvent);
        keyEvent = this.findVisibleDrawer();
        if (keyEvent != null && this.getDrawerLockMode((View)keyEvent) == 0) {
            this.closeDrawers();
        }
        if (keyEvent == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
        this.mInLayout = true;
        int n6 = n4 - n2;
        int n7 = this.getChildCount();
        n4 = 0;
        while (true) {
            if (n4 >= n7) {
                this.mInLayout = false;
                this.mFirstLayout = false;
                return;
            }
            View view = this.getChildAt(n4);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (this.isContentView(view)) {
                    view.layout(layoutParams.leftMargin, layoutParams.topMargin, layoutParams.leftMargin + view.getMeasuredWidth(), layoutParams.topMargin + view.getMeasuredHeight());
                } else {
                    float f2;
                    int n8;
                    int n9 = view.getMeasuredWidth();
                    int n10 = view.getMeasuredHeight();
                    if (this.checkDrawerViewAbsoluteGravity(view, 3)) {
                        n2 = -n9;
                        n8 = (int)((float)n9 * layoutParams.onScreen) + n2;
                        f2 = (float)(n9 + n8) / (float)n9;
                    } else {
                        n8 = n6 - (int)((float)n9 * layoutParams.onScreen);
                        f2 = (float)(n6 - n8) / (float)n9;
                    }
                    boolean bl3 = f2 != layoutParams.onScreen;
                    switch (layoutParams.gravity & 0x70) {
                        default: {
                            view.layout(n8, layoutParams.topMargin, n9 + n8, n10 + layoutParams.topMargin);
                            break;
                        }
                        case 80: {
                            n2 = n5 - n3;
                            view.layout(n8, n2 - layoutParams.bottomMargin - view.getMeasuredHeight(), n9 + n8, n2 - layoutParams.bottomMargin);
                            break;
                        }
                        case 16: {
                            int n11 = n5 - n3;
                            int n12 = (n11 - n10) / 2;
                            if (n12 < layoutParams.topMargin) {
                                n2 = layoutParams.topMargin;
                            } else {
                                n2 = n12;
                                if (n12 + n10 > n11 - layoutParams.bottomMargin) {
                                    n2 = n11 - layoutParams.bottomMargin - n10;
                                }
                            }
                            view.layout(n8, n2, n9 + n8, n10 + n2);
                        }
                    }
                    if (bl3) {
                        this.setDrawerViewOffset(view, f2);
                    }
                    n2 = layoutParams.onScreen > 0.0f ? 0 : 4;
                    if (view.getVisibility() != n2) {
                        view.setVisibility(n2);
                    }
                }
            }
            ++n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        block15: {
            block13: {
                block22: {
                    block24: {
                        block23: {
                            block21: {
                                block20: {
                                    block19: {
                                        block12: {
                                            block11: {
                                                block16: {
                                                    block18: {
                                                        block17: {
                                                            block14: {
                                                                var3_3 = View.MeasureSpec.getMode((int)var1_1);
                                                                var4_4 = View.MeasureSpec.getMode((int)var2_2);
                                                                var5_5 = View.MeasureSpec.getSize((int)var1_1);
                                                                var6_6 = View.MeasureSpec.getSize((int)var2_2);
                                                                if (var3_3 != 0x40000000) break block14;
                                                                var7_7 = var5_5;
                                                                if (var4_4 == 0x40000000) break block15;
                                                            }
                                                            if (!this.isInEditMode()) break block16;
                                                            if (var3_3 != -2147483648) break block17;
lbl11:
                                                            // 3 sources

                                                            while (var4_4 == -2147483648) {
                                                                var7_7 = var5_5;
                                                                var5_5 = var6_6;
lbl14:
                                                                // 3 sources

                                                                while (true) {
                                                                    this.setMeasuredDimension(var7_7, var5_5);
                                                                    if (this.mLastInsets == null || !ViewCompat.getFitsSystemWindows((View)this)) break block11;
                                                                    var3_3 = 1;
lbl18:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var8_8 = ViewCompat.getLayoutDirection((View)this);
                                                                        var6_6 = 0;
                                                                        var4_4 = 0;
                                                                        var9_9 = this.getChildCount();
                                                                        block3: for (var10_10 = 0; var10_10 < var9_9; ++var10_10) {
                                                                            var11_11 = this.getChildAt(var10_10);
                                                                            if (var11_11.getVisibility() == 8) lbl-1000:
                                                                            // 3 sources

                                                                            {
                                                                                continue block3;
                                                                            }
                                                                            break block12;
                                                                        }
                                                                        break block13;
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                            }
                                                            break block18;
                                                        }
                                                        if (var3_3 != 0) ** GOTO lbl11
                                                        var5_5 = 300;
                                                        ** GOTO lbl11
                                                    }
                                                    var7_7 = var5_5;
                                                    if (var4_4 != 0) break block15;
                                                    var7_7 = var5_5;
                                                    var5_5 = 300;
                                                    ** GOTO lbl14
                                                }
                                                throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
                                            }
                                            var3_3 = 0;
                                            ** while (true)
                                        }
                                        var12_12 = (LayoutParams)var11_11.getLayoutParams();
                                        if (var3_3 == 0) break block19;
                                        var13_13 = GravityCompat.getAbsoluteGravity(var12_12.gravity, var8_8);
                                        if (!ViewCompat.getFitsSystemWindows(var11_11)) break block20;
                                        DrawerLayout.IMPL.dispatchChildInsets(var11_11, this.mLastInsets, var13_13);
                                    }
lbl53:
                                    // 2 sources

                                    while (this.isContentView(var11_11)) {
                                        var11_11.measure(View.MeasureSpec.makeMeasureSpec((int)(var7_7 - var12_12.leftMargin - var12_12.rightMargin), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(var5_5 - var12_12.topMargin - var12_12.bottomMargin), (int)0x40000000));
                                        ** GOTO lbl-1000
                                    }
                                    break block21;
                                }
                                DrawerLayout.IMPL.applyMarginInsets(var12_12, this.mLastInsets, var13_13);
                                ** GOTO lbl53
                            }
                            if (!this.isDrawerView(var11_11)) break block22;
                            if (DrawerLayout.SET_DRAWER_SHADOW_FROM_ELEVATION && ViewCompat.getElevation(var11_11) != this.mDrawerElevation) {
                                ViewCompat.setElevation(var11_11, this.mDrawerElevation);
                            }
                            if ((var14_14 = this.getDrawerViewAbsoluteGravity(var11_11) & 7) != 3) break block23;
                            var13_13 = 1;
lbl66:
                            // 2 sources

                            while (var13_13 != 0 && var6_6 != 0 || var13_13 == 0 && var4_4 != 0) {
                                throw new IllegalStateException("Child drawer has absolute gravity " + DrawerLayout.gravityToString(var14_14) + " but this " + "DrawerLayout" + " already has a " + "drawer view along that edge");
                            }
                            break block24;
                        }
                        var13_13 = 0;
                        ** GOTO lbl66
                    }
                    if (var13_13 != 0) {
                        var6_6 = 1;
lbl75:
                        // 2 sources

                        while (true) {
                            var11_11.measure(DrawerLayout.getChildMeasureSpec((int)var1_1, (int)(this.mMinDrawerMargin + var12_12.leftMargin + var12_12.rightMargin), (int)var12_12.width), DrawerLayout.getChildMeasureSpec((int)var2_2, (int)(var12_12.topMargin + var12_12.bottomMargin), (int)var12_12.height));
                            ** continue;
                            break;
                        }
                    }
                    var4_4 = 1;
                    ** while (true)
                }
                throw new IllegalStateException("Child " + var11_11 + " at index " + var10_10 + " does not have a valid layout_gravity - must be Gravity.LEFT, " + "Gravity.RIGHT or Gravity.NO_GRAVITY");
            }
            return;
        }
        var5_5 = var6_6;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRestoreInstanceState(Parcelable object) {
        View view;
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        SavedState savedState = (SavedState)((Object)object);
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.openDrawerGravity != 0 && (view = this.findDrawerWithGravity(savedState.openDrawerGravity)) != null) {
            this.openDrawer(view);
        }
        if (savedState.lockModeLeft != 3) {
            this.setDrawerLockMode(savedState.lockModeLeft, 3);
        }
        if (savedState.lockModeRight != 3) {
            this.setDrawerLockMode(savedState.lockModeRight, 5);
        }
        if (savedState.lockModeStart != 3) {
            this.setDrawerLockMode(savedState.lockModeStart, 0x800003);
        }
        if (savedState.lockModeEnd == 3) return;
        this.setDrawerLockMode(savedState.lockModeEnd, 0x800005);
    }

    public void onRtlPropertiesChanged(int n2) {
        this.resolveShadowDrawables();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(i2).getLayoutParams();
            boolean bl2 = layoutParams.openState == 1;
            boolean bl3 = layoutParams.openState == 2;
            if (!bl2 && !bl3) continue;
            savedState.openDrawerGravity = layoutParams.gravity;
            break;
        }
        savedState.lockModeLeft = this.mLockModeLeft;
        savedState.lockModeRight = this.mLockModeRight;
        savedState.lockModeStart = this.mLockModeStart;
        savedState.lockModeEnd = this.mLockModeEnd;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        block5: {
            boolean bl2;
            block6: {
                this.mLeftDragger.processTouchEvent(motionEvent);
                this.mRightDragger.processTouchEvent(motionEvent);
                switch (motionEvent.getAction() & 0xFF) {
                    case 0: {
                        float f2 = motionEvent.getX();
                        float f3 = motionEvent.getY();
                        this.mInitialMotionX = f2;
                        this.mInitialMotionY = f3;
                        this.mDisallowInterceptRequested = false;
                        this.mChildrenCanceledTouch = false;
                        break block5;
                    }
                    case 1: {
                        int n2;
                        float f4 = motionEvent.getX();
                        float f5 = motionEvent.getY();
                        motionEvent = this.mLeftDragger.findTopChildUnder((int)f4, (int)f5);
                        if (motionEvent == null || !this.isContentView((View)motionEvent) || !((f4 -= this.mInitialMotionX) * f4 + (f5 -= this.mInitialMotionY) * f5 < (float)((n2 = this.mLeftDragger.getTouchSlop()) * n2)) || (motionEvent = this.findOpenDrawer()) == null) break;
                        bl2 = this.getDrawerLockMode((View)motionEvent) == 2;
                        break block6;
                    }
                    case 3: {
                        this.closeDrawers(true);
                        this.mDisallowInterceptRequested = false;
                        this.mChildrenCanceledTouch = false;
                        break block5;
                    }
                }
                bl2 = true;
            }
            this.closeDrawers(bl2);
            this.mDisallowInterceptRequested = false;
        }
        return true;
    }

    public void openDrawer(int n2) {
        View view = this.findDrawerWithGravity(n2);
        if (view == null) {
            throw new IllegalArgumentException("No drawer view found with gravity " + DrawerLayout.gravityToString(n2));
        }
        this.openDrawer(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void openDrawer(View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
        }
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (this.mFirstLayout) {
            LayoutParams.access$002(layoutParams, 1.0f);
            LayoutParams.access$102(layoutParams, 1);
            this.updateChildrenImportantForAccessibility(view, true);
        } else {
            LayoutParams.access$176(layoutParams, 2);
            if (this.checkDrawerViewAbsoluteGravity(view, 3)) {
                this.mLeftDragger.smoothSlideViewTo(view, 0, view.getTop());
            } else {
                this.mRightDragger.smoothSlideViewTo(view, this.getWidth() - view.getWidth(), view.getTop());
            }
        }
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeDrawerListener(@NonNull DrawerListener drawerListener) {
        if (drawerListener == null) {
            return;
        }
        if (this.mListeners == null) return;
        this.mListeners.remove(drawerListener);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl2) {
        super.requestDisallowInterceptTouchEvent(bl2);
        this.mDisallowInterceptRequested = bl2;
        if (bl2) {
            this.closeDrawers(true);
        }
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setChildInsets(Object object, boolean bl2) {
        this.mLastInsets = object;
        this.mDrawStatusBarBackground = bl2;
        bl2 = !bl2 && this.getBackground() == null;
        this.setWillNotDraw(bl2);
        this.requestLayout();
    }

    public void setDrawerElevation(float f2) {
        this.mDrawerElevation = f2;
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            View view = this.getChildAt(i2);
            if (!this.isDrawerView(view)) continue;
            ViewCompat.setElevation(view, this.mDrawerElevation);
        }
    }

    @Deprecated
    public void setDrawerListener(DrawerListener drawerListener) {
        if (this.mListener != null) {
            this.removeDrawerListener(this.mListener);
        }
        if (drawerListener != null) {
            this.addDrawerListener(drawerListener);
        }
        this.mListener = drawerListener;
    }

    public void setDrawerLockMode(int n2) {
        this.setDrawerLockMode(n2, 3);
        this.setDrawerLockMode(n2, 5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerLockMode(int n2, int n3) {
        ViewDragHelper viewDragHelper;
        int n4 = GravityCompat.getAbsoluteGravity(n3, ViewCompat.getLayoutDirection((View)this));
        switch (n3) {
            case 3: {
                this.mLockModeLeft = n2;
                break;
            }
            case 5: {
                this.mLockModeRight = n2;
                break;
            }
            case 0x800003: {
                this.mLockModeStart = n2;
                break;
            }
            case 0x800005: {
                this.mLockModeEnd = n2;
            }
        }
        if (n2 != 0) {
            viewDragHelper = n4 == 3 ? this.mLeftDragger : this.mRightDragger;
            viewDragHelper.cancel();
        }
        switch (n2) {
            case 2: {
                viewDragHelper = this.findDrawerWithGravity(n4);
                if (viewDragHelper == null) return;
                this.openDrawer((View)viewDragHelper);
            }
            default: {
                return;
            }
            case 1: 
        }
        viewDragHelper = this.findDrawerWithGravity(n4);
        if (viewDragHelper == null) return;
        this.closeDrawer((View)viewDragHelper);
    }

    public void setDrawerLockMode(int n2, View view) {
        if (!this.isDrawerView(view)) {
            throw new IllegalArgumentException("View " + view + " is not a " + "drawer with appropriate layout_gravity");
        }
        this.setDrawerLockMode(n2, ((LayoutParams)view.getLayoutParams()).gravity);
    }

    public void setDrawerShadow(@DrawableRes int n2, int n3) {
        this.setDrawerShadow(this.getResources().getDrawable(n2), n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerShadow(Drawable drawable2, int n2) {
        if (SET_DRAWER_SHADOW_FROM_ELEVATION) {
            return;
        }
        if ((n2 & 0x800003) == 0x800003) {
            this.mShadowStart = drawable2;
        } else if ((n2 & 0x800005) == 0x800005) {
            this.mShadowEnd = drawable2;
        } else if ((n2 & 3) == 3) {
            this.mShadowLeft = drawable2;
        } else {
            if ((n2 & 5) != 5) return;
            this.mShadowRight = drawable2;
        }
        this.resolveShadowDrawables();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerTitle(int n2, CharSequence charSequence) {
        if ((n2 = GravityCompat.getAbsoluteGravity(n2, ViewCompat.getLayoutDirection((View)this))) == 3) {
            this.mTitleLeft = charSequence;
            return;
        }
        if (n2 != 5) return;
        this.mTitleRight = charSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setDrawerViewOffset(View view, float f2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (f2 == layoutParams.onScreen) {
            return;
        }
        LayoutParams.access$002(layoutParams, f2);
        this.dispatchOnDrawerSlide(view, f2);
    }

    public void setScrimColor(@ColorInt int n2) {
        this.mScrimColor = n2;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStatusBarBackground(int n2) {
        Drawable drawable2 = n2 != 0 ? ContextCompat.getDrawable(this.getContext(), n2) : null;
        this.mStatusBarBackground = drawable2;
        this.invalidate();
    }

    public void setStatusBarBackground(Drawable drawable2) {
        this.mStatusBarBackground = drawable2;
        this.invalidate();
    }

    public void setStatusBarBackgroundColor(@ColorInt int n2) {
        this.mStatusBarBackground = new ColorDrawable(n2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateDrawerState(int n2, int n3, View view) {
        n2 = this.mLeftDragger.getViewDragState();
        int n4 = this.mRightDragger.getViewDragState();
        n2 = n2 == 1 || n4 == 1 ? 1 : (n2 == 2 || n4 == 2 ? 2 : 0);
        if (view != null && n3 == 0) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.onScreen == 0.0f) {
                this.dispatchOnDrawerClosed(view);
            } else if (layoutParams.onScreen == 1.0f) {
                this.dispatchOnDrawerOpened(view);
            }
        }
        if (n2 != this.mDrawerState) {
            this.mDrawerState = n2;
            if (this.mListeners != null) {
                for (n3 = this.mListeners.size() - 1; n3 >= 0; --n3) {
                    this.mListeners.get(n3).onDrawerStateChanged(n2);
                }
            }
        }
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        private void addChildrenForAccessibility(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat, ViewGroup viewGroup) {
            int n2 = viewGroup.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = viewGroup.getChildAt(i2);
                if (!DrawerLayout.includeChildForAccessibility(view)) continue;
                accessibilityNodeInfoCompat.addChild(view);
            }
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2) {
            Rect rect = this.mTmpRect;
            accessibilityNodeInfoCompat2.getBoundsInParent(rect);
            accessibilityNodeInfoCompat.setBoundsInParent(rect);
            accessibilityNodeInfoCompat2.getBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setBoundsInScreen(rect);
            accessibilityNodeInfoCompat.setVisibleToUser(accessibilityNodeInfoCompat2.isVisibleToUser());
            accessibilityNodeInfoCompat.setPackageName(accessibilityNodeInfoCompat2.getPackageName());
            accessibilityNodeInfoCompat.setClassName(accessibilityNodeInfoCompat2.getClassName());
            accessibilityNodeInfoCompat.setContentDescription(accessibilityNodeInfoCompat2.getContentDescription());
            accessibilityNodeInfoCompat.setEnabled(accessibilityNodeInfoCompat2.isEnabled());
            accessibilityNodeInfoCompat.setClickable(accessibilityNodeInfoCompat2.isClickable());
            accessibilityNodeInfoCompat.setFocusable(accessibilityNodeInfoCompat2.isFocusable());
            accessibilityNodeInfoCompat.setFocused(accessibilityNodeInfoCompat2.isFocused());
            accessibilityNodeInfoCompat.setAccessibilityFocused(accessibilityNodeInfoCompat2.isAccessibilityFocused());
            accessibilityNodeInfoCompat.setSelected(accessibilityNodeInfoCompat2.isSelected());
            accessibilityNodeInfoCompat.setLongClickable(accessibilityNodeInfoCompat2.isLongClickable());
            accessibilityNodeInfoCompat.addAction(accessibilityNodeInfoCompat2.getActions());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchPopulateAccessibilityEvent(View object, AccessibilityEvent object2) {
            if (object2.getEventType() != 32) return super.dispatchPopulateAccessibilityEvent((View)object, (AccessibilityEvent)object2);
            object = object2.getText();
            View view = DrawerLayout.this.findVisibleDrawer();
            if (view == null) return true;
            int n2 = DrawerLayout.this.getDrawerViewAbsoluteGravity(view);
            CharSequence charSequence = DrawerLayout.this.getDrawerTitle(n2);
            if (charSequence == null) return true;
            object.add(charSequence);
            return true;
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)DrawerLayout.class.getName());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            if (CAN_HIDE_DESCENDANTS) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            } else {
                AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = AccessibilityNodeInfoCompat.obtain(accessibilityNodeInfoCompat);
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat2);
                accessibilityNodeInfoCompat.setSource(view);
                ViewParent viewParent = ViewCompat.getParentForAccessibility(view);
                if (viewParent instanceof View) {
                    accessibilityNodeInfoCompat.setParent((View)viewParent);
                }
                this.copyNodeInfoNoChildren(accessibilityNodeInfoCompat, accessibilityNodeInfoCompat2);
                accessibilityNodeInfoCompat2.recycle();
                this.addChildrenForAccessibility(accessibilityNodeInfoCompat, (ViewGroup)view);
            }
            accessibilityNodeInfoCompat.setClassName(DrawerLayout.class.getName());
            accessibilityNodeInfoCompat.setFocusable(false);
            accessibilityNodeInfoCompat.setFocused(false);
            accessibilityNodeInfoCompat.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_FOCUS);
            accessibilityNodeInfoCompat.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLEAR_FOCUS);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            if (CAN_HIDE_DESCENDANTS) return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
            if (!DrawerLayout.includeChildForAccessibility(view)) return false;
            return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
        }
    }

    final class ChildAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        ChildAccessibilityDelegate() {
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            if (!DrawerLayout.includeChildForAccessibility(view)) {
                accessibilityNodeInfoCompat.setParent(null);
            }
        }
    }

    static interface DrawerLayoutCompatImpl {
        public void applyMarginInsets(ViewGroup.MarginLayoutParams var1, Object var2, int var3);

        public void configureApplyInsets(View var1);

        public void dispatchChildInsets(View var1, Object var2, int var3);

        public Drawable getDefaultStatusBarBackground(Context var1);

        public int getTopInset(Object var1);
    }

    static class DrawerLayoutCompatImplApi21
    implements DrawerLayoutCompatImpl {
        DrawerLayoutCompatImplApi21() {
        }

        @Override
        public void applyMarginInsets(ViewGroup.MarginLayoutParams marginLayoutParams, Object object, int n2) {
            DrawerLayoutCompatApi21.applyMarginInsets(marginLayoutParams, object, n2);
        }

        @Override
        public void configureApplyInsets(View view) {
            DrawerLayoutCompatApi21.configureApplyInsets(view);
        }

        @Override
        public void dispatchChildInsets(View view, Object object, int n2) {
            DrawerLayoutCompatApi21.dispatchChildInsets(view, object, n2);
        }

        @Override
        public Drawable getDefaultStatusBarBackground(Context context) {
            return DrawerLayoutCompatApi21.getDefaultStatusBarBackground(context);
        }

        @Override
        public int getTopInset(Object object) {
            return DrawerLayoutCompatApi21.getTopInset(object);
        }
    }

    static class DrawerLayoutCompatImplBase
    implements DrawerLayoutCompatImpl {
        DrawerLayoutCompatImplBase() {
        }

        @Override
        public void applyMarginInsets(ViewGroup.MarginLayoutParams marginLayoutParams, Object object, int n2) {
        }

        @Override
        public void configureApplyInsets(View view) {
        }

        @Override
        public void dispatchChildInsets(View view, Object object, int n2) {
        }

        @Override
        public Drawable getDefaultStatusBarBackground(Context context) {
            return null;
        }

        @Override
        public int getTopInset(Object object) {
            return 0;
        }
    }

    public static interface DrawerListener {
        public void onDrawerClosed(View var1);

        public void onDrawerOpened(View var1);

        public void onDrawerSlide(View var1, float var2);

        public void onDrawerStateChanged(int var1);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int FLAG_IS_CLOSING = 4;
        private static final int FLAG_IS_OPENED = 1;
        private static final int FLAG_IS_OPENING = 2;
        public int gravity = 0;
        private boolean isPeeking;
        private float onScreen;
        private int openState;

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(int n2, int n3, int n4) {
            this(n2, n3);
            this.gravity = n4;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = context.getInt(0, 0);
            context.recycle();
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.gravity = layoutParams.gravity;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        static /* synthetic */ float access$002(LayoutParams layoutParams, float f2) {
            layoutParams.onScreen = f2;
            return f2;
        }

        static /* synthetic */ int access$102(LayoutParams layoutParams, int n2) {
            layoutParams.openState = n2;
            return n2;
        }

        static /* synthetic */ int access$176(LayoutParams layoutParams, int n2) {
            layoutParams.openState = n2 = layoutParams.openState | n2;
            return n2;
        }

        static /* synthetic */ boolean access$202(LayoutParams layoutParams, boolean bl2) {
            layoutParams.isPeeking = bl2;
            return bl2;
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        };
        int lockModeEnd;
        int lockModeLeft;
        int lockModeRight;
        int lockModeStart;
        int openDrawerGravity = 0;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.openDrawerGravity = parcel.readInt();
            this.lockModeLeft = parcel.readInt();
            this.lockModeRight = parcel.readInt();
            this.lockModeStart = parcel.readInt();
            this.lockModeEnd = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n2) {
            super.writeToParcel(parcel, n2);
            parcel.writeInt(this.openDrawerGravity);
            parcel.writeInt(this.lockModeLeft);
            parcel.writeInt(this.lockModeRight);
            parcel.writeInt(this.lockModeStart);
            parcel.writeInt(this.lockModeEnd);
        }
    }

    public static abstract class SimpleDrawerListener
    implements DrawerListener {
        @Override
        public void onDrawerClosed(View view) {
        }

        @Override
        public void onDrawerOpened(View view) {
        }

        @Override
        public void onDrawerSlide(View view, float f2) {
        }

        @Override
        public void onDrawerStateChanged(int n2) {
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private final int mAbsGravity;
        private ViewDragHelper mDragger;
        private final Runnable mPeekRunnable = new Runnable(){

            @Override
            public void run() {
                ViewDragCallback.this.peekDrawer();
            }
        };

        public ViewDragCallback(int n2) {
            this.mAbsGravity = n2;
        }

        private void closeOtherDrawer() {
            View view;
            int n2 = 3;
            if (this.mAbsGravity == 3) {
                n2 = 5;
            }
            if ((view = DrawerLayout.this.findDrawerWithGravity(n2)) != null) {
                DrawerLayout.this.closeDrawer(view);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void peekDrawer() {
            View view;
            int n2 = 0;
            int n3 = this.mDragger.getEdgeSize();
            boolean bl2 = this.mAbsGravity == 3;
            if (bl2) {
                view = DrawerLayout.this.findDrawerWithGravity(3);
                if (view != null) {
                    n2 = -view.getWidth();
                }
                n2 += n3;
            } else {
                view = DrawerLayout.this.findDrawerWithGravity(5);
                n2 = DrawerLayout.this.getWidth();
                n2 -= n3;
            }
            if (view != null && (bl2 && view.getLeft() < n2 || !bl2 && view.getLeft() > n2) && DrawerLayout.this.getDrawerLockMode(view) == 0) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                this.mDragger.smoothSlideViewTo(view, n2, view.getTop());
                LayoutParams.access$202(layoutParams, true);
                DrawerLayout.this.invalidate();
                this.closeOtherDrawer();
                DrawerLayout.this.cancelChildViewTouch();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int clampViewPositionHorizontal(View view, int n2, int n3) {
            if (DrawerLayout.this.checkDrawerViewAbsoluteGravity(view, 3)) {
                return Math.max(-view.getWidth(), Math.min(n2, 0));
            }
            n3 = DrawerLayout.this.getWidth();
            return Math.max(n3 - view.getWidth(), Math.min(n2, n3));
        }

        @Override
        public int clampViewPositionVertical(View view, int n2, int n3) {
            return view.getTop();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getViewHorizontalDragRange(View view) {
            if (!DrawerLayout.this.isDrawerView(view)) return 0;
            return view.getWidth();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onEdgeDragStarted(int n2, int n3) {
            View view = (n2 & 1) == 1 ? DrawerLayout.this.findDrawerWithGravity(3) : DrawerLayout.this.findDrawerWithGravity(5);
            if (view != null && DrawerLayout.this.getDrawerLockMode(view) == 0) {
                this.mDragger.captureChildView(view, n3);
            }
        }

        @Override
        public boolean onEdgeLock(int n2) {
            return false;
        }

        @Override
        public void onEdgeTouched(int n2, int n3) {
            DrawerLayout.this.postDelayed(this.mPeekRunnable, 160L);
        }

        @Override
        public void onViewCaptured(View view, int n2) {
            LayoutParams.access$202((LayoutParams)view.getLayoutParams(), false);
            this.closeOtherDrawer();
        }

        @Override
        public void onViewDragStateChanged(int n2) {
            DrawerLayout.this.updateDrawerState(this.mAbsGravity, n2, this.mDragger.getCapturedView());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onViewPositionChanged(View view, int n2, int n3, int n4, int n5) {
            n3 = view.getWidth();
            float f2 = DrawerLayout.this.checkDrawerViewAbsoluteGravity(view, 3) ? (float)(n3 + n2) / (float)n3 : (float)(DrawerLayout.this.getWidth() - n2) / (float)n3;
            DrawerLayout.this.setDrawerViewOffset(view, f2);
            n2 = f2 == 0.0f ? 4 : 0;
            view.setVisibility(n2);
            DrawerLayout.this.invalidate();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onViewReleased(View view, float f2, float f3) {
            int n2;
            block4: {
                int n3;
                int n4;
                block5: {
                    block3: {
                        f3 = DrawerLayout.this.getDrawerViewOffset(view);
                        n4 = view.getWidth();
                        if (!DrawerLayout.this.checkDrawerViewAbsoluteGravity(view, 3)) break block3;
                        n2 = f2 > 0.0f || f2 == 0.0f && f3 > 0.5f ? 0 : -n4;
                        break block4;
                    }
                    n3 = DrawerLayout.this.getWidth();
                    if (f2 < 0.0f) break block5;
                    n2 = n3;
                    if (f2 != 0.0f) break block4;
                    n2 = n3;
                    if (!(f3 > 0.5f)) break block4;
                }
                n2 = n3 - n4;
            }
            this.mDragger.settleCapturedViewAt(n2, view.getTop());
            DrawerLayout.this.invalidate();
        }

        public void removeCallbacks() {
            DrawerLayout.this.removeCallbacks(this.mPeekRunnable);
        }

        public void setDragger(ViewDragHelper viewDragHelper) {
            this.mDragger = viewDragHelper;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean tryCaptureView(View view, int n2) {
            if (!DrawerLayout.this.isDrawerView(view)) return false;
            if (!DrawerLayout.this.checkDrawerViewAbsoluteGravity(view, this.mAbsGravity)) return false;
            if (DrawerLayout.this.getDrawerLockMode(view) != 0) return false;
            return true;
        }
    }
}

