/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.v4.widget.TintableCompoundButton;
import android.util.Log;
import android.widget.CompoundButton;
import java.lang.reflect.Field;

class CompoundButtonCompatDonut {
    private static final String TAG = "CompoundButtonCompatDonut";
    private static Field sButtonDrawableField;
    private static boolean sButtonDrawableFieldFetched;

    CompoundButtonCompatDonut() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Drawable getButtonDrawable(CompoundButton compoundButton) {
        if (!sButtonDrawableFieldFetched) {
            try {
                sButtonDrawableField = CompoundButton.class.getDeclaredField("mButtonDrawable");
                sButtonDrawableField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.i((String)TAG, (String)"Failed to retrieve mButtonDrawable field", (Throwable)noSuchFieldException);
            }
            sButtonDrawableFieldFetched = true;
        }
        if (sButtonDrawableField == null) return null;
        try {
            return (Drawable)sButtonDrawableField.get(compoundButton);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.i((String)TAG, (String)"Failed to get button drawable via reflection", (Throwable)illegalAccessException);
            sButtonDrawableField = null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ColorStateList getButtonTintList(CompoundButton compoundButton) {
        if (!(compoundButton instanceof TintableCompoundButton)) return null;
        return ((TintableCompoundButton)compoundButton).getSupportButtonTintList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PorterDuff.Mode getButtonTintMode(CompoundButton compoundButton) {
        if (!(compoundButton instanceof TintableCompoundButton)) return null;
        return ((TintableCompoundButton)compoundButton).getSupportButtonTintMode();
    }

    static void setButtonTintList(CompoundButton compoundButton, ColorStateList colorStateList) {
        if (compoundButton instanceof TintableCompoundButton) {
            ((TintableCompoundButton)compoundButton).setSupportButtonTintList(colorStateList);
        }
    }

    static void setButtonTintMode(CompoundButton compoundButton, PorterDuff.Mode mode) {
        if (compoundButton instanceof TintableCompoundButton) {
            ((TintableCompoundButton)compoundButton).setSupportButtonTintMode(mode);
        }
    }
}

