/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompatHC;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v4.view.WindowInsetsCompatApi21;
import android.view.View;
import android.view.ViewParent;
import android.view.WindowInsets;

class ViewCompatLollipop {
    private static ThreadLocal<Rect> sThreadLocalRect;

    ViewCompatLollipop() {
    }

    public static WindowInsetsCompat dispatchApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
        if (windowInsetsCompat instanceof WindowInsetsCompatApi21) {
            WindowInsets windowInsets = ((WindowInsetsCompatApi21)windowInsetsCompat).unwrap();
            view = view.dispatchApplyWindowInsets(windowInsets);
            windowInsetsCompat2 = windowInsetsCompat;
            if (view != windowInsets) {
                windowInsetsCompat2 = new WindowInsetsCompatApi21((WindowInsets)view);
            }
        }
        return windowInsetsCompat2;
    }

    public static boolean dispatchNestedFling(View view, float f2, float f3, boolean bl2) {
        return view.dispatchNestedFling(f2, f3, bl2);
    }

    public static boolean dispatchNestedPreFling(View view, float f2, float f3) {
        return view.dispatchNestedPreFling(f2, f3);
    }

    public static boolean dispatchNestedPreScroll(View view, int n2, int n3, int[] nArray, int[] nArray2) {
        return view.dispatchNestedPreScroll(n2, n3, nArray, nArray2);
    }

    public static boolean dispatchNestedScroll(View view, int n2, int n3, int n4, int n5, int[] nArray) {
        return view.dispatchNestedScroll(n2, n3, n4, n5, nArray);
    }

    static ColorStateList getBackgroundTintList(View view) {
        return view.getBackgroundTintList();
    }

    static PorterDuff.Mode getBackgroundTintMode(View view) {
        return view.getBackgroundTintMode();
    }

    public static float getElevation(View view) {
        return view.getElevation();
    }

    private static Rect getEmptyTempRect() {
        Rect rect;
        if (sThreadLocalRect == null) {
            sThreadLocalRect = new ThreadLocal();
        }
        Rect rect2 = rect = sThreadLocalRect.get();
        if (rect == null) {
            rect2 = new Rect();
            sThreadLocalRect.set(rect2);
        }
        rect2.setEmpty();
        return rect2;
    }

    public static String getTransitionName(View view) {
        return view.getTransitionName();
    }

    public static float getTranslationZ(View view) {
        return view.getTranslationZ();
    }

    public static float getZ(View view) {
        return view.getZ();
    }

    public static boolean hasNestedScrollingParent(View view) {
        return view.hasNestedScrollingParent();
    }

    public static boolean isImportantForAccessibility(View view) {
        return view.isImportantForAccessibility();
    }

    public static boolean isNestedScrollingEnabled(View view) {
        return view.isNestedScrollingEnabled();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void offsetLeftAndRight(View view, int n2) {
        boolean bl2;
        Rect rect = ViewCompatLollipop.getEmptyTempRect();
        ViewParent viewParent = view.getParent();
        if (viewParent instanceof View) {
            View view2 = (View)viewParent;
            rect.set(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom());
            bl2 = !rect.intersects(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        } else {
            bl2 = false;
        }
        ViewCompatHC.offsetLeftAndRight(view, n2);
        if (bl2 && rect.intersect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom())) {
            ((View)viewParent).invalidate(rect);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void offsetTopAndBottom(View view, int n2) {
        boolean bl2;
        Rect rect = ViewCompatLollipop.getEmptyTempRect();
        ViewParent viewParent = view.getParent();
        if (viewParent instanceof View) {
            View view2 = (View)viewParent;
            rect.set(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom());
            bl2 = !rect.intersects(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        } else {
            bl2 = false;
        }
        ViewCompatHC.offsetTopAndBottom(view, n2);
        if (bl2 && rect.intersect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom())) {
            ((View)viewParent).invalidate(rect);
        }
    }

    public static WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
        if (windowInsetsCompat instanceof WindowInsetsCompatApi21) {
            WindowInsets windowInsets = ((WindowInsetsCompatApi21)windowInsetsCompat).unwrap();
            view = view.onApplyWindowInsets(windowInsets);
            windowInsetsCompat2 = windowInsetsCompat;
            if (view != windowInsets) {
                windowInsetsCompat2 = new WindowInsetsCompatApi21((WindowInsets)view);
            }
        }
        return windowInsetsCompat2;
    }

    public static void requestApplyInsets(View view) {
        view.requestApplyInsets();
    }

    /*
     * Enabled aggressive block sorting
     */
    static void setBackgroundTintList(View view, ColorStateList colorStateList) {
        view.setBackgroundTintList(colorStateList);
        if (Build.VERSION.SDK_INT == 21) {
            colorStateList = view.getBackground();
            boolean bl2 = view.getBackgroundTintList() != null && view.getBackgroundTintMode() != null;
            if (colorStateList != null && bl2) {
                if (colorStateList.isStateful()) {
                    colorStateList.setState(view.getDrawableState());
                }
                view.setBackground((Drawable)colorStateList);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void setBackgroundTintMode(View view, PorterDuff.Mode mode) {
        view.setBackgroundTintMode(mode);
        if (Build.VERSION.SDK_INT == 21) {
            mode = view.getBackground();
            boolean bl2 = view.getBackgroundTintList() != null && view.getBackgroundTintMode() != null;
            if (mode != null && bl2) {
                if (mode.isStateful()) {
                    mode.setState(view.getDrawableState());
                }
                view.setBackground((Drawable)mode);
            }
        }
    }

    public static void setElevation(View view, float f2) {
        view.setElevation(f2);
    }

    public static void setNestedScrollingEnabled(View view, boolean bl2) {
        view.setNestedScrollingEnabled(bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setOnApplyWindowInsetsListener(View view, final OnApplyWindowInsetsListener onApplyWindowInsetsListener) {
        if (onApplyWindowInsetsListener == null) {
            view.setOnApplyWindowInsetsListener(null);
            return;
        }
        view.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

            public WindowInsets onApplyWindowInsets(View view, WindowInsets object) {
                object = new WindowInsetsCompatApi21((WindowInsets)object);
                return ((WindowInsetsCompatApi21)onApplyWindowInsetsListener.onApplyWindowInsets(view, (WindowInsetsCompat)object)).unwrap();
            }
        });
    }

    public static void setTransitionName(View view, String string2) {
        view.setTransitionName(string2);
    }

    public static void setTranslationZ(View view, float f2) {
        view.setTranslationZ(f2);
    }

    public static boolean startNestedScroll(View view, int n2) {
        return view.startNestedScroll(n2);
    }

    public static void stopNestedScroll(View view) {
        view.stopNestedScroll();
    }
}

