/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import android.support.v4.util.ContainerHelpers;

public class SparseArrayCompat<E>
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private int mSize;
    private Object[] mValues;

    public SparseArrayCompat() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SparseArrayCompat(int n2) {
        if (n2 == 0) {
            this.mKeys = ContainerHelpers.EMPTY_INTS;
            this.mValues = ContainerHelpers.EMPTY_OBJECTS;
        } else {
            n2 = ContainerHelpers.idealIntArraySize(n2);
            this.mKeys = new int[n2];
            this.mValues = new Object[n2];
        }
        this.mSize = 0;
    }

    private void gc() {
        int n2 = this.mSize;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            int n4 = n3;
            if (object != DELETED) {
                if (i2 != n3) {
                    nArray[n3] = nArray[i2];
                    objectArray[n3] = object;
                    objectArray[i2] = null;
                }
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        this.mGarbage = false;
        this.mSize = n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(int n2, E e2) {
        int n3;
        if (this.mSize != 0 && n2 <= this.mKeys[this.mSize - 1]) {
            this.put(n2, e2);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n3 = this.mSize) >= this.mKeys.length) {
            int n4 = ContainerHelpers.idealIntArraySize(n3 + 1);
            int[] nArray = new int[n4];
            Object[] objectArray = new Object[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n3] = n2;
        this.mValues[n3] = e2;
        this.mSize = n3 + 1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SparseArrayCompat<E> clone() {
        SparseArrayCompat sparseArrayCompat;
        try {
            sparseArrayCompat = (SparseArrayCompat)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        try {
            sparseArrayCompat.mKeys = (int[])this.mKeys.clone();
            sparseArrayCompat.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sparseArrayCompat;
        }
        return sparseArrayCompat;
    }

    public void delete(int n2) {
        if ((n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n2)) >= 0 && this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public E get(int n2) {
        return this.get(n2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public E get(int n2, E e2) {
        void var3_5;
        block4: {
            block3: {
                n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n2);
                E e3 = e2;
                if (n2 < 0) break block3;
                if (this.mValues[n2] != DELETED) break block4;
                E e4 = e2;
            }
            return var3_5;
        }
        Object object = this.mValues[n2];
        return var3_5;
    }

    public int indexOfKey(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(E e2) {
        if (this.mGarbage) {
            this.gc();
        }
        int n2 = 0;
        while (n2 < this.mSize) {
            if (this.mValues[n2] == e2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int keyAt(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(int n2, E e2) {
        int n3 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n2);
        if (n3 >= 0) {
            this.mValues[n3] = e2;
            return;
        }
        int n4 = ~n3;
        if (n4 < this.mSize && this.mValues[n4] == DELETED) {
            this.mKeys[n4] = n2;
            this.mValues[n4] = e2;
            return;
        }
        n3 = n4;
        if (this.mGarbage) {
            n3 = n4;
            if (this.mSize >= this.mKeys.length) {
                this.gc();
                n3 = ~ContainerHelpers.binarySearch(this.mKeys, this.mSize, n2);
            }
        }
        if (this.mSize >= this.mKeys.length) {
            n4 = ContainerHelpers.idealIntArraySize(this.mSize + 1);
            int[] nArray = new int[n4];
            Object[] objectArray = new Object[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        if (this.mSize - n3 != 0) {
            System.arraycopy(this.mKeys, n3, this.mKeys, n3 + 1, this.mSize - n3);
            System.arraycopy(this.mValues, n3, this.mValues, n3 + 1, this.mSize - n3);
        }
        this.mKeys[n3] = n2;
        this.mValues[n3] = e2;
        ++this.mSize;
    }

    public void remove(int n2) {
        this.delete(n2);
    }

    public void removeAt(int n2) {
        if (this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void removeAtRange(int n2, int n3) {
        n3 = Math.min(this.mSize, n2 + n3);
        while (n2 < n3) {
            this.removeAt(n2);
            ++n2;
        }
    }

    public void setValueAt(int n2, E e2) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n2] = e2;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        CharSequence charSequence = new StringBuilder(this.mSize * 28);
        ((StringBuilder)charSequence).append('{');
        int n2 = 0;
        while (true) {
            if (n2 >= this.mSize) {
                ((StringBuilder)charSequence).append('}');
                return ((StringBuilder)charSequence).toString();
            }
            if (n2 > 0) {
                ((StringBuilder)charSequence).append(", ");
            }
            ((StringBuilder)charSequence).append(this.keyAt(n2));
            ((StringBuilder)charSequence).append('=');
            E e2 = this.valueAt(n2);
            if (e2 != this) {
                ((StringBuilder)charSequence).append(e2);
            } else {
                ((StringBuilder)charSequence).append("(this Map)");
            }
            ++n2;
        }
    }

    public E valueAt(int n2) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n2];
    }
}

