/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.text.ICUCompat;
import android.support.v4.text.TextUtilsCompatJellybeanMr1;
import java.util.Locale;

public final class TextUtilsCompat {
    private static String ARAB_SCRIPT_SUBTAG;
    private static String HEBR_SCRIPT_SUBTAG;
    private static final TextUtilsCompatImpl IMPL;
    public static final Locale ROOT;

    /*
     * Enabled aggressive block sorting
     */
    static {
        IMPL = Build.VERSION.SDK_INT >= 17 ? new TextUtilsCompatJellybeanMr1Impl() : new TextUtilsCompatImpl();
        ROOT = new Locale("", "");
        ARAB_SCRIPT_SUBTAG = "Arab";
        HEBR_SCRIPT_SUBTAG = "Hebr";
    }

    private TextUtilsCompat() {
    }

    public static int getLayoutDirectionFromLocale(@Nullable Locale locale) {
        return IMPL.getLayoutDirectionFromLocale(locale);
    }

    @NonNull
    public static String htmlEncode(@NonNull String string2) {
        return IMPL.htmlEncode(string2);
    }

    private static class TextUtilsCompatImpl {
        private TextUtilsCompatImpl() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int getLayoutDirectionFromFirstChar(@NonNull Locale locale) {
            int n2 = 0;
            switch (Character.getDirectionality(locale.getDisplayName(locale).charAt(0))) {
                default: {
                    return n2;
                }
                case 1: 
                case 2: 
            }
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getLayoutDirectionFromLocale(@Nullable Locale locale) {
            if (locale == null) return 0;
            if (locale.equals(ROOT)) return 0;
            String string2 = ICUCompat.maximizeAndGetScript(locale);
            if (string2 == null) {
                return TextUtilsCompatImpl.getLayoutDirectionFromFirstChar(locale);
            }
            if (string2.equalsIgnoreCase(ARAB_SCRIPT_SUBTAG)) return 1;
            if (!string2.equalsIgnoreCase(HEBR_SCRIPT_SUBTAG)) return 0;
            return 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public String htmlEncode(@NonNull String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < string2.length()) {
                char c2 = string2.charAt(n2);
                switch (c2) {
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        break;
                    }
                    case '&': {
                        stringBuilder.append("&amp;");
                        break;
                    }
                    case '\'': {
                        stringBuilder.append("&#39;");
                        break;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                    }
                }
                ++n2;
            }
            return stringBuilder.toString();
        }
    }

    private static class TextUtilsCompatJellybeanMr1Impl
    extends TextUtilsCompatImpl {
        private TextUtilsCompatJellybeanMr1Impl() {
        }

        @Override
        public int getLayoutDirectionFromLocale(@Nullable Locale locale) {
            return TextUtilsCompatJellybeanMr1.getLayoutDirectionFromLocale(locale);
        }

        @Override
        @NonNull
        public String htmlEncode(@NonNull String string2) {
            return TextUtilsCompatJellybeanMr1.htmlEncode(string2);
        }
    }
}

