/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.text;

import android.os.Build;
import android.support.v4.text.ICUCompatApi23;
import android.support.v4.text.ICUCompatIcs;
import java.util.Locale;

public final class ICUCompat {
    private static final ICUCompatImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21) {
            IMPL = new ICUCompatImplLollipop();
            return;
        }
        if (n2 >= 14) {
            IMPL = new ICUCompatImplIcs();
            return;
        }
        IMPL = new ICUCompatImplBase();
    }

    private ICUCompat() {
    }

    public static String maximizeAndGetScript(Locale locale) {
        return IMPL.maximizeAndGetScript(locale);
    }

    static interface ICUCompatImpl {
        public String maximizeAndGetScript(Locale var1);
    }

    static class ICUCompatImplBase
    implements ICUCompatImpl {
        ICUCompatImplBase() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return null;
        }
    }

    static class ICUCompatImplIcs
    implements ICUCompatImpl {
        ICUCompatImplIcs() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatIcs.maximizeAndGetScript(locale);
        }
    }

    static class ICUCompatImplLollipop
    implements ICUCompatImpl {
        ICUCompatImplLollipop() {
        }

        @Override
        public String maximizeAndGetScript(Locale locale) {
            return ICUCompatApi23.maximizeAndGetScript(locale);
        }
    }
}

