/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.net.Uri;
import android.support.v4.provider.DocumentFile;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class RawDocumentFile
extends DocumentFile {
    private File mFile;

    RawDocumentFile(DocumentFile documentFile, File file) {
        super(documentFile);
        this.mFile = file;
    }

    private static boolean deleteContents(File fileArray) {
        fileArray = fileArray.listFiles();
        boolean bl2 = true;
        boolean bl3 = true;
        if (fileArray != null) {
            int n2 = fileArray.length;
            int n3 = 0;
            while (true) {
                bl2 = bl3;
                if (n3 >= n2) break;
                File file = fileArray[n3];
                bl2 = bl3;
                if (file.isDirectory()) {
                    bl2 = bl3 & RawDocumentFile.deleteContents(file);
                }
                bl3 = bl2;
                if (!file.delete()) {
                    Log.w((String)"DocumentFile", (String)("Failed to delete " + file));
                    bl3 = false;
                }
                ++n3;
            }
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getTypeForName(String string2) {
        int n2 = string2.lastIndexOf(46);
        if (n2 < 0) return "application/octet-stream";
        string2 = string2.substring(n2 + 1).toLowerCase();
        string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
        if (string2 == null) return "application/octet-stream";
        return string2;
    }

    @Override
    public boolean canRead() {
        return this.mFile.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.mFile.canWrite();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DocumentFile createDirectory(String object) {
        if (((File)(object = new File(this.mFile, (String)object))).isDirectory()) return new RawDocumentFile(this, (File)object);
        if (!((File)object).mkdir()) return null;
        return new RawDocumentFile(this, (File)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DocumentFile createFile(String object, String object2) {
        String string2 = MimeTypeMap.getSingleton().getExtensionFromMimeType((String)object);
        object = object2;
        if (string2 != null) {
            object = (String)object2 + "." + string2;
        }
        object2 = new File(this.mFile, (String)object);
        try {
            ((File)object2).createNewFile();
            return new RawDocumentFile(this, (File)object2);
        }
        catch (IOException iOException) {
            Log.w((String)"DocumentFile", (String)("Failed to createFile: " + iOException));
            return null;
        }
    }

    @Override
    public boolean delete() {
        RawDocumentFile.deleteContents(this.mFile);
        return this.mFile.delete();
    }

    @Override
    public boolean exists() {
        return this.mFile.exists();
    }

    @Override
    public String getName() {
        return this.mFile.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getType() {
        if (!this.mFile.isDirectory()) return RawDocumentFile.getTypeForName(this.mFile.getName());
        return null;
    }

    @Override
    public Uri getUri() {
        return Uri.fromFile((File)this.mFile);
    }

    @Override
    public boolean isDirectory() {
        return this.mFile.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.mFile.isFile();
    }

    @Override
    public long lastModified() {
        return this.mFile.lastModified();
    }

    @Override
    public long length() {
        return this.mFile.length();
    }

    @Override
    public DocumentFile[] listFiles() {
        ArrayList<RawDocumentFile> arrayList = new ArrayList<RawDocumentFile>();
        File[] fileArray = this.mFile.listFiles();
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(new RawDocumentFile(this, fileArray[i2]));
            }
        }
        return arrayList.toArray(new DocumentFile[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean renameTo(String object) {
        object = new File(this.mFile.getParentFile(), (String)object);
        if (!this.mFile.renameTo((File)object)) return false;
        this.mFile = object;
        return true;
    }
}

