/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.media.MediaDescriptionCompatApi21;
import android.support.v4.media.MediaDescriptionCompatApi23;
import android.text.TextUtils;

public final class MediaDescriptionCompat
implements Parcelable {
    public static final Parcelable.Creator<MediaDescriptionCompat> CREATOR = new Parcelable.Creator<MediaDescriptionCompat>(){

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MediaDescriptionCompat createFromParcel(Parcel object) {
            void var1_3;
            if (Build.VERSION.SDK_INT < 21) {
                MediaDescriptionCompat mediaDescriptionCompat = new MediaDescriptionCompat((Parcel)object);
                return var1_3;
            }
            MediaDescriptionCompat mediaDescriptionCompat = MediaDescriptionCompat.fromMediaDescription(MediaDescriptionCompatApi21.fromParcel(object));
            return var1_3;
        }

        public MediaDescriptionCompat[] newArray(int n2) {
            return new MediaDescriptionCompat[n2];
        }
    };
    public static final String DESCRIPTION_KEY_MEDIA_URI = "android.support.v4.media.description.MEDIA_URI";
    public static final String DESCRIPTION_KEY_NULL_BUNDLE_FLAG = "android.support.v4.media.description.NULL_BUNDLE_FLAG";
    private final CharSequence mDescription;
    private Object mDescriptionObj;
    private final Bundle mExtras;
    private final Bitmap mIcon;
    private final Uri mIconUri;
    private final String mMediaId;
    private final Uri mMediaUri;
    private final CharSequence mSubtitle;
    private final CharSequence mTitle;

    private MediaDescriptionCompat(Parcel parcel) {
        this.mMediaId = parcel.readString();
        this.mTitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mSubtitle = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mDescription = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mIcon = (Bitmap)parcel.readParcelable(null);
        this.mIconUri = (Uri)parcel.readParcelable(null);
        this.mExtras = parcel.readBundle();
        this.mMediaUri = (Uri)parcel.readParcelable(null);
    }

    private MediaDescriptionCompat(String string2, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Bitmap bitmap, Uri uri, Bundle bundle, Uri uri2) {
        this.mMediaId = string2;
        this.mTitle = charSequence;
        this.mSubtitle = charSequence2;
        this.mDescription = charSequence3;
        this.mIcon = bitmap;
        this.mIconUri = uri;
        this.mExtras = bundle;
        this.mMediaUri = uri2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static MediaDescriptionCompat fromMediaDescription(Object object) {
        void var2_6;
        void var2_4;
        Bundle bundle;
        Bundle bundle2 = bundle = null;
        if (object == null) return var2_4;
        if (Build.VERSION.SDK_INT < 21) {
            Bundle bundle3 = bundle;
            return var2_4;
        }
        Builder builder = new Builder();
        builder.setMediaId(MediaDescriptionCompatApi21.getMediaId(object));
        builder.setTitle(MediaDescriptionCompatApi21.getTitle(object));
        builder.setSubtitle(MediaDescriptionCompatApi21.getSubtitle(object));
        builder.setDescription(MediaDescriptionCompatApi21.getDescription(object));
        builder.setIconBitmap(MediaDescriptionCompatApi21.getIconBitmap(object));
        builder.setIconUri(MediaDescriptionCompatApi21.getIconUri(object));
        bundle = MediaDescriptionCompatApi21.getExtras(object);
        if (bundle == null) {
            Object var2_5 = null;
        } else {
            Uri uri = (Uri)bundle.getParcelable(DESCRIPTION_KEY_MEDIA_URI);
        }
        if (var2_6 != null) {
            if (bundle.containsKey(DESCRIPTION_KEY_NULL_BUNDLE_FLAG) && bundle.size() == 2) {
                bundle = null;
            } else {
                bundle.remove(DESCRIPTION_KEY_MEDIA_URI);
                bundle.remove(DESCRIPTION_KEY_NULL_BUNDLE_FLAG);
            }
        }
        builder.setExtras(bundle);
        if (var2_6 != null) {
            builder.setMediaUri((Uri)var2_6);
        } else if (Build.VERSION.SDK_INT >= 23) {
            builder.setMediaUri(MediaDescriptionCompatApi23.getMediaUri(object));
        }
        MediaDescriptionCompat mediaDescriptionCompat = builder.build();
        mediaDescriptionCompat.mDescriptionObj = object;
        return var2_4;
    }

    public int describeContents() {
        return 0;
    }

    @Nullable
    public CharSequence getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Nullable
    public Bitmap getIconBitmap() {
        return this.mIcon;
    }

    @Nullable
    public Uri getIconUri() {
        return this.mIconUri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMediaDescription() {
        if (this.mDescriptionObj != null) return this.mDescriptionObj;
        if (Build.VERSION.SDK_INT < 21) {
            return this.mDescriptionObj;
        }
        Object object = MediaDescriptionCompatApi21.Builder.newInstance();
        MediaDescriptionCompatApi21.Builder.setMediaId(object, this.mMediaId);
        MediaDescriptionCompatApi21.Builder.setTitle(object, this.mTitle);
        MediaDescriptionCompatApi21.Builder.setSubtitle(object, this.mSubtitle);
        MediaDescriptionCompatApi21.Builder.setDescription(object, this.mDescription);
        MediaDescriptionCompatApi21.Builder.setIconBitmap(object, this.mIcon);
        MediaDescriptionCompatApi21.Builder.setIconUri(object, this.mIconUri);
        Bundle bundle = this.mExtras;
        Object object2 = bundle;
        if (Build.VERSION.SDK_INT < 23) {
            object2 = bundle;
            if (this.mMediaUri != null) {
                object2 = bundle;
                if (bundle == null) {
                    object2 = new Bundle();
                    object2.putBoolean(DESCRIPTION_KEY_NULL_BUNDLE_FLAG, true);
                }
                object2.putParcelable(DESCRIPTION_KEY_MEDIA_URI, (Parcelable)this.mMediaUri);
            }
        }
        MediaDescriptionCompatApi21.Builder.setExtras(object, (Bundle)object2);
        this.mDescriptionObj = MediaDescriptionCompatApi21.Builder.build(object);
        if (Build.VERSION.SDK_INT < 23) return this.mDescriptionObj;
        MediaDescriptionCompatApi23.Builder.setMediaUri(object, this.mMediaUri);
        return this.mDescriptionObj;
    }

    @Nullable
    public String getMediaId() {
        return this.mMediaId;
    }

    @Nullable
    public Uri getMediaUri() {
        return this.mMediaUri;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public String toString() {
        return this.mTitle + ", " + this.mSubtitle + ", " + this.mDescription;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToParcel(Parcel parcel, int n2) {
        if (Build.VERSION.SDK_INT < 21) {
            parcel.writeString(this.mMediaId);
            TextUtils.writeToParcel((CharSequence)this.mTitle, (Parcel)parcel, (int)n2);
            TextUtils.writeToParcel((CharSequence)this.mSubtitle, (Parcel)parcel, (int)n2);
            TextUtils.writeToParcel((CharSequence)this.mDescription, (Parcel)parcel, (int)n2);
            parcel.writeParcelable((Parcelable)this.mIcon, n2);
            parcel.writeParcelable((Parcelable)this.mIconUri, n2);
            parcel.writeBundle(this.mExtras);
            parcel.writeParcelable((Parcelable)this.mMediaUri, n2);
            return;
        }
        MediaDescriptionCompatApi21.writeToParcel(this.getMediaDescription(), parcel, n2);
    }

    public static final class Builder {
        private CharSequence mDescription;
        private Bundle mExtras;
        private Bitmap mIcon;
        private Uri mIconUri;
        private String mMediaId;
        private Uri mMediaUri;
        private CharSequence mSubtitle;
        private CharSequence mTitle;

        public MediaDescriptionCompat build() {
            return new MediaDescriptionCompat(this.mMediaId, this.mTitle, this.mSubtitle, this.mDescription, this.mIcon, this.mIconUri, this.mExtras, this.mMediaUri);
        }

        public Builder setDescription(@Nullable CharSequence charSequence) {
            this.mDescription = charSequence;
            return this;
        }

        public Builder setExtras(@Nullable Bundle bundle) {
            this.mExtras = bundle;
            return this;
        }

        public Builder setIconBitmap(@Nullable Bitmap bitmap) {
            this.mIcon = bitmap;
            return this;
        }

        public Builder setIconUri(@Nullable Uri uri) {
            this.mIconUri = uri;
            return this;
        }

        public Builder setMediaId(@Nullable String string2) {
            this.mMediaId = string2;
            return this;
        }

        public Builder setMediaUri(@Nullable Uri uri) {
            this.mMediaUri = uri;
            return this;
        }

        public Builder setSubtitle(@Nullable CharSequence charSequence) {
            this.mSubtitle = charSequence;
            return this;
        }

        public Builder setTitle(@Nullable CharSequence charSequence) {
            this.mTitle = charSequence;
            return this;
        }
    }
}

