/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.BundleCompat;
import android.support.v4.media.MediaBrowserCompat;
import android.support.v4.media.MediaBrowserCompatUtils;
import android.support.v4.media.MediaBrowserServiceCompatApi21;
import android.support.v4.media.MediaBrowserServiceCompatApi23;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class MediaBrowserServiceCompat
extends Service {
    private static final boolean DBG = false;
    public static final String KEY_MEDIA_ITEM = "media_item";
    private static final int RESULT_FLAG_OPTION_NOT_HANDLED = 1;
    public static final String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    private static final String TAG = "MediaBrowserServiceCompat";
    private final ArrayMap<IBinder, ConnectionRecord> mConnections = new ArrayMap();
    private final ServiceHandler mHandler = new ServiceHandler();
    private MediaBrowserServiceImpl mImpl;
    MediaSessionCompat.Token mSession;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSubscription(String string2, ConnectionRecord connectionRecord, Bundle bundle) {
        List<Bundle> list = connectionRecord.subscriptions.get(string2);
        if (list == null) {
            list = new ArrayList<Bundle>();
        }
        Iterator<Bundle> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!MediaBrowserCompatUtils.areSameOptions(bundle, iterator.next())) continue;
            return;
        }
        list.add(bundle);
        connectionRecord.subscriptions.put(string2, list);
        this.performLoadChildren(string2, connectionRecord, bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<MediaBrowserCompat.MediaItem> applyOptions(List<MediaBrowserCompat.MediaItem> list, Bundle bundle) {
        int n2 = bundle.getInt("android.media.browse.extra.PAGE", -1);
        int n3 = bundle.getInt("android.media.browse.extra.PAGE_SIZE", -1);
        if (n2 == -1 && n3 == -1) {
            return list;
        }
        int n4 = n3 * (n2 - 1);
        int n5 = n4 + n3;
        if (n2 < 1) return Collections.emptyList();
        if (n3 < 1) return Collections.emptyList();
        if (n4 >= list.size()) {
            return Collections.emptyList();
        }
        n2 = n5;
        if (n5 <= list.size()) return list.subList(n4, n2);
        n2 = list.size();
        return list.subList(n4, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidPackage(String string2, int n2) {
        boolean bl2 = false;
        if (string2 == null) {
            return bl2;
        }
        String[] stringArray = this.getPackageManager().getPackagesForUid(n2);
        int n3 = stringArray.length;
        n2 = 0;
        while (true) {
            boolean bl3 = bl2;
            if (n2 >= n3) return bl3;
            if (stringArray[n2].equals(string2)) {
                return true;
            }
            ++n2;
        }
    }

    private void notifyChildrenChangedInternal(final String string2, final Bundle bundle) {
        if (string2 == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                block0: for (Object object : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                    object = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(object);
                    List<Bundle> list = object.subscriptions.get(string2);
                    if (list == null) continue;
                    for (Bundle bundle2 : list) {
                        if (!MediaBrowserCompatUtils.hasDuplicatedItems(bundle, bundle2)) continue;
                        MediaBrowserServiceCompat.this.performLoadChildren(string2, (ConnectionRecord)object, bundle2);
                        continue block0;
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performLoadChildren(final String string2, final ConnectionRecord connectionRecord, final Bundle bundle) {
        Result<List<MediaBrowserCompat.MediaItem>> result = new Result<List<MediaBrowserCompat.MediaItem>>((Object)string2){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            void onResultSent(List<MediaBrowserCompat.MediaItem> list, int n2) {
                if (MediaBrowserServiceCompat.this.mConnections.get(connectionRecord.callbacks.asBinder()) != connectionRecord) {
                    return;
                }
                List<MediaBrowserCompat.MediaItem> list2 = list;
                if ((n2 & 1) != 0) {
                    list2 = MediaBrowserCompatUtils.applyOptions(list, bundle);
                }
                try {
                    connectionRecord.callbacks.onLoadChildren(string2, list2, bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onLoadChildren() failed for id=" + string2 + " package=" + connectionRecord.pkg));
                    return;
                }
            }
        };
        if (bundle == null) {
            this.onLoadChildren(string2, result);
        } else {
            this.onLoadChildren(string2, result, bundle);
        }
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connectionRecord.pkg + " id=" + string2);
        }
    }

    private void performLoadItem(String string2, ResultReceiver object) {
        object = new Result<MediaBrowserCompat.MediaItem>((Object)string2, (ResultReceiver)object){
            final /* synthetic */ ResultReceiver val$receiver;
            {
                this.val$receiver = resultReceiver;
                super(object);
            }

            @Override
            void onResultSent(MediaBrowserCompat.MediaItem mediaItem, int n2) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaBrowserServiceCompat.KEY_MEDIA_ITEM, (Parcelable)mediaItem);
                this.val$receiver.send(0, bundle);
            }
        };
        this.onLoadItem(string2, (Result<MediaBrowserCompat.MediaItem>)object);
        if (!((Result)object).isDone()) {
            throw new IllegalStateException("onLoadItem must call detach() or sendResult() before returning for id=" + string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean removeSubscription(String string2, ConnectionRecord connectionRecord, Bundle bundle) {
        boolean bl2;
        List<Bundle> list;
        block2: {
            list = connectionRecord.subscriptions.get(string2);
            if (list == null) {
                return false;
            }
            for (Bundle bundle2 : list) {
                if (!MediaBrowserCompatUtils.areSameOptions(bundle, bundle2)) continue;
                list.remove(bundle2);
                bl2 = true;
                break block2;
            }
            bl2 = false;
        }
        boolean bl3 = bl2;
        if (list.size() != 0) return bl3;
        connectionRecord.subscriptions.remove(string2);
        return bl2;
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Nullable
    public MediaSessionCompat.Token getSessionToken() {
        return this.mSession;
    }

    public void notifyChildrenChanged(@NonNull String string2) {
        this.notifyChildrenChangedInternal(string2, null);
    }

    public void notifyChildrenChanged(@NonNull String string2, @NonNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("options cannot be null in notifyChildrenChanged");
        }
        this.notifyChildrenChangedInternal(string2, bundle);
    }

    public IBinder onBind(Intent intent) {
        return this.mImpl.onBind(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate() {
        super.onCreate();
        this.mImpl = Build.VERSION.SDK_INT >= 23 ? new MediaBrowserServiceImplApi23() : (Build.VERSION.SDK_INT >= 21 ? new MediaBrowserServiceImplApi21() : new MediaBrowserServiceImplBase());
        this.mImpl.onCreate();
    }

    @Nullable
    public abstract BrowserRoot onGetRoot(@NonNull String var1, int var2, @Nullable Bundle var3);

    public abstract void onLoadChildren(@NonNull String var1, @NonNull Result<List<MediaBrowserCompat.MediaItem>> var2);

    public void onLoadChildren(@NonNull String string2, @NonNull Result<List<MediaBrowserCompat.MediaItem>> result, @NonNull Bundle bundle) {
        result.setFlags(1);
        this.onLoadChildren(string2, result);
    }

    public void onLoadItem(String string2, Result<MediaBrowserCompat.MediaItem> result) {
        result.sendResult(null);
    }

    public void setSessionToken(final MediaSessionCompat.Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Session token may not be null.");
        }
        if (this.mSession != null) {
            throw new IllegalStateException("The session token has already been set.");
        }
        this.mSession = token;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder iBinder : MediaBrowserServiceCompat.this.mConnections.keySet()) {
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(iBinder);
                    try {
                        connectionRecord.callbacks.onConnect(connectionRecord.root.getRootId(), token, connectionRecord.root.getExtras());
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Connection for " + connectionRecord.pkg + " is no longer valid."));
                        MediaBrowserServiceCompat.this.mConnections.remove(iBinder);
                    }
                }
            }
        });
    }

    public static final class BrowserRoot {
        public static final String EXTRA_OFFLINE = "android.service.media.extra.OFFLINE";
        public static final String EXTRA_RECENT = "android.service.media.extra.RECENT";
        public static final String EXTRA_SUGGESTED = "android.service.media.extra.SUGGESTED";
        private final Bundle mExtras;
        private final String mRootId;

        public BrowserRoot(@NonNull String string2, @Nullable Bundle bundle) {
            if (string2 == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = string2;
            this.mExtras = bundle;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public String getRootId() {
            return this.mRootId;
        }
    }

    private class ConnectionRecord {
        ServiceCallbacks callbacks;
        String pkg;
        BrowserRoot root;
        Bundle rootHints;
        HashMap<String, List<Bundle>> subscriptions = new HashMap();

        private ConnectionRecord() {
        }
    }

    static interface MediaBrowserServiceImpl {
        public IBinder onBind(Intent var1);

        public void onCreate();
    }

    class MediaBrowserServiceImplApi21
    implements MediaBrowserServiceImpl {
        private Object mServiceObj;

        MediaBrowserServiceImplApi21() {
        }

        @Override
        public IBinder onBind(Intent intent) {
            return MediaBrowserServiceCompatApi21.onBind(this.mServiceObj, intent);
        }

        @Override
        public void onCreate() {
            this.mServiceObj = MediaBrowserServiceCompatApi21.createService();
            MediaBrowserServiceCompatApi21.onCreate(this.mServiceObj, new ServiceImplApi21());
        }
    }

    class MediaBrowserServiceImplApi23
    implements MediaBrowserServiceImpl {
        private Object mServiceObj;

        MediaBrowserServiceImplApi23() {
        }

        @Override
        public IBinder onBind(Intent intent) {
            return MediaBrowserServiceCompatApi23.onBind(this.mServiceObj, intent);
        }

        @Override
        public void onCreate() {
            this.mServiceObj = MediaBrowserServiceCompatApi23.createService();
            MediaBrowserServiceCompatApi23.onCreate(this.mServiceObj, new ServiceImplApi23());
        }
    }

    class MediaBrowserServiceImplBase
    implements MediaBrowserServiceImpl {
        private Messenger mMessenger;

        MediaBrowserServiceImplBase() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IBinder onBind(Intent intent) {
            if (!MediaBrowserServiceCompat.SERVICE_INTERFACE.equals(intent.getAction())) return null;
            return this.mMessenger.getBinder();
        }

        @Override
        public void onCreate() {
            this.mMessenger = new Messenger((Handler)MediaBrowserServiceCompat.this.mHandler);
        }
    }

    public static class Result<T> {
        private Object mDebug;
        private boolean mDetachCalled;
        private int mFlags;
        private boolean mSendResultCalled;

        Result(Object object) {
            this.mDebug = object;
        }

        public void detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isDone() {
            if (this.mDetachCalled) return true;
            if (!this.mSendResultCalled) return false;
            return true;
        }

        void onResultSent(T t2, int n2) {
        }

        public void sendResult(T t2) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(t2, this.mFlags);
        }

        void setFlags(int n2) {
            this.mFlags = n2;
        }
    }

    private static interface ServiceCallbacks {
        public IBinder asBinder();

        public void onConnect(String var1, MediaSessionCompat.Token var2, Bundle var3) throws RemoteException;

        public void onConnectFailed() throws RemoteException;

        public void onLoadChildren(String var1, List<MediaBrowserCompat.MediaItem> var2, Bundle var3) throws RemoteException;
    }

    private class ServiceCallbacksApi21
    implements ServiceCallbacks {
        final MediaBrowserServiceCompatApi21.ServiceCallbacks mCallbacks;
        Messenger mMessenger;

        ServiceCallbacksApi21(MediaBrowserServiceCompatApi21.ServiceCallbacks serviceCallbacks) {
            this.mCallbacks = serviceCallbacks;
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.asBinder();
        }

        @Override
        public void onConnect(String string2, MediaSessionCompat.Token token, Bundle bundle) throws RemoteException {
            Bundle bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            this.mMessenger = new Messenger((Handler)MediaBrowserServiceCompat.this.mHandler);
            BundleCompat.putBinder(bundle2, "extra_messenger", this.mMessenger.getBinder());
            bundle2.putInt("extra_service_version", 1);
            this.mCallbacks.onConnect(string2, token.getToken(), bundle2);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.mCallbacks.onConnectFailed();
        }

        @Override
        public void onLoadChildren(String string2, List<MediaBrowserCompat.MediaItem> object, Bundle object2) throws RemoteException {
            object2 = null;
            if (object != null) {
                object2 = new ArrayList();
                Iterator<MediaBrowserCompat.MediaItem> iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    Parcel parcel = Parcel.obtain();
                    ((MediaBrowserCompat.MediaItem)object).writeToParcel(parcel, 0);
                    object2.add(parcel);
                }
            }
            this.mCallbacks.onLoadChildren(string2, (List<Parcel>)object2);
        }
    }

    private class ServiceCallbacksCompat
    implements ServiceCallbacks {
        final Messenger mCallbacks;

        ServiceCallbacksCompat(Messenger messenger) {
            this.mCallbacks = messenger;
        }

        private void sendRequest(int n2, Bundle bundle) throws RemoteException {
            Message message = Message.obtain();
            message.what = n2;
            message.arg1 = 1;
            message.setData(bundle);
            this.mCallbacks.send(message);
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.getBinder();
        }

        @Override
        public void onConnect(String string2, MediaSessionCompat.Token token, Bundle bundle) throws RemoteException {
            Bundle bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            bundle2.putInt("extra_service_version", 1);
            bundle = new Bundle();
            bundle.putString("data_media_item_id", string2);
            bundle.putParcelable("data_media_session_token", (Parcelable)token);
            bundle.putBundle("data_root_hints", bundle2);
            this.sendRequest(1, bundle);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.sendRequest(2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onLoadChildren(String arrayList, List<MediaBrowserCompat.MediaItem> list, Bundle bundle) throws RemoteException {
            Bundle bundle2 = new Bundle();
            bundle2.putString("data_media_item_id", arrayList);
            bundle2.putBundle("data_options", bundle);
            if (list != null) {
                arrayList = list instanceof ArrayList ? (ArrayList<MediaBrowserCompat.MediaItem>)list : new ArrayList<MediaBrowserCompat.MediaItem>(list);
                bundle2.putParcelableArrayList("data_media_item_list", arrayList);
            }
            this.sendRequest(3, bundle2);
        }
    }

    private final class ServiceHandler
    extends Handler {
        private final ServiceImpl mServiceImpl;

        private ServiceHandler() {
            this.mServiceImpl = new ServiceImpl();
        }

        public ServiceImpl getServiceImpl() {
            return this.mServiceImpl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Message message) {
            Bundle bundle = message.getData();
            switch (message.what) {
                default: {
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Unhandled message: " + message + "\n  Service version: " + 1 + "\n  Client version: " + message.arg1));
                    return;
                }
                case 1: {
                    this.mServiceImpl.connect(bundle.getString("data_package_name"), bundle.getInt("data_calling_uid"), bundle.getBundle("data_root_hints"), new ServiceCallbacksCompat(message.replyTo));
                    return;
                }
                case 2: {
                    this.mServiceImpl.disconnect(new ServiceCallbacksCompat(message.replyTo));
                    return;
                }
                case 3: {
                    this.mServiceImpl.addSubscription(bundle.getString("data_media_item_id"), bundle.getBundle("data_options"), new ServiceCallbacksCompat(message.replyTo));
                    return;
                }
                case 4: {
                    this.mServiceImpl.removeSubscription(bundle.getString("data_media_item_id"), bundle.getBundle("data_options"), new ServiceCallbacksCompat(message.replyTo));
                    return;
                }
                case 5: {
                    this.mServiceImpl.getMediaItem(bundle.getString("data_media_item_id"), (ResultReceiver)bundle.getParcelable("data_result_receiver"));
                    return;
                }
                case 6: {
                    this.mServiceImpl.registerCallbacks(new ServiceCallbacksCompat(message.replyTo));
                    return;
                }
                case 7: 
            }
            this.mServiceImpl.unregisterCallbacks(new ServiceCallbacksCompat(message.replyTo));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void postOrRun(Runnable runnable) {
            if (Thread.currentThread() == this.getLooper().getThread()) {
                runnable.run();
                return;
            }
            this.post(runnable);
        }

        public boolean sendMessageAtTime(Message message, long l2) {
            Bundle bundle = message.getData();
            bundle.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            bundle.putInt("data_calling_uid", Binder.getCallingUid());
            return super.sendMessageAtTime(message, l2);
        }
    }

    private class ServiceImpl {
        private ServiceImpl() {
        }

        public void addSubscription(final String string2, final Bundle bundle, final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(iBinder);
                    if (connectionRecord == null) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("addSubscription for callback that isn't registered id=" + string2));
                        return;
                    }
                    MediaBrowserServiceCompat.this.addSubscription(string2, connectionRecord, bundle);
                }
            });
        }

        public void connect(final String string2, final int n2, final Bundle bundle, final ServiceCallbacks serviceCallbacks) {
            if (!MediaBrowserServiceCompat.this.isValidPackage(string2, n2)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + n2 + " package=" + string2);
            }
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    MediaBrowserServiceCompat.this.mConnections.remove(iBinder);
                    ConnectionRecord connectionRecord = new ConnectionRecord();
                    connectionRecord.pkg = string2;
                    connectionRecord.rootHints = bundle;
                    connectionRecord.callbacks = serviceCallbacks;
                    connectionRecord.root = MediaBrowserServiceCompat.this.onGetRoot(string2, n2, bundle);
                    if (connectionRecord.root == null) {
                        Log.i((String)MediaBrowserServiceCompat.TAG, (String)("No root for client " + string2 + " from service " + this.getClass().getName()));
                        try {
                            serviceCallbacks.onConnectFailed();
                            return;
                        }
                        catch (RemoteException remoteException) {
                            Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onConnectFailed() failed. Ignoring. pkg=" + string2));
                            return;
                        }
                    }
                    try {
                        MediaBrowserServiceCompat.this.mConnections.put(iBinder, connectionRecord);
                        if (MediaBrowserServiceCompat.this.mSession == null) return;
                        serviceCallbacks.onConnect(connectionRecord.root.getRootId(), MediaBrowserServiceCompat.this.mSession, connectionRecord.root.getExtras());
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("Calling onConnect() failed. Dropping client. pkg=" + string2));
                        MediaBrowserServiceCompat.this.mConnections.remove(iBinder);
                        return;
                    }
                }
            });
        }

        public void disconnect(final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    if ((ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.remove(iBinder) != null) {
                        // empty if block
                    }
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void getMediaItem(final String string2, final ResultReceiver resultReceiver) {
            if (TextUtils.isEmpty((CharSequence)string2) || resultReceiver == null) {
                return;
            }
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    MediaBrowserServiceCompat.this.performLoadItem(string2, resultReceiver);
                }
            });
        }

        public void registerCallbacks(final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    MediaBrowserServiceCompat.this.mConnections.remove(iBinder);
                    ConnectionRecord connectionRecord = new ConnectionRecord();
                    connectionRecord.callbacks = serviceCallbacks;
                    MediaBrowserServiceCompat.this.mConnections.put(iBinder, connectionRecord);
                }
            });
        }

        public void removeSubscription(final String string2, final Bundle bundle, final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    ConnectionRecord connectionRecord = (ConnectionRecord)MediaBrowserServiceCompat.this.mConnections.get(iBinder);
                    if (connectionRecord == null) {
                        Log.w((String)MediaBrowserServiceCompat.TAG, (String)("removeSubscription for callback that isn't registered id=" + string2));
                        return;
                    }
                    if (MediaBrowserServiceCompat.this.removeSubscription(string2, connectionRecord, bundle)) return;
                    Log.w((String)MediaBrowserServiceCompat.TAG, (String)("removeSubscription called for " + string2 + " which is not subscribed"));
                }
            });
        }

        public void unregisterCallbacks(final ServiceCallbacks serviceCallbacks) {
            MediaBrowserServiceCompat.this.mHandler.postOrRun(new Runnable(){

                @Override
                public void run() {
                    IBinder iBinder = serviceCallbacks.asBinder();
                    MediaBrowserServiceCompat.this.mConnections.remove(iBinder);
                }
            });
        }
    }

    private class ServiceImplApi21
    implements MediaBrowserServiceCompatApi21.ServiceImplApi21 {
        final ServiceImpl mServiceImpl;

        ServiceImplApi21() {
            this.mServiceImpl = MediaBrowserServiceCompat.this.mHandler.getServiceImpl();
        }

        @Override
        public void addSubscription(String string2, MediaBrowserServiceCompatApi21.ServiceCallbacks serviceCallbacks) {
            this.mServiceImpl.addSubscription(string2, null, new ServiceCallbacksApi21(serviceCallbacks));
        }

        @Override
        public void connect(String string2, Bundle bundle, MediaBrowserServiceCompatApi21.ServiceCallbacks serviceCallbacks) {
            this.mServiceImpl.connect(string2, Binder.getCallingUid(), bundle, new ServiceCallbacksApi21(serviceCallbacks));
        }

        @Override
        public void disconnect(MediaBrowserServiceCompatApi21.ServiceCallbacks serviceCallbacks) {
            this.mServiceImpl.disconnect(new ServiceCallbacksApi21(serviceCallbacks));
        }

        @Override
        public void removeSubscription(String string2, MediaBrowserServiceCompatApi21.ServiceCallbacks serviceCallbacks) {
            this.mServiceImpl.removeSubscription(string2, null, new ServiceCallbacksApi21(serviceCallbacks));
        }
    }

    private class ServiceImplApi23
    extends ServiceImplApi21
    implements MediaBrowserServiceCompatApi23.ServiceImplApi23 {
        private ServiceImplApi23() {
        }

        @Override
        public void getMediaItem(String string2, MediaBrowserServiceCompatApi23.ItemCallback object) {
            object = new ResultReceiver(MediaBrowserServiceCompat.this.mHandler, (MediaBrowserServiceCompatApi23.ItemCallback)object){
                final /* synthetic */ MediaBrowserServiceCompatApi23.ItemCallback val$cb;
                {
                    this.val$cb = itemCallback;
                    super(handler);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                protected void onReceiveResult(int n2, Bundle bundle) {
                    Parcel parcel;
                    MediaBrowserCompat.MediaItem mediaItem = (MediaBrowserCompat.MediaItem)bundle.getParcelable(MediaBrowserServiceCompat.KEY_MEDIA_ITEM);
                    if (mediaItem != null) {
                        parcel = Parcel.obtain();
                        mediaItem.writeToParcel(parcel, 0);
                    } else {
                        parcel = null;
                    }
                    this.val$cb.onItemLoaded(n2, bundle, parcel);
                }
            };
            this.mServiceImpl.getMediaItem(string2, (ResultReceiver)object);
        }
    }
}

