/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class LocalBroadcastManager {
    private static final boolean DEBUG = false;
    static final int MSG_EXEC_PENDING_BROADCASTS = 1;
    private static final String TAG = "LocalBroadcastManager";
    private static LocalBroadcastManager mInstance;
    private static final Object mLock;
    private final HashMap<String, ArrayList<ReceiverRecord>> mActions;
    private final Context mAppContext;
    private final Handler mHandler;
    private final ArrayList<BroadcastRecord> mPendingBroadcasts;
    private final HashMap<BroadcastReceiver, ArrayList<IntentFilter>> mReceivers = new HashMap();

    static {
        mLock = new Object();
    }

    private LocalBroadcastManager(Context context) {
        this.mActions = new HashMap();
        this.mPendingBroadcasts = new ArrayList();
        this.mAppContext = context;
        this.mHandler = new Handler(context.getMainLooper()){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        super.handleMessage(message);
                        return;
                    }
                    case 1: 
                }
                LocalBroadcastManager.this.executePendingBroadcasts();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePendingBroadcasts() {
        block3: while (true) {
            BroadcastRecord[] broadcastRecordArray;
            int n2;
            Object object = this.mReceivers;
            synchronized (object) {
                n2 = this.mPendingBroadcasts.size();
                if (n2 <= 0) {
                    return;
                }
                broadcastRecordArray = new BroadcastRecord[n2];
                this.mPendingBroadcasts.toArray(broadcastRecordArray);
                this.mPendingBroadcasts.clear();
            }
            n2 = 0;
            while (true) {
                if (n2 >= broadcastRecordArray.length) continue block3;
                object = broadcastRecordArray[n2];
                for (int i2 = 0; i2 < ((BroadcastRecord)object).receivers.size(); ++i2) {
                    ((BroadcastRecord)object).receivers.get((int)i2).receiver.onReceive(this.mAppContext, ((BroadcastRecord)object).intent);
                }
                ++n2;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalBroadcastManager getInstance(Context object) {
        Object object2 = mLock;
        synchronized (object2) {
            LocalBroadcastManager localBroadcastManager;
            if (mInstance != null) return mInstance;
            mInstance = localBroadcastManager = new LocalBroadcastManager(object.getApplicationContext());
            return mInstance;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerReceiver(BroadcastReceiver object, IntentFilter intentFilter) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverRecord receiverRecord = new ReceiverRecord(intentFilter, (BroadcastReceiver)object);
            Object object2 = this.mReceivers.get(object);
            ArrayList<Object> arrayList = object2;
            if (object2 == null) {
                arrayList = new ArrayList<Object>(1);
                this.mReceivers.put((BroadcastReceiver)object, (ArrayList<IntentFilter>)arrayList);
            }
            arrayList.add(intentFilter);
            int n2 = 0;
            while (n2 < intentFilter.countActions()) {
                object2 = intentFilter.getAction(n2);
                arrayList = this.mActions.get(object2);
                object = arrayList;
                if (arrayList == null) {
                    object = new ArrayList(1);
                    this.mActions.put((String)object2, (ArrayList<ReceiverRecord>)object);
                }
                object.add(receiverRecord);
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendBroadcast(Intent intent) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            Object object;
            ArrayList<ReceiverRecord> arrayList;
            Serializable serializable;
            String string2 = intent.getAction();
            String string3 = intent.resolveTypeIfNeeded(this.mAppContext.getContentResolver());
            Uri uri = intent.getData();
            String string4 = intent.getScheme();
            Object object2 = intent.getCategories();
            int n2 = (intent.getFlags() & 8) != 0 ? 1 : 0;
            if (n2 != 0) {
                serializable = new StringBuilder();
                Log.v((String)TAG, (String)((StringBuilder)serializable).append("Resolving type ").append(string3).append(" scheme ").append(string4).append(" of intent ").append(intent).toString());
            }
            if ((arrayList = this.mActions.get(intent.getAction())) == null) return false;
            if (n2 != 0) {
                serializable = new StringBuilder();
                Log.v((String)TAG, (String)((StringBuilder)serializable).append("Action list: ").append(arrayList).toString());
            }
            serializable = null;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                StringBuilder stringBuilder;
                object = arrayList.get(i2);
                if (n2 != 0) {
                    stringBuilder = new StringBuilder();
                    Log.v((String)TAG, (String)stringBuilder.append("Matching against filter ").append(((ReceiverRecord)object).filter).toString());
                }
                if (((ReceiverRecord)object).broadcasting) {
                    if (n2 == 0) continue;
                    Log.v((String)TAG, (String)"  Filter's target already added");
                    continue;
                }
                int n3 = ((ReceiverRecord)object).filter.match(string2, string3, string4, uri, (Set)object2, TAG);
                if (n3 >= 0) {
                    if (n2 != 0) {
                        stringBuilder = new StringBuilder();
                        Log.v((String)TAG, (String)stringBuilder.append("  Filter matched!  match=0x").append(Integer.toHexString(n3)).toString());
                    }
                    if (serializable == null) {
                        serializable = new ArrayList();
                    }
                    ((ArrayList)serializable).add(object);
                    ((ReceiverRecord)object).broadcasting = true;
                    continue;
                }
                if (n2 == 0) continue;
                switch (n3) {
                    default: {
                        object = "unknown reason";
                        break;
                    }
                    case -3: {
                        object = "action";
                        break;
                    }
                    case -4: {
                        object = "category";
                        break;
                    }
                    case -2: {
                        object = "data";
                        break;
                    }
                    case -1: {
                        object = "type";
                    }
                }
                stringBuilder = new StringBuilder();
                Log.v((String)TAG, (String)stringBuilder.append("  Filter did not match: ").append((String)object).toString());
            }
            if (serializable == null) return false;
            for (n2 = 0; n2 < ((ArrayList)serializable).size(); ++n2) {
                ((ReceiverRecord)((ArrayList)serializable).get((int)n2)).broadcasting = false;
            }
            object = this.mPendingBroadcasts;
            object2 = new BroadcastRecord(intent, (ArrayList<ReceiverRecord>)serializable);
            ((ArrayList)object).add(object2);
            if (this.mHandler.hasMessages(1)) return true;
            this.mHandler.sendEmptyMessage(1);
            return true;
        }
    }

    public void sendBroadcastSync(Intent intent) {
        if (this.sendBroadcast(intent)) {
            this.executePendingBroadcasts();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<IntentFilter> arrayList = this.mReceivers.remove(broadcastReceiver);
            if (arrayList == null) {
                return;
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                IntentFilter intentFilter = arrayList.get(n2);
                for (int i2 = 0; i2 < intentFilter.countActions(); ++i2) {
                    String string2 = intentFilter.getAction(i2);
                    ArrayList<ReceiverRecord> arrayList2 = this.mActions.get(string2);
                    if (arrayList2 == null) continue;
                    for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                        if (arrayList2.get((int)i3).receiver != broadcastReceiver) continue;
                        arrayList2.remove(i3);
                        --i3;
                    }
                    if (arrayList2.size() > 0) continue;
                    this.mActions.remove(string2);
                }
                ++n2;
            }
            return;
        }
    }

    private static class BroadcastRecord {
        final Intent intent;
        final ArrayList<ReceiverRecord> receivers;

        BroadcastRecord(Intent intent, ArrayList<ReceiverRecord> arrayList) {
            this.intent = intent;
            this.receivers = arrayList;
        }
    }

    private static class ReceiverRecord {
        boolean broadcasting;
        final IntentFilter filter;
        final BroadcastReceiver receiver;

        ReceiverRecord(IntentFilter intentFilter, BroadcastReceiver broadcastReceiver) {
            this.filter = intentFilter;
            this.receiver = broadcastReceiver;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Receiver{");
            stringBuilder.append(this.receiver);
            stringBuilder.append(" filter=");
            stringBuilder.append(this.filter);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

