/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class FileProvider
extends ContentProvider {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final File DEVICE_ROOT = new File("/");
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_ROOT_PATH = "root-path";
    private static HashMap<String, PathStrategy> sCache = new HashMap();
    private PathStrategy mStrategy;

    private static File buildPath(File file, String ... stringArray) {
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            file = new File(file, string2);
        }
        return file;
    }

    private static Object[] copyOf(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    private static String[] copyOf(String[] stringArray, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PathStrategy getPathStrategy(Context object, String object2) {
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            PathStrategy pathStrategy;
            PathStrategy pathStrategy2 = pathStrategy = sCache.get(object2);
            if (pathStrategy == null) {
                try {
                    pathStrategy2 = FileProvider.parsePathStrategy(object, (String)object2);
                    sCache.put((String)object2, pathStrategy2);
                }
                catch (IOException iOException) {
                    object = new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", iOException);
                    throw object;
                }
                catch (XmlPullParserException xmlPullParserException) {
                    object2 = new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", xmlPullParserException);
                    throw object2;
                }
            }
            return pathStrategy2;
        }
    }

    public static Uri getUriForFile(Context context, String string2, File file) {
        return FileProvider.getPathStrategy(context, string2).getUriForFile(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int modeToMode(String string2) {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2)) return 0x2C000000;
        if ("wt".equals(string2)) {
            return 0x2C000000;
        }
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if (!"rwt".equals(string2)) throw new IllegalArgumentException("Invalid mode: " + string2);
        return 0x3C000000;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PathStrategy parsePathStrategy(Context context, String object) throws IOException, XmlPullParserException {
        SimplePathStrategy simplePathStrategy = new SimplePathStrategy((String)object);
        XmlResourceParser xmlResourceParser = context.getPackageManager().resolveContentProvider((String)object, 128).loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS);
        if (xmlResourceParser == null) {
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        int n2;
        while ((n2 = xmlResourceParser.next()) != 1) {
            if (n2 != 2) continue;
            object = xmlResourceParser.getName();
            String string2 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
            String string3 = xmlResourceParser.getAttributeValue(null, ATTR_PATH);
            if ((object = TAG_ROOT_PATH.equals(object) ? FileProvider.buildPath(DEVICE_ROOT, string3) : (TAG_FILES_PATH.equals(object) ? FileProvider.buildPath(context.getFilesDir(), string3) : (TAG_CACHE_PATH.equals(object) ? FileProvider.buildPath(context.getCacheDir(), string3) : (TAG_EXTERNAL.equals(object) ? FileProvider.buildPath(Environment.getExternalStorageDirectory(), string3) : null)))) == null) continue;
            simplePathStrategy.addRoot(string2, (File)object);
        }
        return simplePathStrategy;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (providerInfo.exported) {
            throw new SecurityException("Provider must not be exported");
        }
        if (!providerInfo.grantUriPermissions) {
            throw new SecurityException("Provider must grant uri permissions");
        }
        this.mStrategy = FileProvider.getPathStrategy(context, providerInfo.authority);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int delete(Uri uri, String string2, String[] stringArray) {
        if (!this.mStrategy.getFileForUri(uri).delete()) return 0;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getType(Uri object) {
        int n2 = ((File)(object = this.mStrategy.getFileForUri((Uri)object))).getName().lastIndexOf(46);
        if (n2 < 0) return "application/octet-stream";
        object = ((File)object).getName().substring(n2 + 1);
        object = MimeTypeMap.getSingleton().getMimeTypeFromExtension((String)object);
        if (object == null) return "application/octet-stream";
        return object;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public boolean onCreate() {
        return true;
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return ParcelFileDescriptor.open((File)this.mStrategy.getFileForUri(uri), (int)FileProvider.modeToMode(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Cursor query(Uri objectArray, String[] matrixCursor, String stringArray, String[] object, String stringArray2) {
        stringArray = this.mStrategy.getFileForUri((Uri)objectArray);
        objectArray = matrixCursor;
        if (matrixCursor == null) {
            objectArray = COLUMNS;
        }
        String[] stringArray3 = new String[objectArray.length];
        matrixCursor = new Object[objectArray.length];
        int n2 = objectArray.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n3 >= n2) {
                stringArray = FileProvider.copyOf(stringArray3, n4);
                objectArray = FileProvider.copyOf((Object[])matrixCursor, n4);
                matrixCursor = new MatrixCursor(stringArray, 1);
                matrixCursor.addRow(objectArray);
                return matrixCursor;
            }
            String string2 = objectArray[n3];
            if ("_display_name".equals(string2)) {
                stringArray3[n4] = "_display_name";
                n5 = n4 + 1;
                matrixCursor[n4] = stringArray.getName();
                n4 = n5;
            } else if ("_size".equals(string2)) {
                stringArray3[n4] = "_size";
                n5 = n4 + 1;
                matrixCursor[n4] = Long.valueOf(stringArray.length());
                n4 = n5;
            }
            ++n3;
        }
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    static interface PathStrategy {
        public File getFileForUri(Uri var1);

        public Uri getUriForFile(File var1);
    }

    static class SimplePathStrategy
    implements PathStrategy {
        private final String mAuthority;
        private final HashMap<String, File> mRoots = new HashMap();

        public SimplePathStrategy(String string2) {
            this.mAuthority = string2;
        }

        public void addRoot(String string2, File file) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Name must not be empty");
            }
            try {
                File file2 = file.getCanonicalFile();
                this.mRoots.put(string2, file2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + file, iOException);
            }
        }

        @Override
        public File getFileForUri(Uri object) {
            Object object2 = object.getEncodedPath();
            int n2 = ((String)object2).indexOf(47, 1);
            Object object3 = Uri.decode((String)((String)object2).substring(1, n2));
            object2 = Uri.decode((String)((String)object2).substring(n2 + 1));
            if ((object3 = this.mRoots.get(object3)) == null) {
                throw new IllegalArgumentException("Unable to find configured root for " + object);
            }
            object = new File((File)object3, (String)object2);
            try {
                object2 = ((File)object).getCanonicalFile();
                if (!((File)object2).getPath().startsWith(((File)object3).getPath())) {
                    throw new SecurityException("Resolved path jumped beyond configured root");
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Failed to resolve canonical path for " + object);
            }
            return object2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Uri getUriForFile(File var1_1) {
            block9: {
                try {
                    var2_2 = var1_1.getCanonicalPath();
                    var1_1 = null;
                }
                catch (IOException var6_7) {
                    throw new IllegalArgumentException("Failed to resolve canonical path for " + var1_1);
                }
                block2: for (Map.Entry<String, File> var4_4 : this.mRoots.entrySet()) {
                    var5_5 = var4_4.getValue().getPath();
                    if (!var2_2.startsWith(var5_5)) break block9;
                    var6_6 = var4_4;
                    if (var1_1 != null) {
                        if (var5_5.length() <= ((File)var1_1.getValue()).getPath().length()) break block9;
                        var6_6 = var4_4;
                    }
lbl11:
                    // 4 sources

                    while (true) {
                        var1_1 = var6_6;
                        continue block2;
                        break;
                    }
                }
                if (var1_1 == null) {
                    throw new IllegalArgumentException("Failed to find configured root that contains " + var2_2);
                }
                var6_6 = ((File)var1_1.getValue()).getPath();
                if (var6_6.endsWith("/")) {
                    var6_6 = var2_2.substring(var6_6.length());
lbl23:
                    // 2 sources

                    while (true) {
                        var1_1 = Uri.encode((String)((String)var1_1.getKey())) + '/' + Uri.encode(var6_6, (String)"/");
                        return new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath((String)var1_1).build();
                    }
                }
                var6_6 = var2_2.substring(var6_6.length() + 1);
                ** while (true)
            }
            var6_6 = var1_1;
            ** while (true)
        }
    }
}

