/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.NavUtilsJB;
import android.support.v4.content.IntentCompat;
import android.util.Log;

public final class NavUtils {
    private static final NavUtilsImpl IMPL;
    public static final String PARENT_ACTIVITY = "android.support.PARENT_ACTIVITY";
    private static final String TAG = "NavUtils";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 16) {
            IMPL = new NavUtilsImplJB();
            return;
        }
        IMPL = new NavUtilsImplBase();
    }

    private NavUtils() {
    }

    public static Intent getParentActivityIntent(Activity activity) {
        return IMPL.getParentActivityIntent(activity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Intent getParentActivityIntent(Context context, ComponentName componentName) throws PackageManager.NameNotFoundException {
        String string2 = NavUtils.getParentActivityName(context, componentName);
        if (string2 == null) {
            return null;
        }
        if (NavUtils.getParentActivityName(context, componentName = new ComponentName(componentName.getPackageName(), string2)) != null) return new Intent().setComponent(componentName);
        return IntentCompat.makeMainActivity(componentName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Intent getParentActivityIntent(Context context, Class<?> object) throws PackageManager.NameNotFoundException {
        if ((object = NavUtils.getParentActivityName(context, new ComponentName(context, (Class)object))) == null) {
            return null;
        }
        if (NavUtils.getParentActivityName(context, (ComponentName)(object = new ComponentName(context, (String)object))) != null) return new Intent().setComponent((ComponentName)object);
        return IntentCompat.makeMainActivity((ComponentName)object);
    }

    @Nullable
    public static String getParentActivityName(Activity object) {
        try {
            object = NavUtils.getParentActivityName((Context)object, object.getComponentName());
            return object;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException(nameNotFoundException);
        }
    }

    @Nullable
    public static String getParentActivityName(Context context, ComponentName componentName) throws PackageManager.NameNotFoundException {
        componentName = context.getPackageManager().getActivityInfo(componentName, 128);
        return IMPL.getParentActivityName(context, (ActivityInfo)componentName);
    }

    public static void navigateUpFromSameTask(Activity activity) {
        Intent intent = NavUtils.getParentActivityIntent(activity);
        if (intent == null) {
            throw new IllegalArgumentException("Activity " + activity.getClass().getSimpleName() + " does not have a parent activity name specified." + " (Did you forget to add the android.support.PARENT_ACTIVITY <meta-data> " + " element in your manifest?)");
        }
        NavUtils.navigateUpTo(activity, intent);
    }

    public static void navigateUpTo(Activity activity, Intent intent) {
        IMPL.navigateUpTo(activity, intent);
    }

    public static boolean shouldUpRecreateTask(Activity activity, Intent intent) {
        return IMPL.shouldUpRecreateTask(activity, intent);
    }

    static interface NavUtilsImpl {
        public Intent getParentActivityIntent(Activity var1);

        public String getParentActivityName(Context var1, ActivityInfo var2);

        public void navigateUpTo(Activity var1, Intent var2);

        public boolean shouldUpRecreateTask(Activity var1, Intent var2);
    }

    static class NavUtilsImplBase
    implements NavUtilsImpl {
        NavUtilsImplBase() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Intent getParentActivityIntent(Activity activity) {
            Object var2_3 = null;
            String string2 = NavUtils.getParentActivityName(activity);
            if (string2 == null) {
                return var2_3;
            }
            ComponentName componentName = new ComponentName((Context)activity, string2);
            try {
                if (NavUtils.getParentActivityName((Context)activity, componentName) == null) {
                    return IntentCompat.makeMainActivity(componentName);
                }
                activity = new Intent();
                return activity.setComponent(componentName);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)NavUtils.TAG, (String)("getParentActivityIntent: bad parentActivityName '" + string2 + "' in manifest"));
                return var2_3;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public String getParentActivityName(Context context, ActivityInfo object) {
            void var2_4;
            if (object.metaData == null) {
                return var2_4;
            }
            String string2 = object.metaData.getString(NavUtils.PARENT_ACTIVITY);
            if (string2 == null) {
                return var2_4;
            }
            String string3 = string2;
            if (string2.charAt(0) != '.') return var2_4;
            String string4 = context.getPackageName() + string2;
            return var2_4;
        }

        @Override
        public void navigateUpTo(Activity activity, Intent intent) {
            intent.addFlags(0x4000000);
            activity.startActivity(intent);
            activity.finish();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean shouldUpRecreateTask(Activity object, Intent intent) {
            if ((object = object.getIntent().getAction()) == null) return false;
            if (((String)object).equals("android.intent.action.MAIN")) return false;
            return true;
        }
    }

    static class NavUtilsImplJB
    extends NavUtilsImplBase {
        NavUtilsImplJB() {
        }

        @Override
        public Intent getParentActivityIntent(Activity activity) {
            Intent intent;
            Intent intent2 = intent = NavUtilsJB.getParentActivityIntent(activity);
            if (intent == null) {
                intent2 = this.superGetParentActivityIntent(activity);
            }
            return intent2;
        }

        @Override
        public String getParentActivityName(Context context, ActivityInfo activityInfo) {
            String string2;
            String string3 = string2 = NavUtilsJB.getParentActivityName(activityInfo);
            if (string2 == null) {
                string3 = super.getParentActivityName(context, activityInfo);
            }
            return string3;
        }

        @Override
        public void navigateUpTo(Activity activity, Intent intent) {
            NavUtilsJB.navigateUpTo(activity, intent);
        }

        @Override
        public boolean shouldUpRecreateTask(Activity activity, Intent intent) {
            return NavUtilsJB.shouldUpRecreateTask(activity, intent);
        }

        Intent superGetParentActivityIntent(Activity activity) {
            return super.getParentActivityIntent(activity);
        }
    }
}

