/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v13.app.FragmentCompat;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = "FragmentStatePagerAdapter";
    private FragmentTransaction mCurTransaction = null;
    private Fragment mCurrentPrimaryItem = null;
    private final FragmentManager mFragmentManager;
    private ArrayList<Fragment> mFragments;
    private ArrayList<Fragment.SavedState> mSavedState = new ArrayList();

    public FragmentStatePagerAdapter(FragmentManager fragmentManager) {
        this.mFragments = new ArrayList();
        this.mFragmentManager = fragmentManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void destroyItem(ViewGroup object, int n2, Object arrayList) {
        Fragment fragment = (Fragment)arrayList;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        while (this.mSavedState.size() <= n2) {
            this.mSavedState.add(null);
        }
        arrayList = this.mSavedState;
        object = fragment.isAdded() ? this.mFragmentManager.saveFragmentInstanceState(fragment) : null;
        arrayList.set(n2, (Fragment.SavedState)object);
        this.mFragments.set(n2, null);
        this.mCurTransaction.remove(fragment);
    }

    @Override
    public void finishUpdate(ViewGroup viewGroup) {
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }

    public abstract Fragment getItem(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object instantiateItem(ViewGroup viewGroup, int n2) {
        Fragment.SavedState savedState;
        Fragment fragment;
        if (this.mFragments.size() > n2 && (fragment = this.mFragments.get(n2)) != null) {
            return fragment;
        }
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        fragment = this.getItem(n2);
        if (this.mSavedState.size() > n2 && (savedState = this.mSavedState.get(n2)) != null) {
            fragment.setInitialSavedState(savedState);
        }
        while (this.mFragments.size() <= n2) {
            this.mFragments.add(null);
        }
        FragmentCompat.setMenuVisibility(fragment, false);
        FragmentCompat.setUserVisibleHint(fragment, false);
        this.mFragments.set(n2, fragment);
        this.mCurTransaction.add(viewGroup.getId(), fragment);
        return fragment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isViewFromObject(View view, Object object) {
        if (((Fragment)object).getView() != view) return false;
        return true;
    }

    @Override
    public void restoreState(Parcelable parcelable, ClassLoader object) {
        if (parcelable != null) {
            int n2;
            parcelable = (Bundle)parcelable;
            parcelable.setClassLoader((ClassLoader)object);
            object = parcelable.getParcelableArray("states");
            this.mSavedState.clear();
            this.mFragments.clear();
            if (object != null) {
                for (n2 = 0; n2 < ((Parcelable[])object).length; ++n2) {
                    this.mSavedState.add((Fragment.SavedState)object[n2]);
                }
            }
            for (String string2 : parcelable.keySet()) {
                if (!string2.startsWith("f")) continue;
                n2 = Integer.parseInt(string2.substring(1));
                Fragment fragment = this.mFragmentManager.getFragment((Bundle)parcelable, string2);
                if (fragment != null) {
                    while (this.mFragments.size() <= n2) {
                        this.mFragments.add(null);
                    }
                    FragmentCompat.setMenuVisibility(fragment, false);
                    this.mFragments.set(n2, fragment);
                    continue;
                }
                Log.w((String)TAG, (String)("Bad fragment at key " + string2));
            }
        }
    }

    @Override
    public Parcelable saveState() {
        Object object;
        Bundle bundle = null;
        if (this.mSavedState.size() > 0) {
            bundle = new Bundle();
            object = new Fragment.SavedState[this.mSavedState.size()];
            this.mSavedState.toArray((T[])object);
            bundle.putParcelableArray("states", (Parcelable[])object);
        }
        object = bundle;
        for (int i2 = 0; i2 < this.mFragments.size(); ++i2) {
            Fragment fragment = this.mFragments.get(i2);
            bundle = object;
            if (fragment != null) {
                bundle = object;
                if (fragment.isAdded()) {
                    bundle = object;
                    if (object == null) {
                        bundle = new Bundle();
                    }
                    object = "f" + i2;
                    this.mFragmentManager.putFragment(bundle, (String)object, fragment);
                }
            }
            object = bundle;
        }
        return object;
    }

    @Override
    public void setPrimaryItem(ViewGroup viewGroup, int n2, Object object) {
        viewGroup = (Fragment)object;
        if (viewGroup != this.mCurrentPrimaryItem) {
            if (this.mCurrentPrimaryItem != null) {
                FragmentCompat.setMenuVisibility(this.mCurrentPrimaryItem, false);
                FragmentCompat.setUserVisibleHint(this.mCurrentPrimaryItem, false);
            }
            if (viewGroup != null) {
                FragmentCompat.setMenuVisibility((Fragment)viewGroup, true);
                FragmentCompat.setUserVisibleHint((Fragment)viewGroup, true);
            }
            this.mCurrentPrimaryItem = viewGroup;
        }
    }

    @Override
    public void startUpdate(ViewGroup viewGroup) {
    }
}

