/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SnackbarManager;
import android.support.design.widget.SwipeDismissBehavior;
import android.support.design.widget.ThemeUtils;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Snackbar {
    static final int ANIMATION_DURATION = 250;
    static final int ANIMATION_FADE_DURATION = 180;
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_LONG = 0;
    public static final int LENGTH_SHORT = -1;
    private static final int MSG_DISMISS = 1;
    private static final int MSG_SHOW = 0;
    private static final Handler sHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return false;
                }
                case 0: {
                    ((Snackbar)message.obj).showView();
                    return true;
                }
                case 1: 
            }
            ((Snackbar)message.obj).hideView(message.arg1);
            return true;
        }
    });
    private final AccessibilityManager mAccessibilityManager;
    private Callback mCallback;
    private final Context mContext;
    private int mDuration;
    private final SnackbarManager.Callback mManagerCallback = new SnackbarManager.Callback(){

        @Override
        public void dismiss(int n2) {
            sHandler.sendMessage(sHandler.obtainMessage(1, n2, 0, (Object)Snackbar.this));
        }

        @Override
        public void show() {
            sHandler.sendMessage(sHandler.obtainMessage(0, (Object)Snackbar.this));
        }
    };
    private final ViewGroup mTargetParent;
    private final SnackbarLayout mView;

    private Snackbar(ViewGroup viewGroup) {
        this.mTargetParent = viewGroup;
        this.mContext = viewGroup.getContext();
        ThemeUtils.checkAppCompatTheme(this.mContext);
        this.mView = (SnackbarLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.design_layout_snackbar, this.mTargetParent, false);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void animateViewIn() {
        if (Build.VERSION.SDK_INT >= 14) {
            ViewCompat.setTranslationY((View)this.mView, this.mView.getHeight());
            ViewCompat.animate((View)this.mView).translationY(0.0f).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener(new ViewPropertyAnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(View view) {
                    Snackbar.this.onViewShown();
                }

                @Override
                public void onAnimationStart(View view) {
                    Snackbar.this.mView.animateChildrenIn(70, 180);
                }
            }).start();
            return;
        }
        Animation animation = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_snackbar_in);
        animation.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animation.setDuration(250L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                Snackbar.this.onViewShown();
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.mView.startAnimation(animation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void animateViewOut(final int n2) {
        if (Build.VERSION.SDK_INT >= 14) {
            ViewCompat.animate((View)this.mView).translationY(this.mView.getHeight()).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener(new ViewPropertyAnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(View view) {
                    Snackbar.this.onViewHidden(n2);
                }

                @Override
                public void onAnimationStart(View view) {
                    Snackbar.this.mView.animateChildrenOut(0, 180);
                }
            }).start();
            return;
        }
        Animation animation = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.design_snackbar_out);
        animation.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        animation.setDuration(250L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                Snackbar.this.onViewHidden(n2);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.mView.startAnimation(animation);
    }

    private void dispatchDismiss(int n2) {
        SnackbarManager.getInstance().dismiss(this.mManagerCallback, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ViewGroup findSuitableParent(View view) {
        View view2;
        View view3 = null;
        View view4 = view;
        do {
            if (view4 instanceof CoordinatorLayout) {
                return (ViewGroup)view4;
            }
            view = view3;
            if (view4 instanceof FrameLayout) {
                if (view4.getId() == 0x1020002) {
                    return (ViewGroup)view4;
                }
                view = (ViewGroup)view4;
            }
            view2 = view4;
            if (view4 != null && !((view2 = view4.getParent()) instanceof View)) {
                view2 = null;
            }
            view4 = view2;
            view3 = view;
        } while (view2 != null);
        return view;
    }

    @NonNull
    public static Snackbar make(@NonNull View view, @StringRes int n2, int n3) {
        return Snackbar.make(view, view.getResources().getText(n2), n3);
    }

    @NonNull
    public static Snackbar make(@NonNull View object, @NonNull CharSequence charSequence, int n2) {
        object = new Snackbar(Snackbar.findSuitableParent((View)object));
        ((Snackbar)object).setText(charSequence);
        ((Snackbar)object).setDuration(n2);
        return object;
    }

    private void onViewHidden(int n2) {
        ViewParent viewParent;
        SnackbarManager.getInstance().onDismissed(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onDismissed(this, n2);
        }
        if ((viewParent = this.mView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.mView);
        }
    }

    private void onViewShown() {
        SnackbarManager.getInstance().onShown(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onShown(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldAnimate() {
        if (this.mAccessibilityManager.isEnabled()) return false;
        return true;
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    public int getDuration() {
        return this.mDuration;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void hideView(int n2) {
        if (this.shouldAnimate() && this.mView.getVisibility() == 0) {
            this.animateViewOut(n2);
            return;
        }
        this.onViewHidden(n2);
    }

    public boolean isShown() {
        return SnackbarManager.getInstance().isCurrent(this.mManagerCallback);
    }

    public boolean isShownOrQueued() {
        return SnackbarManager.getInstance().isCurrentOrNext(this.mManagerCallback);
    }

    @NonNull
    public Snackbar setAction(@StringRes int n2, View.OnClickListener onClickListener) {
        return this.setAction(this.mContext.getText(n2), onClickListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Snackbar setAction(CharSequence charSequence, final View.OnClickListener onClickListener) {
        Button button = this.mView.getActionView();
        if (TextUtils.isEmpty((CharSequence)charSequence) || onClickListener == null) {
            button.setVisibility(8);
            button.setOnClickListener(null);
            return this;
        }
        button.setVisibility(0);
        button.setText(charSequence);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                onClickListener.onClick(view);
                Snackbar.this.dispatchDismiss(1);
            }
        });
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(@ColorInt int n2) {
        this.mView.getActionView().setTextColor(n2);
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(ColorStateList colorStateList) {
        this.mView.getActionView().setTextColor(colorStateList);
        return this;
    }

    @NonNull
    public Snackbar setCallback(Callback callback) {
        this.mCallback = callback;
        return this;
    }

    @NonNull
    public Snackbar setDuration(int n2) {
        this.mDuration = n2;
        return this;
    }

    @NonNull
    public Snackbar setText(@StringRes int n2) {
        return this.setText(this.mContext.getText(n2));
    }

    @NonNull
    public Snackbar setText(@NonNull CharSequence charSequence) {
        this.mView.getMessageView().setText(charSequence);
        return this;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.mDuration, this.mManagerCallback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void showView() {
        if (this.mView.getParent() == null) {
            ViewGroup.LayoutParams layoutParams = this.mView.getLayoutParams();
            if (layoutParams instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior = new Behavior();
                behavior.setStartAlphaSwipeDistance(0.1f);
                behavior.setEndAlphaSwipeDistance(0.6f);
                behavior.setSwipeDirection(0);
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    @Override
                    public void onDismiss(View view) {
                        view.setVisibility(8);
                        Snackbar.this.dispatchDismiss(0);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void onDragStateChanged(int n2) {
                        switch (n2) {
                            case 1: 
                            case 2: {
                                SnackbarManager.getInstance().cancelTimeout(Snackbar.this.mManagerCallback);
                            }
                            default: {
                                return;
                            }
                            case 0: 
                        }
                        SnackbarManager.getInstance().restoreTimeout(Snackbar.this.mManagerCallback);
                    }
                });
                ((CoordinatorLayout.LayoutParams)layoutParams).setBehavior(behavior);
            }
            this.mTargetParent.addView((View)this.mView);
        }
        this.mView.setOnAttachStateChangeListener(new SnackbarLayout.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View view) {
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                if (Snackbar.this.isShownOrQueued()) {
                    sHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Snackbar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)this.mView)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
                return;
            }
            this.onViewShown();
            return;
        }
        this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onLayoutChange(View view, int n2, int n3, int n4, int n5) {
                Snackbar.this.mView.setOnLayoutChangeListener(null);
                if (Snackbar.this.shouldAnimate()) {
                    Snackbar.this.animateViewIn();
                    return;
                }
                Snackbar.this.onViewShown();
            }
        });
    }

    final class Behavior
    extends SwipeDismissBehavior<SnackbarLayout> {
        Behavior() {
        }

        @Override
        public boolean canSwipeDismissView(View view) {
            return view instanceof SnackbarLayout;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, SnackbarLayout snackbarLayout, MotionEvent motionEvent) {
            if (!coordinatorLayout.isPointInChildBounds((View)snackbarLayout, (int)motionEvent.getX(), (int)motionEvent.getY())) return super.onInterceptTouchEvent(coordinatorLayout, snackbarLayout, motionEvent);
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    SnackbarManager.getInstance().cancelTimeout(Snackbar.this.mManagerCallback);
                }
                default: {
                    return super.onInterceptTouchEvent(coordinatorLayout, snackbarLayout, motionEvent);
                }
                case 1: 
                case 3: 
            }
            SnackbarManager.getInstance().restoreTimeout(Snackbar.this.mManagerCallback);
            return super.onInterceptTouchEvent(coordinatorLayout, snackbarLayout, motionEvent);
        }
    }

    public static abstract class Callback {
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_TIMEOUT = 2;

        public void onDismissed(Snackbar snackbar, int n2) {
        }

        public void onShown(Snackbar snackbar) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DismissEvent {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    public static class SnackbarLayout
    extends LinearLayout {
        private Button mActionView;
        private int mMaxInlineActionWidth;
        private int mMaxWidth;
        private TextView mMessageView;
        private OnAttachStateChangeListener mOnAttachStateChangeListener;
        private OnLayoutChangeListener mOnLayoutChangeListener;

        public SnackbarLayout(Context context) {
            this(context, null);
        }

        public SnackbarLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.SnackbarLayout);
            this.mMaxWidth = attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
            this.mMaxInlineActionWidth = attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
            if (attributeSet.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, attributeSet.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            attributeSet.recycle();
            this.setClickable(true);
            LayoutInflater.from((Context)context).inflate(R.layout.design_layout_snackbar_include, (ViewGroup)this);
            ViewCompat.setAccessibilityLiveRegion((View)this, 1);
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void updateTopBottomPadding(View view, int n2, int n3) {
            if (ViewCompat.isPaddingRelative(view)) {
                ViewCompat.setPaddingRelative(view, ViewCompat.getPaddingStart(view), n2, ViewCompat.getPaddingEnd(view), n3);
                return;
            }
            view.setPadding(view.getPaddingLeft(), n2, view.getPaddingRight(), n3);
        }

        private boolean updateViewsWithinLayout(int n2, int n3, int n4) {
            boolean bl2 = false;
            if (n2 != this.getOrientation()) {
                this.setOrientation(n2);
                bl2 = true;
            }
            if (this.mMessageView.getPaddingTop() != n3 || this.mMessageView.getPaddingBottom() != n4) {
                SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, n3, n4);
                bl2 = true;
            }
            return bl2;
        }

        void animateChildrenIn(int n2, int n3) {
            ViewCompat.setAlpha((View)this.mMessageView, 0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration(n3).setStartDelay(n2).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, 0.0f);
                ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration(n3).setStartDelay(n2).start();
            }
        }

        void animateChildrenOut(int n2, int n3) {
            ViewCompat.setAlpha((View)this.mMessageView, 1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration(n3).setStartDelay(n2).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, 1.0f);
                ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration(n3).setStartDelay(n2).start();
            }
        }

        Button getActionView() {
            return this.mActionView;
        }

        TextView getMessageView() {
            return this.mMessageView;
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
            this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
        }

        protected void onLayout(boolean bl2, int n2, int n3, int n4, int n5) {
            super.onLayout(bl2, n2, n3, n4, n5);
            if (this.mOnLayoutChangeListener != null) {
                this.mOnLayoutChangeListener.onLayoutChange((View)this, n2, n3, n4, n5);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onMeasure(int n2, int n3) {
            super.onMeasure(n2, n3);
            int n4 = n2;
            if (this.mMaxWidth > 0) {
                n4 = n2;
                if (this.getMeasuredWidth() > this.mMaxWidth) {
                    n4 = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
                    super.onMeasure(n4, n3);
                }
            }
            int n5 = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
            int n6 = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
            n2 = this.mMessageView.getLayout().getLineCount() > 1 ? 1 : 0;
            if (n2 != 0 && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
                if (!this.updateViewsWithinLayout(1, n5, n5 - n6)) return;
                n2 = 1;
            } else {
                n2 = n2 != 0 ? n5 : n6;
                if (!this.updateViewsWithinLayout(0, n2, n2)) return;
                n2 = 1;
            }
            if (n2 == 0) return;
            super.onMeasure(n4, n3);
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener onAttachStateChangeListener) {
            this.mOnAttachStateChangeListener = onAttachStateChangeListener;
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.mOnLayoutChangeListener = onLayoutChangeListener;
        }

        static interface OnAttachStateChangeListener {
            public void onViewAttachedToWindow(View var1);

            public void onViewDetachedFromWindow(View var1);
        }

        static interface OnLayoutChangeListener {
            public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
        }
    }
}

