/*
 * Decompiled with CFR 0.152.
 */
package net.xiaomiren.keysotreinfo;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class KeystoreInfoForm
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField tfKeystoreFile;
    private JTextField tfResult;
    private JLabel lblKeystorePassword;
    private JLabel lblKeyPassword;
    private JPasswordField tfKeystorePassword;
    private JPasswordField tfKeyPassword;
    private JButton btnShowInfo;
    private boolean isDoverify;
    private String keyAlias;

    public KeystoreInfoForm() {
        this.setTitle("Keystore Info-by Mandarava");
        this.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        panel.setLocation(0, 0);
        panel.setSize(280, 100);
        panel.setLayout(new FlowLayout());
        this.add(panel);
        this.tfKeystoreFile = new JTextField(32);
        this.tfKeystoreFile.setEditable(true);
        this.tfKeystoreFile.setText("type keystore filepath");
        this.tfKeystoreFile.setBackground(Color.WHITE);
        panel.add(this.tfKeystoreFile);
        this.lblKeystorePassword = new JLabel("keystore Password:");
        panel.add(this.lblKeystorePassword);
        this.tfKeystorePassword = new JPasswordField(16);
        this.tfKeystorePassword.setEditable(true);
        this.tfKeystorePassword.setBackground(Color.WHITE);
        panel.add(this.tfKeystorePassword);
        this.lblKeyPassword = new JLabel("key Password:");
        panel.add(this.lblKeyPassword);
        this.tfKeyPassword = new JPasswordField(16);
        this.tfKeyPassword.setEditable(true);
        this.tfKeyPassword.setBackground(Color.WHITE);
        panel.add(this.tfKeyPassword);
        this.tfResult = new JTextField(32);
        this.tfResult.setEditable(true);
        this.tfResult.setBackground(Color.WHITE);
        panel.add(this.tfResult);
        this.btnShowInfo = new JButton("Show Info");
        this.btnShowInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String keystoreFile = KeystoreInfoForm.this.tfKeystoreFile.getText();
                char[] keystorePassword = KeystoreInfoForm.this.tfKeystorePassword.getPassword();
                char[] keyPassword = KeystoreInfoForm.this.tfKeyPassword.getPassword();
                String result = KeystoreInfoForm.this.getKeystoreInfo(keystoreFile, keystorePassword, keyPassword);
                KeystoreInfoForm.this.tfResult.setText(result);
            }
        });
        this.btnShowInfo.setSize(120, 30);
        panel.add(this.btnShowInfo);
    }

    public void setConfig(String keystoreFile, String keystorePassword, String keyAlias, String keyPassword) {
        this.tfKeystoreFile.setText(keystoreFile);
        this.tfKeystorePassword.setText(keystorePassword);
        this.tfKeyPassword.setText(keyPassword);
        this.keyAlias = keyAlias;
        this.isDoverify = true;
        this.setTitle("Keystore Verify-by Mandarava");
    }

    public void performShowInfoClick() {
        this.btnShowInfo.doClick();
    }

    private String getKeystoreInfo(String keystoreFile, char[] keystorePassword, char[] keyPassword) {
        String myerr = "";
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(new FileInputStream(keystoreFile), keystorePassword);
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keystore.getCertificate(alias).getType().equals("X.509")) continue;
                try {
                    keystore.getKey(alias, keyPassword);
                }
                catch (Exception e) {
                    if (this.isDoverify) {
                        myerr = "\u9a8c\u8bc1\u5931\u8d25\uff01";
                    }
                    myerr = String.valueOf(myerr) + "Key Password\u9519\u8bef\uff1a" + e.getMessage();
                    break;
                }
                String inf = "";
                inf = this.isDoverify ? (this.keyAlias.equalsIgnoreCase(alias) ? "\u9a8c\u8bc1\u6210\u529f\uff01" : "\u9a8c\u8bc1\u5931\u8d25\uff01\u522b\u540d\u9519\u8bef\u3002") : "\u522b\u540d:" + alias;
                return String.valueOf(inf) + " \u8fc7\u671f\u65f6\u95f4:" + this.dateToString(((X509Certificate)keystore.getCertificate(alias)).getNotAfter());
            }
        }
        catch (Exception e) {
            if (this.isDoverify) {
                myerr = "\u9a8c\u8bc1\u5931\u8d25\uff01";
            }
            myerr = String.valueOf(myerr) + "Keystore Password\u9519\u8bef\uff1a" + e.getMessage();
        }
        return myerr;
    }

    private String dateToString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return fmt.format(date);
    }
}

