/*
 * Decompiled with CFR 0.152.
 */
package com.wjdiankong.parseresource.type;

import com.wjdiankong.parseresource.ParseResourceUtils;

public class ResValue {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FRACTION = 6;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_DIP = 1;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public short size;
    public byte res0;
    public byte dataType;
    public int data;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    public int getSize() {
        return 8;
    }

    public String getTypeStr() {
        switch (this.dataType) {
            case 0: {
                return "TYPE_NULL";
            }
            case 1: {
                return "TYPE_REFERENCE";
            }
            case 2: {
                return "TYPE_ATTRIBUTE";
            }
            case 3: {
                return "TYPE_STRING";
            }
            case 4: {
                return "TYPE_FLOAT";
            }
            case 5: {
                return "TYPE_DIMENSION";
            }
            case 6: {
                return "TYPE_FRACTION";
            }
            case 16: {
                return "TYPE_FIRST_INT";
            }
            case 17: {
                return "TYPE_INT_HEX";
            }
            case 18: {
                return "TYPE_INT_BOOLEAN";
            }
            case 28: {
                return "TYPE_FIRST_COLOR_INT";
            }
            case 29: {
                return "TYPE_INT_COLOR_RGB8";
            }
            case 30: {
                return "TYPE_INT_COLOR_ARGB4";
            }
            case 31: {
                return "TYPE_INT_COLOR_RGB4";
            }
        }
        return "";
    }

    public String getDataStr() {
        if (this.dataType == 3) {
            return ParseResourceUtils.getResString(this.data);
        }
        if (this.dataType == 2) {
            return String.format("?%s%08X", ResValue.getPackage(this.data), this.data);
        }
        if (this.dataType == 1) {
            return String.format("@%s%08X", ResValue.getPackage(this.data), this.data);
        }
        if (this.dataType == 4) {
            return String.valueOf(Float.intBitsToFloat(this.data));
        }
        if (this.dataType == 17) {
            return String.format("0x%08X", this.data);
        }
        if (this.dataType == 18) {
            return this.data != 0 ? "true" : "false";
        }
        if (this.dataType == 5) {
            return Float.toString(ResValue.complexToFloat(this.data)) + DIMENSION_UNITS[this.data & 0xF];
        }
        if (this.dataType == 6) {
            return Float.toString(ResValue.complexToFloat(this.data)) + FRACTION_UNITS[this.data & 0xF];
        }
        if (this.dataType >= 28 && this.dataType <= 31) {
            return String.format("#%08X", this.data);
        }
        if (this.dataType >= 16 && this.dataType <= 31) {
            return String.valueOf(this.data);
        }
        return String.format("<0x%X, type 0x%02X>", this.data, this.dataType);
    }

    private static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    public String toString() {
        return "size:" + this.size + ",res0:" + this.res0 + ",dataType:" + this.getTypeStr() + ",data:" + this.getDataStr();
    }
}

