/*
 * Decompiled with CFR 0.152.
 */
package com.wjdiankong.parseresource;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Utils {
    public static int byte2int(byte[] res) {
        int targets = res[0] & 0xFF | res[1] << 8 & 0xFF00 | res[2] << 24 >>> 8 | res[3] << 24;
        return targets;
    }

    public static byte[] int2Byte(int integer) {
        int byteNum = (40 - Integer.numberOfLeadingZeros(integer < 0 ? ~integer : integer)) / 8;
        byte[] byteArray = new byte[4];
        for (int n = 0; n < byteNum; ++n) {
            byteArray[3 - n] = (byte)(integer >>> n * 8);
        }
        return byteArray;
    }

    public static short byte2Short(byte[] b) {
        short s = 0;
        short s0 = (short)(b[0] & 0xFF);
        short s1 = (short)(b[1] & 0xFF);
        s1 = (short)(s1 << 8);
        s = (short)(s0 | s1);
        return s;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv + " ");
        }
        return stringBuilder.toString();
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static byte[] copyByte(byte[] src, int start, int len) {
        if (src == null) {
            return null;
        }
        if (start > src.length) {
            return null;
        }
        if (start + len > src.length) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        byte[] resultByte = new byte[len];
        for (int i = 0; i < len; ++i) {
            resultByte[i] = src[i + start];
        }
        return resultByte;
    }

    public static byte[] reverseBytes(byte[] bytess) {
        int i;
        byte[] bytes = new byte[bytess.length];
        for (i = 0; i < bytess.length; ++i) {
            bytes[i] = bytess[i];
        }
        if (bytes == null || bytes.length % 2 != 0) {
            return bytes;
        }
        int len = bytes.length;
        for (i = 0; i < len / 2; ++i) {
            byte tmp = bytes[i];
            bytes[i] = bytes[len - i - 1];
            bytes[len - i - 1] = tmp;
        }
        return bytes;
    }

    public static String filterStringNull(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        byte[] strByte = str.getBytes();
        ArrayList<Byte> newByte = new ArrayList<Byte>();
        for (int i = 0; i < strByte.length; ++i) {
            if (strByte[i] == 0) continue;
            newByte.add(strByte[i]);
        }
        byte[] newByteAry = new byte[newByte.size()];
        for (int i = 0; i < newByteAry.length; ++i) {
            newByteAry[i] = (Byte)newByte.get(i);
        }
        return new String(newByteAry);
    }

    public static String getStringFromByteAry(byte[] srcByte, int start) {
        if (srcByte == null) {
            return "";
        }
        if (start < 0) {
            return "";
        }
        if (start >= srcByte.length) {
            return "";
        }
        byte val = srcByte[start];
        int i = 1;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (val != 0) {
            byteList.add(srcByte[start + i]);
            val = srcByte[start + i];
            ++i;
        }
        byte[] valAry = new byte[byteList.size()];
        for (int j = 0; j < byteList.size(); ++j) {
            valAry[j] = (Byte)byteList.get(j);
        }
        try {
            return new String(valAry, "UTF-8");
        }
        catch (Exception e) {
            System.out.println("encode error:" + e.toString());
            return "";
        }
    }
}

