/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.admin.DevicePolicyManager;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.location.Location;
import android.media.CamcorderProfile;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.wuba.recorder.c;
import com.wuba.recorder.controller.VideoRecordSize;
import com.wuba.recorder.e;
import com.wuba.recorder.f;
import com.wuba.recorder.h;
import com.wuba.recorder.o;
import com.wuba.recorder.t;
import com.wuba.recorder.u;
import com.wuba.recorder.util.AlertDialogFragment;
import com.wuba.recorder.util.LogUtils;
import com.wuba.video.R;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Util {
    public static final String ACTION_NEW_PICTURE = "android.hardware.action.NEW_PICTURE";
    public static final String ACTION_NEW_VIDEO = "android.hardware.action.NEW_VIDEO";
    private static final String AUTO_EXPOSURE_LOCK_SUPPORTED = "auto-exposure-lock-supported";
    private static final String AUTO_WHITE_BALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
    private static final String EXTRAS_CAMERA_FACING = "android.intent.extras.CAMERA_FACING";
    public static final String FALSE = "false";
    public static final String FOCUS_MODE_CONTINUOUS_PICTURE = "continuous-picture";
    public static final int ORIENTATION_HYSTERESIS = 5;
    public static final String RECORDING_HINT = "recording-hint";
    public static final String REVIEW_ACTION = "com.android.camera.action.REVIEW";
    public static final String SCENE_MODE_HDR = "hdr";
    private static final String TAG = "Util";
    public static final String TRUE = "true";
    private static final String VIDEO_SNAPSHOT_SUPPORTED = "video-snapshot-supported";
    private static a sImageFileNamer;
    private static int[] sLocation;
    private static float sPixelDensity;

    static {
        sPixelDensity = 1.0f;
        sLocation = new int[2];
    }

    private Util() {
    }

    public static void Assert(boolean bl) {
        if (!bl) {
            throw new AssertionError();
        }
    }

    public static void broadcastNewPicture(Context context, Uri uri) {
        context.sendBroadcast(new Intent(ACTION_NEW_PICTURE, uri));
        context.sendBroadcast(new Intent("com.android.camera.NEW_PICTURE", uri));
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int clamp(int n2, int n3, int n4) {
        if (n2 > n4) {
            return n4;
        }
        if (n2 >= n3) return n2;
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int computeInitialSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4;
        double d2 = options.outWidth;
        double d3 = options.outHeight;
        int n5 = n2 < 0 ? 128 : (int)Math.min(Math.floor(d2 / (double)n2), Math.floor(d3 / (double)n2));
        if (n5 < (n4 = n3 < 0 ? 1 : (int)Math.ceil(Math.sqrt(d2 * d3 / (double)n3)))) {
            return n4;
        }
        if (n3 < 0 && n2 < 0) {
            return 1;
        }
        if (n2 < 0) return n4;
        return n5;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4 = Util.computeInitialSampleSize(options, n2, n3);
        if (n4 <= 8) {
            n2 = 1;
            while (true) {
                n3 = n2;
                if (n2 < n4) {
                    n2 <<= 1;
                    continue;
                }
                break;
            }
        } else {
            n3 = (n4 + 7) / 8 * 8;
        }
        return n3;
    }

    public static float distance(float f2, float f3, float f4, float f5) {
        return (float)Math.sqrt((f2 -= f4) * f2 + (f3 -= f5) * f3);
    }

    public static int dpToPixel(int n2) {
        return Math.round(sPixelDensity * (float)n2);
    }

    public static void dumpParameters(Camera.Parameters object) {
        object = new StringTokenizer(object.flatten(), ";");
        LogUtils.d(TAG, "Dump all camera parameters:");
        while (((StringTokenizer)object).hasMoreElements()) {
            LogUtils.d(TAG, ((StringTokenizer)object).nextToken());
        }
    }

    public static void dumpRect(RectF rectF, String string2) {
        LogUtils.v(TAG, string2 + "=(" + rectF.left + "," + rectF.top + "," + rectF.right + "," + rectF.bottom + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Object object, Object object2) {
        if (object == object2) return true;
        if (object == null) {
            return false;
        }
        if (!object.equals(object2)) return false;
        return true;
    }

    public static void fadeIn(View view) {
        Util.fadeIn(view, 0.0f, 1.0f, 400L);
        view.setEnabled(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fadeIn(View view, float f2, float f3, long l2) {
        if (view.getVisibility() == 0) {
            return;
        }
        view.setVisibility(0);
        AlphaAnimation alphaAnimation = new AlphaAnimation(f2, f3);
        alphaAnimation.setDuration(l2);
        view.startAnimation((Animation)alphaAnimation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fadeOut(View view) {
        if (view.getVisibility() != 0) {
            return;
        }
        view.setEnabled(false);
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setDuration(400L);
        view.startAnimation((Animation)alphaAnimation);
        view.setVisibility(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getCameraFacingIntentExtras(Activity activity) {
        int n2;
        int n3 = -1;
        int n4 = activity.getIntent().getIntExtra(EXTRAS_CAMERA_FACING, -1);
        if (Util.isFrontCameraIntent(n4)) {
            n2 = f.S().V();
            if (n2 == -1) return -1;
            return n2;
        }
        n2 = n3;
        if (!Util.isBackCameraIntent(n4)) return n2;
        n4 = f.S().U();
        n2 = n3;
        if (n4 == -1) return n2;
        return n4;
    }

    public static int getCameraOrientation(int n2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo.orientation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=13)
    private static Point getDefaultDisplaySize(Activity activity, Point point) {
        activity = activity.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            activity.getSize(point);
            return point;
        }
        point.set(activity.getWidth(), activity.getHeight());
        return point;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getDisplayOrientation(int n2, int n3) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n3, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing != 1) return (cameraInfo.orientation - n2 + 360) % 360;
        return (360 - (cameraInfo.orientation + n2) % 360) % 360;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public static int getDisplayRotation(Activity activity) {
        int n2;
        int n3 = n2 = 0;
        int n4 = Integer.MIN_VALUE;
        block6: do {
            switch (n4 == Integer.MIN_VALUE ? activity.getWindowManager().getDefaultDisplay().getRotation() : n4) {
                default: {
                    n3 = n2;
                    n4 = 0;
                    continue block6;
                }
                case 1: {
                    n3 = 90;
                    n4 = 0;
                    continue block6;
                }
                case 2: {
                    n3 = 180;
                }
                case 0: {
                    return n3;
                }
                case 3: 
            }
            return 270;
        } while (true);
        return 270;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getJpegRotation(int n2, int n3) {
        int n4 = 0;
        if (n3 == -1) return n4;
        Camera.CameraInfo cameraInfo = f.S().T()[n2];
        if (cameraInfo.facing != 1) return (cameraInfo.orientation + n3) % 360;
        return (cameraInfo.orientation - n3 + 360) % 360;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getOptimalPreviewFps(List<int[]> object) {
        if (object == null) return null;
        if (object.isEmpty()) {
            return null;
        }
        int[] nArray = new int[]{((int[])object.get(0))[0], ((int[])object.get(0))[1]};
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (int[])iterator.next();
            if (object[1] <= nArray[1] || object[0] <= nArray[0]) continue;
            nArray[0] = (int)object[0];
            nArray[1] = (int)object[1];
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Camera.Size getOptimalPreviewSize(Activity activity, List<Camera.Size> size, double d2) {
        if (size == null) {
            return null;
        }
        Activity activity2 = null;
        double d3 = Double.MAX_VALUE;
        activity = Util.getDefaultDisplaySize(activity, new Point());
        int n2 = Math.min(activity.x, activity.y);
        Iterator iterator = size.iterator();
        activity = activity2;
        while (iterator.hasNext()) {
            activity2 = (Camera.Size)iterator.next();
            if (Math.abs((double)activity2.width / (double)activity2.height - d2) > 0.001 || !((double)Math.abs(activity2.height - n2) < d3)) continue;
            d3 = Math.abs(activity2.height - n2);
            activity = activity2;
        }
        activity2 = activity;
        if (activity != null) return activity2;
        LogUtils.w(TAG, "No preview size match the aspect ratio");
        d2 = Double.MAX_VALUE;
        iterator = size.iterator();
        while (true) {
            activity2 = activity;
            if (!iterator.hasNext()) return activity2;
            size = (Camera.Size)iterator.next();
            if (!((double)Math.abs(size.height - n2) < d2)) continue;
            d2 = Math.abs(size.height - n2);
            activity = size;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Camera.Size getOptimalPreviewSizeMars(Activity activity, List<Camera.Size> size, VideoRecordSize videoRecordSize) {
        Iterator iterator = size.iterator();
        while (iterator.hasNext()) {
            Camera.Size size2 = (Camera.Size)iterator.next();
            if (size2.width >= 480 && size2.height >= 480 && size2.width != size2.height) continue;
            iterator.remove();
        }
        LogUtils.d("NYF", "the size is " + size.isEmpty());
        if (size.isEmpty()) {
            size = Util.getOptimalPreviewSize(activity, (List<Camera.Size>)size, 1.3333333333333333);
        } else {
            activity = (Camera.Size)size.get(0);
            iterator = size.iterator();
            while (true) {
                size = activity;
                if (!iterator.hasNext()) break;
                size = (Camera.Size)iterator.next();
                if (size.width * size.height >= activity.width * activity.height || videoRecordSize == null || Math.min(size.width, size.height) < Math.min(videoRecordSize.width, videoRecordSize.height)) continue;
                activity = size;
            }
        }
        if (size != null) {
            LogUtils.d("fucktest", "Mars optimalSize.width=" + size.width + " optimalSize.height=" + size.height);
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Camera.Size getOptimalPreviewSizeMercury(Activity activity, List<Camera.Size> list, Camera.Size object, int n2) {
        if (list == null) return null;
        if (list.isEmpty()) {
            return null;
        }
        CamcorderProfile camcorderProfile = Util.getOptimalProfile(n2);
        Camera.Size size = list.get(0);
        if (Build.MODEL.equals("X909") || Build.MODEL.equals("x909")) {
            size.width = camcorderProfile.videoFrameWidth;
            size.height = camcorderProfile.videoFrameHeight;
            activity = size;
        } else if (o.aa().ad()) {
            size.width = camcorderProfile.videoFrameWidth;
            size.height = camcorderProfile.videoFrameHeight;
            activity = size;
        } else {
            if (object != null) {
                int n3 = ((Camera.Size)object).width;
                n2 = ((Camera.Size)object).height;
                object = list.iterator();
                while (object.hasNext()) {
                    size = (Camera.Size)object.next();
                    int n4 = size.width;
                    if (size.height * n4 <= n2 * n3) continue;
                    object.remove();
                }
            }
            activity = Util.getOptimalPreviewSize(activity, list, (double)camcorderProfile.videoFrameWidth / (double)camcorderProfile.videoFrameHeight);
        }
        LogUtils.d("fucktest", "Mercury optimalSize.width=" + activity.width + " optimalSize.height=" + activity.height);
        return activity;
    }

    /*
     * Unable to fully structure code
     */
    public static CamcorderProfile getOptimalProfile(int var0) {
        block3: {
            var1_1 = 4;
            if (Build.VERSION.SDK_INT < 11) break block3;
            if (CamcorderProfile.hasProfile((int)var0, (int)4)) lbl-1000:
            // 3 sources

            {
                while (true) {
                    var2_2 = CamcorderProfile.get((int)var0, (int)var1_1);
                    if (var2_2 != null) {
                        var2_2.videoBitRate = 1200000;
                    }
                    return var2_2;
                }
            }
            if (!CamcorderProfile.hasProfile((int)var0, (int)5)) break block3;
            var1_1 = 5;
            ** GOTO lbl-1000
        }
        var1_1 = 0;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Camera.Size getOptimalVideoSnapshotPictureSize(List<Camera.Size> size, double d2) {
        Object object = null;
        Object object2 = null;
        if (size != null) {
            for (Object object3 : size) {
                if (Math.abs((double)((Camera.Size)object3).width / (double)((Camera.Size)object3).height - d2) > 0.001) continue;
                object2 = object3;
                if (object != null) {
                    object2 = ((Camera.Size)object3).width > ((Camera.Size)object).width ? object3 : object;
                }
                object = object2;
            }
            object2 = object;
            if (object == null) {
                Object object3;
                LogUtils.w(TAG, "No picture size match the aspect ratio");
                object3 = size.iterator();
                while (true) {
                    object2 = object;
                    if (!object3.hasNext()) break;
                    size = (Camera.Size)object3.next();
                    if (object != null && size.width <= ((Camera.Size)object).width) continue;
                    object = size;
                }
            }
        }
        return object2;
    }

    public static int[] getRelativeLocation(View object, View view) {
        object.getLocationInWindow(sLocation);
        int n2 = sLocation[0];
        int n3 = sLocation[1];
        view.getLocationInWindow(sLocation);
        object = sLocation;
        object[0] = object[0] - n2;
        object = sLocation;
        object[1] = object[1] - n3;
        return sLocation;
    }

    public static void initialize(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        sPixelDensity = displayMetrics.density;
    }

    public static boolean isAutoExposureLockSupported(Camera.Parameters parameters) {
        return TRUE.equals(parameters.get(AUTO_EXPOSURE_LOCK_SUPPORTED));
    }

    public static boolean isAutoWhiteBalanceLockSupported(Camera.Parameters parameters) {
        return TRUE.equals(parameters.get(AUTO_WHITE_BALANCE_LOCK_SUPPORTED));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isBackCameraIntent(int n2) {
        if (n2 != 0) return false;
        return true;
    }

    @TargetApi(value=14)
    public static boolean isFocusAreaSupported(Camera.Parameters parameters) {
        boolean bl;
        boolean bl2 = bl = false;
        if (Build.VERSION.SDK_INT >= 14) {
            bl2 = bl;
            if (parameters.getMaxNumFocusAreas() > 0) {
                bl2 = bl;
                if (Util.isSupported("auto", parameters.getSupportedFocusModes())) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFrontCameraIntent(int n2) {
        boolean bl = true;
        if (n2 != 1) return false;
        return bl;
    }

    @TargetApi(value=14)
    public static boolean isMeteringAreaSupported(Camera.Parameters parameters) {
        boolean bl;
        boolean bl2 = bl = false;
        if (Build.VERSION.SDK_INT >= 14) {
            bl2 = bl;
            if (parameters.getMaxNumMeteringAreas() > 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMmsCapable(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) == null) {
            return false;
        }
        try {
            return (Boolean)TelephonyManager.class.getMethod("isVoiceCapable", new Class[0]).invoke((Object)context, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSupported(String string2, List<String> list) {
        boolean bl = false;
        if (list == null) {
            return bl;
        }
        if (list.indexOf(string2) < 0) return bl;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUriValid(Uri uri, ContentResolver object) {
        boolean bl = false;
        if (uri == null) {
            return bl;
        }
        try {
            object = object.openFileDescriptor(uri, "r");
            if (object == null) {
                object = new StringBuilder();
                LogUtils.e(TAG, ((StringBuilder)object).append("Fail to open URI. URI=").append(uri).toString());
                return bl;
            }
        }
        catch (IOException iOException) {
            return bl;
        }
        object.close();
        return true;
    }

    public static boolean isVideoSnapshotSupported(Camera.Parameters parameters) {
        return TRUE.equals(parameters.get(VIDEO_SNAPSHOT_SUPPORTED));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap makeBitmap(byte[] byArray, int n2) {
        BitmapFactory.Options options;
        block5: {
            Bitmap bitmap;
            Bitmap bitmap2 = null;
            try {
                options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
                bitmap = bitmap2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LogUtils.e(TAG, "Got oom exception ", outOfMemoryError);
                return bitmap2;
            }
            if (options.mCancel) return bitmap;
            bitmap = bitmap2;
            if (options.outWidth == -1) return bitmap;
            if (options.outHeight != -1) break block5;
            return bitmap2;
        }
        options.inSampleSize = Util.computeSampleSize(options, -1, n2);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
    }

    public static int nextPowerOf2(int n2) {
        --n2;
        n2 |= n2 >>> 16;
        n2 |= n2 >>> 8;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 2;
        return (n2 | n2 >>> 1) + 1;
    }

    public static h.b openCamera(Activity object, int n2) throws e, c {
        Util.throwIfCameraDisabled(object);
        try {
            object = f.S().l(n2);
            return object;
        }
        catch (e e2) {
            if ("eng".equals(Build.TYPE)) {
                throw new RuntimeException("openCamera failed", e2);
            }
            throw e2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean pointInView(float f2, float f3, View view) {
        boolean bl = true;
        view.getLocationInWindow(sLocation);
        if (!(f2 >= (float)sLocation[0])) return false;
        if (!(f2 < (float)(sLocation[0] + view.getWidth()))) return false;
        if (!(f3 >= (float)sLocation[1])) return false;
        if (!(f3 < (float)(sLocation[1] + view.getHeight()))) return false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void prepareMatrix(Matrix matrix, boolean bl, int n2, int n3, int n4) {
        float f2 = bl ? -1.0f : 1.0f;
        matrix.setScale(f2, 1.0f);
        matrix.postRotate((float)n2);
        matrix.postScale((float)n3 / 2000.0f, (float)n4 / 2000.0f);
        matrix.postTranslate((float)n3 / 2.0f, (float)n4 / 2.0f);
    }

    public static void rectFToRect(RectF rectF, Rect rect) {
        rect.left = Math.round(rectF.left);
        rect.top = Math.round(rectF.top);
        rect.right = Math.round(rectF.right);
        rect.bottom = Math.round(rectF.bottom);
    }

    public static Bitmap rotate(Bitmap bitmap, int n2) {
        return Util.rotateAndMirror(bitmap, n2, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap rotateAndMirror(Bitmap bitmap, int n2, boolean bl) {
        Bitmap bitmap2;
        Bitmap bitmap3;
        if (n2 == 0) {
            bitmap3 = bitmap;
            if (!bl) return bitmap3;
        }
        bitmap3 = bitmap;
        if (bitmap == null) return bitmap3;
        bitmap3 = new Matrix();
        int n3 = n2;
        if (bl) {
            bitmap3.postScale(-1.0f, 1.0f);
            n3 = (n2 + 360) % 360;
            if (n3 == 0 || n3 == 180) {
                bitmap3.postTranslate((float)bitmap.getWidth(), 0.0f);
            } else {
                if (n3 != 90) {
                    if (n3 != 270) throw new IllegalArgumentException("Invalid degrees=" + n3);
                }
                bitmap3.postTranslate((float)bitmap.getHeight(), 0.0f);
            }
        }
        if (n3 != 0) {
            bitmap3.postRotate((float)n3, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
        }
        try {
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)bitmap3, (boolean)true);
            bitmap3 = bitmap;
            if (bitmap == bitmap2) return bitmap3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            return bitmap;
        }
        {
            bitmap.recycle();
            return bitmap2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int roundOrientation(int n2, int n3) {
        int n4;
        boolean bl = true;
        if (n3 != -1 && Math.min(n4 = Math.abs(n2 - n3), 360 - n4) < 50) {
            bl = false;
        }
        if (!bl) return n3;
        return (n2 + 45) / 90 * 90 % 360;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setGpsParameters(Camera.Parameters parameters, Location location) {
        parameters.removeGpsData();
        parameters.setGpsTimestamp(System.currentTimeMillis() / 1000L);
        if (location == null) return;
        double d2 = location.getLatitude();
        double d3 = location.getLongitude();
        if (d2 == 0.0) {
            if (d3 == 0.0) return;
        }
        boolean bl = true;
        if (!bl) return;
        LogUtils.d(TAG, "Set gps location");
        parameters.setGpsLatitude(d2);
        parameters.setGpsLongitude(d3);
        parameters.setGpsProcessingMethod(location.getProvider().toUpperCase());
        if (location.hasAltitude()) {
            parameters.setGpsAltitude(location.getAltitude());
        } else {
            parameters.setGpsAltitude(0.0);
        }
        if (location.getTime() == 0L) return;
        parameters.setGpsTimestamp(location.getTime() / 1000L);
    }

    public static void showErrorAndFinish(Activity activity, int n2) {
        t t2 = new t(activity);
        TypedValue typedValue = new TypedValue();
        activity.getTheme().resolveAttribute(16843605, typedValue, true);
        new AlertDialogFragment.Builder((FragmentActivity)activity).setCancelable(false).setTitle(R.string.wbvs_camera_error_title).setMessage(n2).setNeutralButton(17039379, (DialogInterface.OnClickListener)t2).setIcon(typedValue.resourceId).show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showErrorAndFinish(Activity activity, String string2) {
        if (activity == null) return;
        if (activity.isFinishing()) {
            return;
        }
        u u2 = new u(activity);
        try {
            TypedValue typedValue = new TypedValue();
            activity.getTheme().resolveAttribute(16843605, typedValue, true);
            if (activity == null) return;
            if (activity.isFinishing()) return;
            AlertDialogFragment.Builder builder = new AlertDialogFragment.Builder((FragmentActivity)activity);
            builder.setCancelable(false).setMessage(string2).setNeutralButton(17039379, (DialogInterface.OnClickListener)u2).setIcon(typedValue.resourceId).show();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @TargetApi(value=14)
    private static void throwIfCameraDisabled(Activity activity) throws c {
        if (Build.VERSION.SDK_INT >= 14 && ((DevicePolicyManager)activity.getSystemService("device_policy")).getCameraDisabled(null)) {
            throw new c();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void viewUri(Uri uri, Context context) {
        if (!Util.isUriValid(uri, context.getContentResolver())) {
            LogUtils.e(TAG, "Uri invalid. uri=" + uri);
            return;
        }
        try {
            Intent intent = new Intent(REVIEW_ACTION, uri);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                context.startActivity(intent);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException2) {
                LogUtils.e(TAG, "review image fail. uri=" + uri, activityNotFoundException2);
                return;
            }
        }
    }

    private static class a {
    }
}

