/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.fileencrypt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final String LINE_SEPARATOR;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";

    static {
        StringWriter stringWriter = new StringWriter(4);
        new PrintWriter(stringWriter).println();
        LINE_SEPARATOR = stringWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Reader reader) {
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Writer writer) {
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        boolean bl = false;
        InputStream inputStream3 = inputStream;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream3 = new BufferedInputStream(inputStream);
        }
        inputStream = inputStream2;
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream3.read();
        while (-1 != n2) {
            if (n2 != inputStream.read()) {
                return bl;
            }
            n2 = inputStream3.read();
        }
        if (inputStream.read() != -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        boolean bl = false;
        Reader reader3 = reader;
        if (!(reader instanceof BufferedReader)) {
            reader3 = new BufferedReader(reader);
        }
        reader = reader2;
        if (!(reader2 instanceof BufferedReader)) {
            reader = new BufferedReader(reader2);
        }
        int n2 = reader3.read();
        while (-1 != n2) {
            if (n2 != reader.read()) {
                return bl;
            }
            n2 = reader3.read();
        }
        if (reader.read() != -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 <= Integer.MAX_VALUE) return (int)l2;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 <= Integer.MAX_VALUE) return (int)l2;
        return -1;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.copy((Reader)new InputStreamReader(inputStream), writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(InputStream inputStream, Writer writer, String string2) throws IOException {
        if (string2 == null) {
            IOUtils.copy(inputStream, writer);
            return;
        }
        IOUtils.copy((Reader)new InputStreamReader(inputStream, string2), writer);
    }

    public static void copy(Reader reader, OutputStream closeable) throws IOException {
        closeable = new OutputStreamWriter((OutputStream)closeable);
        IOUtils.copy(reader, (Writer)closeable);
        ((OutputStreamWriter)closeable).flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(Reader reader, OutputStream closeable, String string2) throws IOException {
        if (string2 == null) {
            IOUtils.copy(reader, (OutputStream)closeable);
            return;
        }
        closeable = new OutputStreamWriter((OutputStream)closeable, string2);
        IOUtils.copy(reader, (Writer)closeable);
        ((OutputStreamWriter)closeable).flush();
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static List readLines(InputStream inputStream) throws IOException {
        return IOUtils.readLines(new InputStreamReader(inputStream));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List readLines(InputStream object, String string2) throws IOException {
        if (string2 != null) return IOUtils.readLines(new InputStreamReader((InputStream)object, string2));
        return IOUtils.readLines((InputStream)object);
    }

    public static List readLines(Reader object) throws IOException {
        BufferedReader bufferedReader = new BufferedReader((Reader)object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = bufferedReader.readLine();
        while (object != null) {
            arrayList.add(object);
            object = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, byteArrayOutputStream, string2);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(String string2) throws IOException {
        return string2.getBytes();
    }

    public static char[] toCharArray(InputStream inputStream) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string2) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, charArrayWriter, string2);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static InputStream toInputStream(String string2) {
        return new ByteArrayInputStream(string2.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream toInputStream(String object, String string2) throws IOException {
        if (string2 != null) {
            object = ((String)object).getBytes(string2);
            return new ByteArrayInputStream((byte[])object);
        }
        object = ((String)object).getBytes();
        return new ByteArrayInputStream((byte[])object);
    }

    public static String toString(InputStream inputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, stringWriter, string2);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray) throws IOException {
        return new String(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(byte[] object, String string2) throws IOException {
        void var0_2;
        void var1_4;
        if (var1_4 == null) {
            String string3 = new String((byte[])object);
            return var0_2;
        }
        String string4 = new String((byte[])object, (String)var1_4);
        return var0_2;
    }

    public static void write(String string2, OutputStream outputStream) throws IOException {
        if (string2 != null) {
            outputStream.write(string2.getBytes());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(String string2, OutputStream outputStream, String string3) throws IOException {
        block4: {
            block3: {
                if (string2 == null) break block3;
                if (string3 != null) break block4;
                IOUtils.write(string2, outputStream);
            }
            return;
        }
        outputStream.write(string2.getBytes(string3));
    }

    public static void write(String string2, Writer writer) throws IOException {
        if (string2 != null) {
            writer.write(string2);
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string2) throws IOException {
        block4: {
            block3: {
                if (stringBuffer == null) break block3;
                if (string2 != null) break block4;
                IOUtils.write(stringBuffer, outputStream);
            }
            return;
        }
        outputStream.write(stringBuffer.toString().getBytes(string2));
    }

    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(byte[] byArray, Writer writer, String string2) throws IOException {
        block4: {
            block3: {
                if (byArray == null) break block3;
                if (string2 != null) break block4;
                IOUtils.write(byArray, writer);
            }
            return;
        }
        writer.write(new String(byArray, string2));
    }

    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(char[] cArray, OutputStream outputStream, String string2) throws IOException {
        block4: {
            block3: {
                if (cArray == null) break block3;
                if (string2 != null) break block4;
                IOUtils.write(cArray, outputStream);
            }
            return;
        }
        outputStream.write(new String(cArray).getBytes(string2));
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection collection, String object, OutputStream outputStream) throws IOException {
        if (collection != null) {
            Iterator iterator;
            String string2 = iterator;
            if (iterator == null) {
                string2 = LINE_SEPARATOR;
            }
            for (Object e2 : collection) {
                void var2_4;
                if (e2 != null) {
                    var2_4.write(e2.toString().getBytes());
                }
                var2_4.write(string2.getBytes());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection iterator, String string2, OutputStream outputStream, String string3) throws IOException {
        void var2_4;
        void var3_5;
        if (var3_5 == null) {
            IOUtils.writeLines(iterator, string2, (OutputStream)var2_4);
            return;
        } else {
            if (iterator == null) return;
            String string4 = string2;
            if (string2 == null) {
                string4 = LINE_SEPARATOR;
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 != null) {
                    var2_4.write(e2.toString().getBytes((String)var3_5));
                }
                var2_4.write(string4.getBytes((String)var3_5));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeLines(Collection collection, String object, Writer writer) throws IOException {
        if (collection != null) {
            Iterator iterator;
            String string2 = iterator;
            if (iterator == null) {
                string2 = LINE_SEPARATOR;
            }
            for (Object e2 : collection) {
                void var2_4;
                if (e2 != null) {
                    var2_4.write(e2.toString());
                }
                var2_4.write(string2);
            }
        }
    }
}

