/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.download;

import android.os.AsyncTask;
import android.os.SystemClock;
import android.text.TextUtils;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.wuba.cache.download.DownloadThreadPoolUtil;
import com.wuba.cache.download.FileDownloadFinishCallBack;
import com.wuba.cache.download.FileEntityHandler;
import com.wuba.cache.download.FileProgressCallBack;
import com.wuba.cache.download.UserStopException;
import com.wuba.recorder.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;

public class HttpFileHandler<T>
extends AsyncTask<Object, Object, Object>
implements FileProgressCallBack {
    private static final String TAG = HttpFileHandler.class.getSimpleName();
    private static final int UPDATE_FAILURE = 3;
    private static final int UPDATE_LOADING = 2;
    private static final int UPDATE_START = 1;
    private static final int UPDATE_SUCCESS = 4;
    private final FileDownloadFinishCallBack<T> callback;
    private final OkHttpClient client;
    private String downloadUrl;
    private int executionCount = 0;
    private boolean isResume = true;
    private final FileEntityHandler mFileEntityHandler = new FileEntityHandler();
    private int mPriority = 5;
    private String targetUri = null;
    private long time;

    public HttpFileHandler(String string2, OkHttpClient okHttpClient, FileDownloadFinishCallBack<T> fileDownloadFinishCallBack, boolean bl) {
        this.downloadUrl = string2;
        this.client = okHttpClient;
        this.callback = fileDownloadFinishCallBack;
        this.isResume = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleResponse(Response response) throws IOException {
        String string2;
        if (response != null && response.isSuccessful()) {
            Object object;
            Object object2 = object = null;
            if (response != null) {
                this.time = SystemClock.uptimeMillis();
                object2 = object;
                if (this.targetUri != null) {
                    object2 = this.mFileEntityHandler.handleEntity(response, this, this.targetUri, this.isResume, 0);
                }
            }
            this.publishProgress(new Object[]{4, object2});
            return;
        }
        String string3 = string2 = "response status error code:" + response.code();
        if (response.code() == 416) {
            string3 = string2;
            if (this.isResume) {
                string3 = string2 + " \n maybe you have download complete.";
            }
        }
        this.publishProgress(new Object[]{3, new IOException(), response.code(), string3});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeRequestWithRetries(Request request) throws IOException {
        Object object = new File(this.targetUri);
        if (this.isResume && this.targetUri != null && ((File)object).isFile() && ((File)object).exists()) {
            ((File)object).length();
        }
        while (true) {
            try {
                if (!this.isCancelled()) {
                    object = this.client.newCall(request).execute();
                    if (!this.isCancelled()) {
                        this.handleResponse((Response)object);
                    }
                }
                return;
            }
            catch (UnknownHostException unknownHostException) {
                this.publishProgress(new Object[]{3, unknownHostException, 0, "unknownHostException\uff1acan't resolve host"});
                return;
            }
            catch (IOException iOException) {
                this.publishProgress(new Object[]{3, iOException, 0, iOException.getMessage()});
                continue;
            }
            catch (NullPointerException nullPointerException) {
                new IOException("NPE in OkHttpClient" + nullPointerException.getMessage());
                continue;
            }
            catch (Exception exception) {
                new IOException("Exception" + exception.getMessage());
                continue;
            }
            catch (UserStopException userStopException) {
                if (userStopException == null) throw new IOException("\u672a\u77e5\u7f51\u7edc\u9519\u8bef");
                throw userStopException;
            }
            break;
        }
    }

    public static HttpFileHandler<File> newInstanceAsyncTask(HttpFileHandler<File> httpFileHandler) {
        return new HttpFileHandler<File>(httpFileHandler.getDownloadUrl(), httpFileHandler.getClient(), httpFileHandler.getCallback(), httpFileHandler.isResume());
    }

    private void setPrority(int n2) {
        this.mPriority = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void callBack(long l2, long l3, boolean bl, int n2) {
        if (this.callback == null) return;
        if (!this.callback.isProgress()) return;
        if (bl) {
            this.publishProgress(new Object[]{2, l2, l3});
            return;
        }
        long l4 = SystemClock.uptimeMillis();
        if (l4 - this.time < (long)this.callback.getRate()) return;
        this.time = l4;
        this.publishProgress(new Object[]{2, l2, l3});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doInBackground(Object ... objectArray) {
        if (objectArray != null && objectArray.length == 3) {
            this.targetUri = String.valueOf(objectArray[1]);
            this.isResume = (Boolean)objectArray[2];
        }
        DownloadThreadPoolUtil.elementDowloadThreadPool.getActiveHandleList().add(this);
        LogUtils.d(TAG, "HttpHandler onBackGroundThread ->" + Thread.currentThread());
        this.setCurrentThreadPriority(this.mPriority);
        try {
            this.publishProgress(new Object[]{1});
            this.makeRequestWithRetries((Request)objectArray[0]);
            LogUtils.d("", "Userstop no");
        }
        catch (IOException iOException) {
            LogUtils.d("", "Userstop" + iOException.getMessage());
            this.publishProgress(new Object[]{3, iOException, 0, iOException.getMessage()});
        }
        this.setCurrentThreadPriority(5);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof HttpFileHandler)) return super.equals(object);
        if (!TextUtils.equals((CharSequence)this.downloadUrl, (CharSequence)((HttpFileHandler)object).downloadUrl)) return super.equals(object);
        return true;
    }

    public FileDownloadFinishCallBack<T> getCallback() {
        return this.callback;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isResume() {
        return this.isResume;
    }

    public boolean isStop() {
        return this.mFileEntityHandler.isStop();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onProgressUpdate(Object ... objectArray) {
        int n2 = Integer.valueOf(String.valueOf(objectArray[0]));
        LogUtils.d("", "handleProgress -->" + n2);
        switch (n2) {
            case 1: {
                if (this.callback == null) break;
                this.callback.onStart();
                break;
            }
            case 2: {
                if (this.callback == null) break;
                this.callback.onLoading(Long.valueOf(String.valueOf(objectArray[1])), Long.valueOf(String.valueOf(objectArray[2])), 0, 1);
                break;
            }
            case 3: {
                DownloadThreadPoolUtil.elementDowloadThreadPool.activeHandlers.remove(this);
                if (this.callback == null) break;
                this.callback.onFailure((Throwable)objectArray[1], (Integer)objectArray[2], (String)objectArray[3]);
                break;
            }
            case 4: {
                DownloadThreadPoolUtil.elementDowloadThreadPool.activeHandlers.remove(this);
                if (this.callback == null) break;
                this.callback.onSuccess(objectArray[1], 0);
                break;
            }
        }
        super.onProgressUpdate(objectArray);
    }

    public void setCurrentThreadPriority(int n2) {
        Thread.currentThread().setPriority(n2);
    }

    public void setDownloadUrl(String string2) {
        this.downloadUrl = string2;
    }

    public void setResume(boolean bl) {
        this.isResume = bl;
    }

    public void stop() {
        this.mFileEntityHandler.setStop(true);
    }
}

