/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.download;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Build;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.wuba.cache.download.FileDownloadFinishCallBack;
import com.wuba.cache.download.HttpFileHandler;
import com.wuba.cache.download.HttpFilesHandler;
import com.wuba.cache.download.b;
import com.wuba.recorder.util.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DownloadThreadPool {
    private static final String TAG = DownloadThreadPool.class.getSimpleName();
    static int maxConnections;
    static int socketTimeout;
    public ArrayList<AsyncTask> activeHandlers;
    public int currentHighestPriority = 4;
    private boolean isPreemptedFileTaskInList = false;
    private boolean isPreemptedState = true;
    private ThreadPoolExecutor mDownloadThreadPoolExecutor;
    int maxRetries = 1;
    private int maxThreadPoolCount = 3;
    int priority = 5;
    private final ThreadFactory sNormalThreadFactory = new b(this);

    static {
        socketTimeout = 5000;
        maxConnections = 10;
    }

    public DownloadThreadPool(int n2) {
        this.activeHandlers = new ArrayList();
        this.maxThreadPoolCount = n2;
        this.mDownloadThreadPoolExecutor = new ThreadPoolExecutor(n2, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.mDownloadThreadPoolExecutor.setThreadFactory(this.sNormalThreadFactory);
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=11)
    private void executeFileDownload(HttpFileHandler httpFileHandler, Request request, String string2, boolean bl) {
        boolean bl2;
        AsyncTask asyncTask = null;
        if (this.getActiveHandleList().size() + 1 > this.maxThreadPoolCount) {
            asyncTask = this.getFirstActiveHandler();
            this.pause(asyncTask);
            this.mDownloadThreadPoolExecutor.purge();
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (httpFileHandler.getStatus() != AsyncTask.Status.RUNNING) {
            if (bl2 || this.getActiveHandleList().size() == this.maxThreadPoolCount - 1) {
                httpFileHandler.setCurrentThreadPriority(this.currentHighestPriority);
            }
            if (Build.VERSION.SDK_INT >= 11) {
                httpFileHandler.executeOnExecutor(this.mDownloadThreadPoolExecutor, new Object[]{request, string2, true});
            } else {
                httpFileHandler.execute(new Object[]{request, string2, true});
            }
        }
        if (asyncTask == null) {
            return;
        }
        if (!bl2) return;
        if (!(asyncTask instanceof HttpFileHandler)) return;
        if (!this.isPreemptedFileTaskInList) {
            LogUtils.d("", "LogFileThreadPool-->notify failure");
            ((HttpFileHandler)asyncTask).getCallback().onFailure(new Throwable(), -100, "Be Preempted");
            return;
        }
        httpFileHandler = HttpFileHandler.newInstanceAsyncTask((HttpFileHandler)asyncTask);
        if (Build.VERSION.SDK_INT >= 11) {
            httpFileHandler.executeOnExecutor(this.mDownloadThreadPoolExecutor, new Object[]{request, string2, true});
            return;
        }
        httpFileHandler.execute(new Object[]{request, string2, true});
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=11)
    private void executeFilesDownload(HttpFilesHandler httpFilesHandler, Request[] requestArray, String[] stringArray, boolean bl) {
        boolean bl2;
        LogUtils.d("", "LogFilesThreadPool activeHandlers" + this.activeHandlers.size());
        AsyncTask asyncTask = null;
        if (this.getActiveHandleList().size() + 1 > this.maxThreadPoolCount) {
            asyncTask = this.getFirstActiveHandler();
            this.pause(asyncTask);
            this.mDownloadThreadPoolExecutor.purge();
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (httpFilesHandler.getStatus() != AsyncTask.Status.RUNNING) {
            if (bl2 || this.getActiveHandleList().size() == this.maxThreadPoolCount - 1) {
                httpFilesHandler.setCurrentThreadPriority(this.currentHighestPriority);
            }
            if (Build.VERSION.SDK_INT >= 11) {
                httpFilesHandler.executeOnExecutor(this.mDownloadThreadPoolExecutor, new Object[]{requestArray, stringArray, true});
            } else {
                httpFilesHandler.execute(new Object[]{requestArray, stringArray, true});
            }
        }
        if (asyncTask == null) {
            return;
        }
        if (!bl2) return;
        if (!(asyncTask instanceof HttpFilesHandler)) return;
        if (!this.isPreemptedFileTaskInList) {
            LogUtils.d("", "LogFileThreadPool-->notify failure");
            ((HttpFilesHandler)asyncTask).getCallback().onFailure(new Throwable(), -100, "Be Preempted");
            return;
        }
        httpFilesHandler = HttpFilesHandler.newInstanceAsyncTask((HttpFilesHandler)asyncTask);
        if (Build.VERSION.SDK_INT >= 11) {
            httpFilesHandler.executeOnExecutor(this.mDownloadThreadPoolExecutor, new Object[]{requestArray, stringArray, true});
            return;
        }
        httpFilesHandler.execute(new Object[]{requestArray, stringArray, true});
    }

    public void LogFileThreadPool() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active:" + this.mDownloadThreadPoolExecutor.getActiveCount());
        stringBuffer.append("#Complete:" + this.mDownloadThreadPoolExecutor.getCompletedTaskCount());
        stringBuffer.append("#TaskCount:" + this.mDownloadThreadPoolExecutor.getTaskCount());
    }

    public AsyncTask downloadFile(String string2, String string3, FileDownloadFinishCallBack fileDownloadFinishCallBack) {
        return this.downloadFile(string2, string3, false, fileDownloadFinishCallBack);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AsyncTask downloadFile(String string2, String string3, boolean bl, FileDownloadFinishCallBack fileDownloadFinishCallBack) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = new Request.Builder().url(string2).build();
        HttpFileHandler httpFileHandler = null;
        httpFileHandler = bl ? new HttpFileHandler(string2, okHttpClient, fileDownloadFinishCallBack, bl) : new HttpFileHandler(string2, okHttpClient, fileDownloadFinishCallBack, bl);
        this.executeFileDownload(httpFileHandler, request, string3, true);
        this.LogFileThreadPool();
        return httpFileHandler;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncTask downloadFiles(String[] stringArray, String[] stringArray2, boolean bl, FileDownloadFinishCallBack fileDownloadFinishCallBack) {
        void var1_3;
        void var2_5;
        if (stringArray == null || var2_5 == null || stringArray.length != ((void)var2_5).length) {
            Object var1_2 = null;
            return var1_3;
        }
        OkHttpClient okHttpClient = new OkHttpClient();
        int n2 = stringArray.length;
        Request[] requestArray = new Request[n2];
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                void var3_6;
                void var4_7;
                HttpFilesHandler httpFilesHandler = new HttpFilesHandler(stringArray, okHttpClient, var4_7, (boolean)var3_6);
                this.executeFilesDownload(httpFilesHandler, requestArray, (String[])var2_5, true);
                this.LogFileThreadPool();
                return var1_3;
            }
            String string2 = stringArray[n3];
            string2.trim();
            try {
                Request.Builder builder = new Request.Builder();
                requestArray[n3] = builder.url(string2).build();
            }
            catch (Exception exception) {
                requestArray[n3] = new Request.Builder().url("https://null").build();
            }
            ++n3;
        }
    }

    public ArrayList<AsyncTask> getActiveHandleList() {
        return this.activeHandlers;
    }

    public ThreadPoolExecutor getFileDownloadThreadPool() {
        return this.mDownloadThreadPoolExecutor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsyncTask getFirstActiveHandler() {
        if (this.activeHandlers == null) return null;
        if (this.activeHandlers.size() <= 0) return null;
        return this.activeHandlers.get(0);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.mDownloadThreadPoolExecutor;
    }

    public void onDestroy() {
        this.mDownloadThreadPoolExecutor.shutdownNow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pause(AsyncTask asyncTask) {
        if (asyncTask == null) {
            return;
        }
        if (asyncTask instanceof HttpFileHandler) {
            ((HttpFileHandler)asyncTask).stop();
        }
        if (asyncTask instanceof HttpFilesHandler) {
            ((HttpFilesHandler)asyncTask).stop();
        }
        asyncTask.cancel(true);
        try {
            if (this.activeHandlers == null) return;
            if (!this.activeHandlers.contains(asyncTask)) return;
            this.activeHandlers.remove(asyncTask);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pauseAll() {
        if (this.activeHandlers != null) {
            Iterator<AsyncTask> iterator = this.activeHandlers.iterator();
            while (iterator.hasNext()) {
                this.pause(iterator.next());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pauseOthers() {
        if (this.activeHandlers != null) {
            for (int i2 = 0; i2 < this.activeHandlers.size() - 1; ++i2) {
                this.pause(this.activeHandlers.get(i2));
            }
        }
    }

    public void setMaxConnections(int n2) {
        maxConnections = n2;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public void setThreadPoolCoreSize(int n2) {
        if (n2 >= 1 && n2 <= 3) {
            this.maxThreadPoolCount = n2;
            this.mDownloadThreadPoolExecutor.setCorePoolSize(n2);
        }
    }

    public void setTimeOut(int n2) {
        socketTimeout = n2;
    }
}

