/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.filters;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.FilterManager;
import com.wuba.api.filter.GLSLRender;
import com.wuba.api.filter.WImage;
import com.wuba.api.filter.common.NinePatchCodec;
import com.wuba.api.filter.common.SimpleUtil;
import com.wuba.api.filter.filters.CPUFilter;
import java.io.IOException;
import java.io.InputStream;

public class FrameFilter
extends BaseFilterDes {
    int frameBitmap;

    public FrameFilter(Parcel parcel) {
        super(parcel);
        this.frameBitmap = parcel.readInt();
    }

    public FrameFilter(String string2, int n2) {
        super(string2, GLSLRender.FILTER_SHADER_NONE, 0);
        this.frameBitmap = n2;
    }

    private static native WImage nativeProcess(WImage var0, Bitmap var1, int[] var2, int[] var3, int[] var4);

    @Override
    public BaseFilter newFilter() {
        return new FrameImpFilter(this, this.frameBitmap);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeInt(this.frameBitmap);
    }

    public static class FrameImpFilter
    extends CPUFilter {
        int frameBitmap;

        protected FrameImpFilter(BaseFilterDes baseFilterDes, int n2) {
            super(baseFilterDes);
            this.frameBitmap = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public WImage ApplyFilter(WImage wImage) {
            NinePatchCodec.NinePatch ninePatch;
            InputStream inputStream = FilterManager.main_Context.getResources().openRawResource(this.frameBitmap);
            try {
                ninePatch = NinePatchCodec.decodeNinePatch(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return wImage;
            }
            SimpleUtil.closeSilently(inputStream);
            inputStream = FilterManager.main_Context.getResources().openRawResource(this.frameBitmap);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            SimpleUtil.closeSilently(inputStream);
            return FrameFilter.nativeProcess(wImage, bitmap, ninePatch.xDivs, ninePatch.yDivs, new int[]{ninePatch.padLeft, ninePatch.padTop, ninePatch.padRight, ninePatch.padBottom});
        }
    }
}

