/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.common;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;

public class NinePatchCodec {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    public static NinePatch decodeNinePatch(InputStream inputStream) throws IOException {
        return NinePatchCodec.getNinePatch(new DataInputStream(inputStream));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void find9patchChunk(DataInput dataInput) throws IOException {
        dataInput.skipBytes(8);
        while (true) {
            int n2 = 0;
            try {
                int n3;
                n2 = n3 = dataInput.readInt();
            }
            catch (IOException iOException) {}
            if (dataInput.readInt() == 1852855395) {
                return;
            }
            dataInput.skipBytes(n2 + 4);
        }
    }

    public static NinePatch getNinePatch(DataInput dataInput) throws IOException {
        NinePatchCodec.find9patchChunk(dataInput);
        NinePatch ninePatch = new NinePatch();
        ninePatch.decode(dataInput);
        return ninePatch;
    }

    public static class NinePatch {
        public int[] colors;
        public byte numColors;
        public byte numXDivs;
        public byte numYDivs;
        public int padBottom;
        public int padLeft;
        public int padRight;
        public int padTop;
        public byte wasDeserialized;
        public int[] xDivs;
        public int[] yDivs;

        public void decode(DataInput dataInput) throws IOException {
            int n2;
            int n3 = 0;
            this.wasDeserialized = dataInput.readByte();
            this.numXDivs = dataInput.readByte();
            this.numYDivs = dataInput.readByte();
            this.numColors = dataInput.readByte();
            dataInput.skipBytes(8);
            this.padLeft = dataInput.readInt();
            this.padRight = dataInput.readInt();
            this.padTop = dataInput.readInt();
            this.padBottom = dataInput.readInt();
            dataInput.skipBytes(4);
            this.xDivs = new int[this.numXDivs];
            for (n2 = 0; n2 < this.numXDivs; ++n2) {
                this.xDivs[n2] = dataInput.readInt();
            }
            this.yDivs = new int[this.numYDivs];
            for (n2 = 0; n2 < this.numYDivs; ++n2) {
                this.yDivs[n2] = dataInput.readInt();
            }
            this.colors = new int[this.numColors];
            for (n2 = n3; n2 < this.numColors; ++n2) {
                this.colors[n2] = dataInput.readInt();
            }
        }

        public void encode(DataOutput dataOutput) throws IOException {
            int n2;
            int n3 = 0;
            dataOutput.writeByte(this.wasDeserialized);
            dataOutput.writeByte(this.numXDivs);
            dataOutput.writeByte(this.numYDivs);
            dataOutput.writeByte(this.numColors);
            dataOutput.writeInt(0);
            dataOutput.writeInt(0);
            dataOutput.writeInt(this.padLeft);
            dataOutput.writeInt(this.padRight);
            dataOutput.writeInt(this.padTop);
            dataOutput.writeInt(this.padBottom);
            dataOutput.writeInt(0);
            for (n2 = 0; n2 < this.numXDivs; ++n2) {
                dataOutput.writeInt(this.xDivs[n2]);
            }
            int n4 = 0;
            while (true) {
                if (n4 >= this.numYDivs) break;
                dataOutput.writeInt(this.yDivs[n4]);
                ++n4;
            }
            for (n2 = n3; n2 < this.numColors; ++n2) {
                dataOutput.writeInt(this.colors[n2]);
            }
        }
    }
}

