/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.os.Parcel;
import android.os.Parcelable;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.GLParam;
import com.wuba.api.filter.GLSLRender;
import com.wuba.filter.R;

public class BaseFilterDes
implements Parcelable {
    private static final int TYPE_BACK_CAMERA = 2;
    private static final int TYPE_FRONT_CAMERA = 1;
    private static final int TYPE_PHOTO_EDITOR = 4;
    protected boolean consumeLongTime = false;
    public String description = "";
    public String filter_tag = "";
    protected int fragmentShaderID;
    public String group = "";
    public int iconId;
    public String iconName;
    public int id;
    public boolean isNew = false;
    public boolean isPrefered;
    public String label = "";
    public EncryptId mEncryptId = EncryptId.ENCRYPT_0;
    private int mFilterType = 7;
    public int miniIconid;
    public String name = "";
    protected boolean onlyProcessSmallPic = false;
    protected boolean previewIsNoEffect = false;
    public String scene = "";
    public Object tag;
    protected int textureResID;
    public int useCount;

    public BaseFilterDes(Parcel parcel) {
        this.name = parcel.readString();
        this.fragmentShaderID = parcel.readInt();
        this.textureResID = parcel.readInt();
    }

    public BaseFilterDes(String string2, int n2, int n3) {
        this.name = string2;
        this.fragmentShaderID = n2;
        this.textureResID = n3;
        this.useCount = 0;
    }

    public static BaseFilterDes createABaoFilter() {
        return new BaseFilterDes("ABao", GLSLRender.FILTER_ABAO, R.raw.d1009_abaofilter);
    }

    public static BaseFilterDes createBeautyFilter() {
        return new BaseFilterDes("BeautyFilter", GLSLRender.FILTER_SHADER_BEAUTY, R.raw.d1001_gradient);
    }

    public static BaseFilterDes createLittleSunShine() {
        return new BaseFilterDes("LittleSunShine", GLSLRender.FILTER_LITTLE_SUN_SHINE, R.raw.d1011_yangguangwuyu);
    }

    public static BaseFilterDes createWarmFilter() {
        return new BaseFilterDes("Warm", GLSLRender.FILTER_WARM, R.raw.d1010_warmfilter);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof BaseFilterDes)) {
            return false;
        }
        object = (BaseFilterDes)object;
        return this.name.equals(((BaseFilterDes)object).name);
    }

    public int getFilterType() {
        return this.mFilterType;
    }

    public int getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConsumeLongTime() {
        return this.consumeLongTime;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isOnlyProcessSmallPic() {
        return this.onlyProcessSmallPic;
    }

    public boolean isPreviewIsNoEffect() {
        return this.previewIsNoEffect;
    }

    public BaseFilter newFilter() {
        BaseFilter baseFilter = new BaseFilter(this, this.fragmentShaderID);
        if (this.textureResID > 0) {
            baseFilter.addParam(new GLParam.TextureResGLParam("inputImageTexture2", this.textureResID, 33985));
        }
        return baseFilter;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.name);
        parcel.writeInt(this.fragmentShaderID);
        parcel.writeInt(this.textureResID);
    }

    public static enum EncryptId {
        ENCRYPT_0,
        ENCRYPT_1,
        ENCRYPT_2;

    }
}

