/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.android.wrtckit.util;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import com.common.gmacs.utils.GmacsEnvi;

public class BitmapUtil {
    public static Bitmap CircleBitmap(Bitmap bitmap) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        RectF rectF = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        Canvas canvas = new Canvas(bitmap2);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        canvas.drawRoundRect(rectF, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), paint);
        return bitmap2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap FastBlur(Bitmap bitmap) {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 8;
        if (bitmap == null) {
            return null;
        }
        int n7 = bitmap.getWidth();
        if (GmacsEnvi.screenHeight * n7 > GmacsEnvi.screenWidth * (n4 = bitmap.getWidth())) {
            n2 = n3 = n4 / 8;
            if (n3 == 0) {
                n2 = 8;
            }
            if ((n3 = GmacsEnvi.screenWidth * n4 / GmacsEnvi.screenHeight / 8) != 0) {
                n6 = n3;
            }
            n5 = (n7 - GmacsEnvi.screenWidth * n4 / GmacsEnvi.screenHeight) / 2;
            n7 = n2;
            n3 = 0;
            n2 = n5;
        } else {
            n2 = n3 = n7 / 8;
            if (n3 == 0) {
                n2 = 8;
            }
            if ((n3 = GmacsEnvi.screenHeight * n7 / GmacsEnvi.screenWidth / 8) != 0) {
                n6 = n3;
            }
            n3 = (n4 - GmacsEnvi.screenHeight * n7 / GmacsEnvi.screenWidth) / 2;
            n7 = n6;
            n6 = n2;
            n2 = n5;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n6, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.scale(0.125f, 0.125f);
        Paint paint = new Paint(2);
        canvas.drawBitmap(bitmap, (float)(-n2), (float)(-n3), paint);
        BitmapUtil.GaussBlur(bitmap2, 4);
        return bitmap2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void GaussBlur(Bitmap bitmap, int n2) {
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        if (n2 < 1) {
            return;
        }
        int n15 = bitmap.getWidth();
        int n16 = bitmap.getHeight();
        int[] nArray2 = new int[n15 * n16];
        bitmap.getPixels(nArray2, 0, n15, 0, 0, n15, n16);
        int[] nArray3 = BitmapUtil.setBitmapPixDefaultAlpha(nArray2);
        int n17 = n15 - 1;
        int n18 = n16 - 1;
        int n19 = n15 * n16;
        int n20 = n2 + n2 + 1;
        nArray2 = new int[n19];
        int[] nArray4 = new int[n19];
        int[] nArray5 = new int[n19];
        int[] nArray6 = new int[Math.max(n15, n16)];
        n19 = n20 + 1 >> 1;
        int n21 = n19 * n19;
        int[] nArray7 = new int[n21 * 256];
        for (n19 = 0; n19 < n21 * 256; ++n19) {
            nArray7[n19] = n19 / n21;
        }
        int[][] nArray8 = new int[n20][3];
        int n22 = n2 + 1;
        int n23 = 0;
        n19 = 0;
        int n24 = 0;
        while (true) {
            if (n24 >= n16) break;
            n21 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            for (n6 = -n2; n6 <= n2; ++n6) {
                n5 = nArray3[Math.min(n17, Math.max(n6, 0)) + n19];
                nArray = nArray8[n6 + n2];
                nArray[0] = (0xFF0000 & n5) >> 16;
                nArray[1] = (0xFF00 & n5) >> 8;
                nArray[2] = n5 & 0xFF;
                n5 = n22 - Math.abs(n6);
                n8 += nArray[0] * n5;
                n9 += nArray[1] * n5;
                n10 += n5 * nArray[2];
                if (n6 > 0) {
                    n14 += nArray[0];
                    n7 += nArray[1];
                    n21 += nArray[2];
                    continue;
                }
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
            }
            n5 = n8;
            n4 = 0;
            n8 = n2;
            n6 = n9;
            n9 = n10;
            for (n10 = n4; n10 < n15; n14 -= nArray[0], n7 -= nArray[1], n21 -= nArray[2], ++n19, ++n10) {
                nArray2[n19] = nArray7[n5];
                nArray4[n19] = nArray7[n6];
                nArray5[n19] = nArray7[n9];
                nArray = nArray8[(n8 - n2 + n20) % n20];
                int n25 = nArray[0];
                n3 = nArray[1];
                n4 = nArray[2];
                if (n24 == 0) {
                    nArray6[n10] = Math.min(n10 + n2 + 1, n17);
                }
                int n26 = nArray3[nArray6[n10] + n23];
                nArray[0] = (0xFF0000 & n26) >> 16;
                nArray[1] = (0xFF00 & n26) >> 8;
                nArray[2] = n26 & 0xFF;
                n5 = n5 - n11 + (n14 += nArray[0]);
                n6 = n6 - n12 + (n7 += nArray[1]);
                n9 = n9 - n13 + (n21 += nArray[2]);
                n8 = (n8 + 1) % n20;
                nArray = nArray8[n8 % n20];
                n11 = n11 - n25 + nArray[0];
                n12 = n12 - n3 + nArray[1];
                n13 = n13 - n4 + nArray[2];
            }
            n23 += n15;
            ++n24;
        }
        n19 = 0;
        while (true) {
            if (n19 >= n15) {
                bitmap.setPixels(nArray3, 0, n15, 0, 0, n15, n16);
                return;
            }
            n8 = 0;
            n23 = -n2 * n15;
            n10 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n21 = 0;
            n14 = 0;
            n7 = 0;
            n9 = 0;
            for (n24 = -n2; n24 <= n2; ++n24) {
                n6 = Math.max(0, n23) + n19;
                nArray = nArray8[n24 + n2];
                nArray[0] = nArray2[n6];
                nArray[1] = nArray4[n6];
                nArray[2] = nArray5[n6];
                n4 = n22 - Math.abs(n24);
                n5 = nArray2[n6];
                n17 = nArray4[n6];
                n3 = nArray5[n6];
                if (n24 > 0) {
                    n10 += nArray[0];
                    n9 += nArray[1];
                    n8 += nArray[2];
                } else {
                    n11 += nArray[0];
                    n12 += nArray[1];
                    n13 += nArray[2];
                }
                n6 = n23;
                if (n24 < n18) {
                    n6 = n23 + n15;
                }
                n21 = n3 * n4 + n21;
                n14 = n17 * n4 + n14;
                n7 = n5 * n4 + n7;
                n23 = n6;
            }
            n5 = n14;
            n14 = n7;
            n17 = 0;
            n7 = n19;
            n24 = n8;
            n23 = n9;
            n6 = n10;
            n4 = n12;
            n12 = n11;
            n9 = n2;
            n10 = n5;
            n8 = n21;
            n11 = n4;
            for (n21 = n17; n21 < n16; n6 -= nArray[0], n23 -= nArray[1], n24 -= nArray[2], n7 += n15, ++n21) {
                nArray3[n7] = 0xFF000000 & nArray3[n7] | nArray7[n14] << 16 | nArray7[n10] << 8 | nArray7[n8];
                nArray = nArray8[(n9 - n2 + n20) % n20];
                n17 = nArray[0];
                n4 = nArray[1];
                n5 = nArray[2];
                if (n19 == 0) {
                    nArray6[n21] = Math.min(n21 + n22, n18) * n15;
                }
                n3 = nArray6[n21] + n19;
                nArray[0] = nArray2[n3];
                nArray[1] = nArray4[n3];
                nArray[2] = nArray5[n3];
                n14 = n14 - n12 + (n6 += nArray[0]);
                n10 = n10 - n11 + (n23 += nArray[1]);
                n8 = n8 - n13 + (n24 += nArray[2]);
                n9 = (n9 + 1) % n20;
                nArray = nArray8[n9];
                n12 = n12 - n17 + nArray[0];
                n11 = n11 - n4 + nArray[1];
                n13 = n13 - n5 + nArray[2];
            }
            ++n19;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] setBitmapPixDefaultAlpha(int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = (nArray[n3] & 0xFFFFFF) == 0 ? -1 : nArray[n3] | 0xFF000000;
            ++n3;
        }
        return nArray2;
    }
}

