/*
 * Decompiled with CFR 0.152.
 */
package com.wuba;

import android.opengl.GLES20;
import com.wuba.PhotoSimple;
import com.wuba.api.filter.common.RendererUtils;

public class ColorTemperatureFilter {
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_sampler;\nuniform float scaleC;\nuniform float scaleT;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler, v_texcoord);\n  vec3 new_color = color.rgb;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scaleC;\n  new_color.b = color.b - color.b * ( 1.0 - color.b) * scaleC;\n  if (scaleC > 0.0) { \n    new_color.g = color.g + color.g * ( 1.0 - color.g) * scaleC * 0.25;\n  }\n  float max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  color.rgb = new_color;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scaleT;\n  new_color.b = color.b + color.b * ( 1.0 - color.b) * scaleT;\n  new_color.g = color.g - color.g * ( 1.0 - color.g) * scaleT;\n  max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  gl_FragColor = vec4(new_color, color.a);\n}\n";
    private static final float[] POS_VERTICES;
    private static final float[] TEX_VERTICES;
    private static final String VERTEX_SHADER = "attribute vec4 a_position;\nattribute vec2 a_texcoord;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_Position = a_position;\n  v_texcoord = a_texcoord;\n}\n";
    RendererUtils.FilterContext filterContext;
    public float mScaleC = 0.5f;
    public float mScaleT = 0.5f;

    static {
        TEX_VERTICES = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        POS_VERTICES = new float[]{-1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f};
    }

    public int getId() {
        return 2;
    }

    public void process(PhotoSimple photoSimple, PhotoSimple photoSimple2) {
        GLES20.glBindTexture((int)3553, (int)photoSimple2.texture());
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        this.filterContext = RendererUtils.createFilterProgram(VERTEX_SHADER, FRAGMENT_SHADER, POS_VERTICES, TEX_VERTICES);
        GLES20.glUseProgram((int)this.filterContext.shaderProgram);
        GLES20.glUniform1f((int)GLES20.glGetUniformLocation((int)this.filterContext.shaderProgram, (String)"scaleC"), (float)((this.mScaleC - 0.5f) * 1.5f));
        GLES20.glUniform1f((int)GLES20.glGetUniformLocation((int)this.filterContext.shaderProgram, (String)"scaleT"), (float)((this.mScaleT - 0.5f) * 1.5f));
        RendererUtils.renderTexture2FBO(this.filterContext, photoSimple.texture(), photoSimple2.texture(), photoSimple2.width(), photoSimple2.height());
    }

    public void release() {
        if (this.filterContext != null && this.filterContext.shaderProgram != 0) {
            GLES20.glDeleteProgram((int)this.filterContext.shaderProgram);
            this.filterContext.shaderProgram = 0;
        }
        this.filterContext = null;
    }

    public void setScale(float f2, float f3) {
        this.mScaleC = f2;
        this.mScaleT = f3;
    }
}

