/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;

public class WXMusicObject
implements WXMediaMessage.IMediaObject {
    private static final int LENGTH_LIMIT = 10240;
    private static final String TAG = "MicroMsg.SDK.WXMusicObject";
    public String musicDataUrl;
    public String musicLowBandDataUrl;
    public String musicLowBandUrl;
    public String musicUrl;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (!(this.musicUrl != null && this.musicUrl.length() != 0 || this.musicLowBandUrl != null && this.musicLowBandUrl.length() != 0)) {
            Log.e(TAG, "both arguments are null");
            return bl;
        }
        if (this.musicUrl != null && this.musicUrl.length() > 10240) {
            Log.e(TAG, "checkArgs fail, musicUrl is too long");
            return bl;
        }
        if (this.musicLowBandUrl == null) return true;
        if (this.musicLowBandUrl.length() <= 10240) return true;
        Log.e(TAG, "checkArgs fail, musicLowBandUrl is too long");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putString("_wxmusicobject_musicUrl", this.musicUrl);
        bundle.putString("_wxmusicobject_musicLowBandUrl", this.musicLowBandUrl);
        bundle.putString("_wxmusicobject_musicDataUrl", this.musicDataUrl);
        bundle.putString("_wxmusicobject_musicLowBandDataUrl", this.musicLowBandDataUrl);
    }

    public int type() {
        return 3;
    }

    public void unserialize(Bundle bundle) {
        this.musicUrl = bundle.getString("_wxmusicobject_musicUrl");
        this.musicLowBandUrl = bundle.getString("_wxmusicobject_musicLowBandUrl");
        this.musicDataUrl = bundle.getString("_wxmusicobject_musicDataUrl");
        this.musicLowBandDataUrl = bundle.getString("_wxmusicobject_musicLowBandDataUrl");
    }
}

