/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.OkHttpDownloader;
import com.squareup.picasso.Request;
import com.squareup.picasso.UrlConnectionDownloader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ThreadFactory;

final class Utils {
    static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    static final int DEFAULT_READ_TIMEOUT = 20000;
    private static final int KEY_PADDING = 50;
    static final StringBuilder MAIN_THREAD_KEY_BUILDER = new StringBuilder();
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final String PICASSO_CACHE = "picasso-cache";
    static final String THREAD_IDLE_NAME = "Picasso-Idle";
    static final String THREAD_PREFIX = "Picasso-";
    private static final String WEBP_FILE_HEADER_RIFF = "RIFF";
    private static final int WEBP_FILE_HEADER_SIZE = 12;
    private static final String WEBP_FILE_HEADER_WEBP = "WEBP";

    private Utils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static long calculateDiskCacheSize(File file) {
        long l2;
        try {
            StatFs statFs = new StatFs(file.getAbsolutePath());
            l2 = statFs.getBlockCount();
            l2 = (long)statFs.getBlockSize() * l2 / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l2 = 0x500000L;
            return Math.max(Math.min(l2, 0x3200000L), 0x500000L);
        }
        return Math.max(Math.min(l2, 0x3200000L), 0x500000L);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int calculateMemoryCacheSize(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int n2 = (context.getApplicationInfo().flags & 0x100000) != 0 ? 1 : 0;
        int n3 = activityManager.getMemoryClass();
        if (n2 != 0 && Build.VERSION.SDK_INT >= 11) {
            n2 = ActivityManagerHoneycomb.getLargeMemoryClass(activityManager);
            return n2 * 0x100000 / 7;
        }
        n2 = n3;
        return n2 * 0x100000 / 7;
    }

    static void checkNotMain() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Method call should not happen from the main thread.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static File createDefaultCacheDir(Context object) {
        if (!((File)(object = new File(object.getApplicationContext().getCacheDir(), PICASSO_CACHE))).exists()) {
            ((File)object).mkdirs();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Downloader createDefaultDownloader(Context object) {
        void var0_2;
        try {
            Downloader downloader;
            Class.forName("com.squareup.okhttp.OkHttpClient");
            Downloader downloader2 = downloader = OkHttpLoaderCreator.create(object);
            return var0_2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            UrlConnectionDownloader urlConnectionDownloader = new UrlConnectionDownloader((Context)object);
            return var0_2;
        }
    }

    static String createKey(Request object) {
        object = Utils.createKey((Request)object, MAIN_THREAD_KEY_BUILDER);
        MAIN_THREAD_KEY_BUILDER.setLength(0);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String createKey(Request request, StringBuilder stringBuilder) {
        if (request.uri != null) {
            String string2 = request.uri.toString();
            stringBuilder.ensureCapacity(string2.length() + 50);
            stringBuilder.append(string2);
        } else {
            stringBuilder.ensureCapacity(50);
            stringBuilder.append(request.resourceId);
        }
        stringBuilder.append('\n');
        if (request.rotationDegrees != 0.0f) {
            stringBuilder.append("rotation:").append(request.rotationDegrees);
            if (request.hasRotationPivot) {
                stringBuilder.append('@').append(request.rotationPivotX).append('x').append(request.rotationPivotY);
            }
            stringBuilder.append('\n');
        }
        if (request.targetWidth != 0) {
            stringBuilder.append("resize:").append(request.targetWidth).append('x').append(request.targetHeight);
            stringBuilder.append('\n');
        }
        if (request.centerCrop) {
            stringBuilder.append("centerCrop\n");
        } else if (request.centerInside) {
            stringBuilder.append("centerInside\n");
        }
        if (request.transformations != null) {
            int n2 = request.transformations.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(request.transformations.get(i2).key());
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    static int getBitmapBytes(Bitmap bitmap) {
        int n2 = Build.VERSION.SDK_INT >= 12 ? BitmapHoneycombMR1.getByteCount(bitmap) : bitmap.getRowBytes() * bitmap.getHeight();
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getResourceId(Resources resources, Request object) throws FileNotFoundException {
        if (((Request)object).resourceId != 0) return ((Request)object).resourceId;
        if (((Request)object).uri == null) {
            return ((Request)object).resourceId;
        }
        String string2 = ((Request)object).uri.getAuthority();
        if (string2 == null) {
            throw new FileNotFoundException("No package provided: " + ((Request)object).uri);
        }
        List list = ((Request)object).uri.getPathSegments();
        if (list == null) throw new FileNotFoundException("No path segments: " + ((Request)object).uri);
        if (list.isEmpty()) {
            throw new FileNotFoundException("No path segments: " + ((Request)object).uri);
        }
        if (list.size() == 1) {
            try {
                return Integer.parseInt((String)list.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FileNotFoundException("Last path segment is not a resource ID: " + ((Request)object).uri);
            }
        }
        if (list.size() != 2) throw new FileNotFoundException("More than two path segments: " + ((Request)object).uri);
        object = (String)list.get(0);
        return resources.getIdentifier((String)list.get(1), (String)object, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Resources getResources(Context context, Request request) throws FileNotFoundException {
        if (request.resourceId != 0) return context.getResources();
        if (request.uri == null) {
            return context.getResources();
        }
        String string2 = request.uri.getAuthority();
        if (string2 == null) {
            throw new FileNotFoundException("No package provided: " + request.uri);
        }
        try {
            return context.getPackageManager().getResourcesForApplication(string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new FileNotFoundException("Unable to obtain resources for package: " + request.uri);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean hasPermission(Context context, String string2) {
        if (context.checkCallingOrSelfPermission(string2) != 0) return false;
        return true;
    }

    static boolean isAirplaneModeOn(Context context) {
        boolean bl = false;
        if (Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0) {
            bl = true;
        }
        return bl;
    }

    static boolean isWebPFile(InputStream inputStream) throws IOException {
        boolean bl = false;
        byte[] byArray = new byte[12];
        boolean bl2 = bl;
        if (inputStream.read(byArray, 0, 12) == 12) {
            bl2 = bl;
            if (WEBP_FILE_HEADER_RIFF.equals(new String(byArray, 0, 4, "US-ASCII"))) {
                bl2 = bl;
                if (WEBP_FILE_HEADER_WEBP.equals(new String(byArray, 8, 4, "US-ASCII"))) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean parseResponseSourceHeader(String stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        if (stringArray == null) {
            return bl2;
        }
        if ("CACHE".equals((stringArray = stringArray.split(" ", 2))[0])) {
            return true;
        }
        boolean bl3 = bl2;
        if (stringArray.length == 1) return bl3;
        try {
            if (!"CONDITIONAL_CACHE".equals(stringArray[0])) return false;
            int n2 = Integer.parseInt(stringArray[1]);
            if (n2 != 304) return false;
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            return bl2;
        }
    }

    static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while (-1 != (n2 = inputStream.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    @TargetApi(value=12)
    private static class BitmapHoneycombMR1 {
        private BitmapHoneycombMR1() {
        }

        static int getByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }

    private static class OkHttpLoaderCreator {
        private OkHttpLoaderCreator() {
        }

        static Downloader create(Context context) {
            return new OkHttpDownloader(context);
        }
    }

    private static class PicassoThread
    extends Thread {
        public PicassoThread(Runnable runnable) {
            super(runnable);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    static class PicassoThreadFactory
    implements ThreadFactory {
        PicassoThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new PicassoThread(runnable);
        }
    }
}

